/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.editor.dialog;

import de.markusbordihn.easynpc.client.screen.EditorScreen;
import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogTextData;
import de.markusbordihn.easynpc.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;

public class DialogTextEditorScreen<T extends EditorMenu>
extends EditorScreen<T> {
    private static final int MAX_NUMBER_OF_DIALOG_TEXTS = 6;
    private final Set<TextField> dialogTextFields = new HashSet<TextField>();
    protected class_4185 homeButton;
    protected class_4185 dialogButton;
    protected class_4185 dialogTextButton;
    protected class_4185 saveButton;
    protected class_4185 cancelButton;

    public DialogTextEditorScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    protected void saveDialogData() {
        HashSet<DialogTextData> validDialogTexts = new HashSet<DialogTextData>();
        for (TextField textfield : this.dialogTextFields) {
            String text = textfield.method_1882();
            if (text.isEmpty()) continue;
            validDialogTexts.add(new DialogTextData(text));
        }
        DialogDataEntry dialogDataEntry = this.getDialogData(this.getDialogUUID());
        dialogDataEntry.setDialogTexts(validDialogTexts);
        NetworkMessageHandlerManager.getServerHandler().saveDialog(this.getEasyNPCUUID(), this.getDialogUUID(), dialogDataEntry);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.homeButton = (class_4185)this.method_37063((class_364)new TextButton(this.leftPos + 7, this.topPos + 7, 10, 18, "<", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DIALOG)));
        this.dialogButton = (class_4185)this.method_37063((class_364)new DialogButton(this.homeButton.method_46426() + this.homeButton.method_25368(), this.topPos + 7, 140, this.getDialogData().getName(21), onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID())));
        this.dialogTextButton = (class_4185)this.method_37063((class_364)new DialogButton(this.dialogButton.method_46426() + this.dialogButton.method_25368(), this.topPos + 7, 140, "Dialog Text", onPress -> {}));
        this.dialogTextButton.field_22763 = false;
        int dialogTextIndex = 0;
        int dialogTextLeftPos = this.leftPos + 20;
        int dialogTextTopPos = this.topPos + 50;
        int dialogTextWidth = 290;
        Set<DialogTextData> dialogTexts = this.getDialogData(this.getDialogUUID()).getDialogTexts();
        for (DialogTextData dialogText : dialogTexts) {
            if (dialogTextIndex >= 6) break;
            TextField textfield = (TextField)this.method_37063((class_364)new TextField(this.field_22793, dialogTextLeftPos, dialogTextTopPos + dialogTextIndex * 20, dialogTextWidth, dialogText.text(), 512));
            this.dialogTextFields.add(textfield);
            ++dialogTextIndex;
        }
        for (int i = dialogTextIndex; i < 6; ++i) {
            TextField textfield = (TextField)this.method_37063((class_364)new TextField(this.field_22793, dialogTextLeftPos, dialogTextTopPos + i * 20, dialogTextWidth, "", 512));
            this.dialogTextFields.add(textfield);
        }
        this.saveButton = (class_4185)this.method_37063((class_364)new SaveButton(this.leftPos + 25, this.bottomPos - 35, 85, "save", onPress -> {
            this.saveDialogData();
            NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID());
        }));
        this.cancelButton = (class_4185)this.method_37063((class_364)new CancelButton(this.saveButton.method_46426() + 95 + this.saveButton.method_25368() + 10, this.bottomPos - 35, 85, "cancel", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DIALOG)));
    }

    protected void renderEditLabels(class_332 guiGraphics) {
        Text.drawConfigString(guiGraphics, this.field_22793, "dialog.text", this.leftPos + 10, this.topPos + 34, 0);
        for (int i = 1; i <= 6; ++i) {
            Text.drawString(guiGraphics, this.field_22793, i + ":", this.leftPos + 10, this.topPos + 35 + i * 20, 0);
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        this.renderEditLabels(guiGraphics);
    }
}

