/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.editor.action;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.EditorScreen;
import de.markusbordihn.easynpc.client.screen.components.ActionsButton;
import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButtonButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.editor.action.ActionDataList;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class ActionDataEditorContainerScreen<T extends EditorMenu>
extends EditorScreen<T> {
    private final ActionDataSet actionDataSet;
    private final ActionEventType actionEventType = this.getAdditionalScreenData().getActionEventType();
    private final ConfigurationType configurationType = this.getAdditionalScreenData().getConfigurationType();
    private final EditorType editorType = this.getAdditionalScreenData().getEditorType();
    protected class_4185 homeButton;
    protected class_4185 navigationLevelOne;
    protected class_4185 navigationLevelTwo;
    protected class_4185 newActionDataEntryButton;
    ActionDataList actionDataList;

    public ActionDataEditorContainerScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
        this.actionDataSet = this.getActionDataSet();
    }

    private ActionDataSet getActionDataSet() {
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            return this.getAdditionalScreenData().getActionEventSet().getActionEvents(this.actionEventType);
        }
        if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            return this.getDialogButtonData().actionDataSet();
        }
        log.error("No valid action data set found!");
        return null;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.homeButton = (class_4185)this.method_37063((class_364)new TextButton(this.leftPos + 3, this.topPos + 3, 10, 18, "<", onPress -> this.handleBackNavigation()));
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            this.navigationLevelOne = (class_4185)this.method_37063((class_364)new ActionsButton(this.homeButton.method_46426() + this.homeButton.method_25368(), this.topPos + 3, 140, this.actionEventType.name(), onPress -> this.navigateToActionDataEditor()));
            this.navigationLevelOne.field_22763 = false;
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            this.navigationLevelOne = (class_4185)this.method_37063((class_364)new DialogButtonButton(this.homeButton.method_46426() + this.homeButton.method_25368(), this.topPos + 3, 140, this.getDialogButtonData().getButtonName(21).getString(), onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID())));
        } else {
            this.navigationLevelOne = (class_4185)this.method_37063((class_364)new ActionsButton(this.homeButton.method_46426() + this.homeButton.method_25368(), this.topPos + 3, 140, "Actions", onPress -> this.navigateToActionDataEditor()));
            this.navigationLevelOne.field_22763 = false;
        }
        if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            this.navigationLevelTwo = (class_4185)this.method_37063((class_364)new ActionsButton(this.navigationLevelOne.method_46426() + this.navigationLevelOne.method_25368(), this.topPos + 3, 140, "Actions", onPress -> this.navigateToActionDataEditor()));
            this.navigationLevelTwo.field_22763 = false;
        }
        this.newActionDataEntryButton = (class_4185)this.method_37063((class_364)new AddButton(this.leftPos + 7, this.topPos + 210, 300, "action.add", onPress -> this.handleNewActionDataEntry()));
        this.actionDataList = new ActionDataList(this.actionDataSet, this.field_22787, this.field_22789 + 50, 161, this.leftPos + 5, this.topPos + 40, this.topPos + 200, 21, this::handleMoveUpOrderActionDataEntry, this::handleMoveDownOrderActionDataEntry, this::handleEditActionDataEntry, this::handleDeleteActionDataEntry);
        this.method_25429((class_364)this.actionDataList);
    }

    private void navigateToActionDataEditor() {
        if (this.configurationType != null && this.configurationType != ConfigurationType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEditor(this.getEasyNPCUUID(), this.actionEventType, this.configurationType);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON && this.getDialogUUID() != null && this.getDialogButtonUUID() != null) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEditor(this.getEasyNPCUUID(), this.editorType, this.getDialogUUID(), this.getDialogButtonUUID());
        } else {
            log.error("No valid navigation found!");
            NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.MAIN);
        }
    }

    private void handleBackNavigation() {
        if (this.configurationType != null && this.configurationType != ConfigurationType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), this.configurationType);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON && this.getDialogUUID() != null && this.getDialogButtonUUID() != null) {
            NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID());
        } else {
            log.error("No valid back navigation found!");
            NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.MAIN);
        }
    }

    private void handleNewActionDataEntry() {
        if (this.configurationType != null && this.configurationType != ConfigurationType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), this.actionEventType, this.configurationType, new ActionDataEntry());
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), this.editorType, this.getDialogUUID(), this.getDialogButtonUUID(), new ActionDataEntry());
        } else {
            log.error("No valid new action data entry found!");
        }
    }

    private void handleDeleteActionDataEntry(ActionDataEntry actionDataEntry) {
        if (this.field_22787 == null || this.actionDataSet == null || actionDataEntry == null || actionDataEntry.getId() == Constants.EMPTY_UUID) {
            return;
        }
        this.field_22787.method_1507((class_437)new class_410(confirmed -> {
            if (confirmed) {
                this.actionDataSet.remove(actionDataEntry.getId());
                if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
                    NetworkMessageHandlerManager.getServerHandler().actionEventChange(this.getEasyNPCUUID(), this.actionEventType, this.actionDataSet);
                } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
                    NetworkMessageHandlerManager.getServerHandler().saveDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID(), this.getDialogButtonData().withActionDataSet(this.actionDataSet));
                } else {
                    log.error("Unable to delete Action Data Set {} for {}!", (Object)this.actionDataSet, (Object)this.getEasyNPCUUID());
                }
                this.navigateToActionDataEditor();
            } else {
                this.field_22787.method_1507((class_437)this);
            }
        }, (class_2561)TextComponent.getTranslatedText("removeActionDataEntry.deleteQuestion"), (class_2561)TextComponent.getTranslatedText("removeActionDataEntry.deleteWarning", actionDataEntry.actionDataType().toString()), (class_2561)TextComponent.getTranslatedText("removeActionDataEntry.deleteButton"), class_5244.field_24335));
    }

    private void handleEditActionDataEntry(ActionDataEntry actionDataEntry) {
        log.info("Editing Action Data Entry {}: {}", (Object)actionDataEntry.getId(), (Object)actionDataEntry);
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), this.actionEventType, this.configurationType, actionDataEntry);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), this.editorType, this.getDialogUUID(), this.getDialogButtonUUID(), actionDataEntry);
        } else {
            log.error("Unable to edit action data entry {}!", (Object)actionDataEntry);
        }
    }

    private void handleMoveUpOrderActionDataEntry(ActionDataEntry actionDataEntry) {
        log.info("Moving up Action Data Entry {}: {}", (Object)actionDataEntry.getId(), (Object)actionDataEntry);
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            this.actionDataSet.moveUp(actionDataEntry);
            NetworkMessageHandlerManager.getServerHandler().actionEventChange(this.getEasyNPCUUID(), this.actionEventType, this.actionDataSet);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            this.actionDataSet.moveUp(actionDataEntry);
            NetworkMessageHandlerManager.getServerHandler().saveDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID(), this.getDialogButtonData().withActionDataSet(this.actionDataSet));
        } else {
            log.error("Unable to move up Action Data Set {} for {}!", (Object)this.actionDataSet, (Object)this.getEasyNPCUUID());
        }
        this.navigateToActionDataEditor();
    }

    private void handleMoveDownOrderActionDataEntry(ActionDataEntry actionDataEntry) {
        log.info("Moving down Action Data Entry {}: {}", (Object)actionDataEntry.getId(), (Object)actionDataEntry);
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            this.actionDataSet.moveDown(actionDataEntry);
            NetworkMessageHandlerManager.getServerHandler().actionEventChange(this.getEasyNPCUUID(), this.actionEventType, this.actionDataSet);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            this.actionDataSet.moveDown(actionDataEntry);
            NetworkMessageHandlerManager.getServerHandler().saveDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID(), this.getDialogButtonData().withActionDataSet(this.actionDataSet));
        } else {
            log.error("Unable to move down Action Data Set {} for {}!", (Object)this.actionDataSet, (Object)this.getEasyNPCUUID());
        }
        this.navigateToActionDataEditor();
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        guiGraphics.method_25294(this.leftPos + 5, this.topPos + 30, this.leftPos + 314, this.topPos + 200, -1118482);
        if (this.actionDataList != null) {
            this.actionDataList.method_25394(guiGraphics, x, y, partialTicks);
        }
        this.renderHeader(guiGraphics);
        this.renderFooter(guiGraphics);
        if (this.newActionDataEntryButton != null) {
            this.newActionDataEntryButton.method_25394(guiGraphics, x, y, partialTicks);
        }
    }

    private void renderHeader(class_332 guiGraphics) {
        guiGraphics.method_25294(this.leftPos + 5, this.topPos + 25, this.leftPos + 314, this.topPos + 43, -5592406);
        int headerLeft = this.leftPos + 10;
        int headerTop = this.topPos + 30;
        Text.drawString(guiGraphics, this.field_22793, "ID", headerLeft + 0, headerTop, 0);
        Text.drawConfigString(guiGraphics, this.field_22793, "type", headerLeft + 22, headerTop, 0);
        Text.drawConfigString(guiGraphics, this.field_22793, "value", headerLeft + 130, headerTop, 0);
        Text.drawString(guiGraphics, this.field_22793, "Action", headerLeft + 230, headerTop, 0);
        int separatorTop = headerTop - 5;
        guiGraphics.method_25294(headerLeft + 22 - 3, separatorTop, headerLeft + 22 - 2, separatorTop + 18, -10066330);
        guiGraphics.method_25294(headerLeft + 130 - 3, separatorTop, headerLeft + 130 - 2, separatorTop + 18, -10066330);
        guiGraphics.method_25294(headerLeft + 230 - 3, separatorTop, headerLeft + 230 - 2, separatorTop + 18, -10066330);
    }

    private void renderFooter(class_332 guiGraphics) {
        guiGraphics.method_25294(this.leftPos + 5, this.topPos + 200, this.leftPos + 314, this.topPos + 231, -3750202);
    }
}

