/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.trading;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.configuration.trading.TradingConfigurationContainerScreen;
import de.markusbordihn.easynpc.data.trading.TradingDataSet;
import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class CustomTradingConfigurationContainerScreen<T extends ConfigurationMenu>
extends TradingConfigurationContainerScreen<T> {
    private static TradingType formerTradingType = TradingType.BASIC;
    protected Checkbox noneTradingCheckbox;
    protected int numberOfTextLines = 1;
    private List<class_5481> textComponents = Collections.emptyList();

    public CustomTradingConfigurationContainerScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    public static void setFormerTradingType(TradingType dialogType) {
        formerTradingType = dialogType;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.customTradesButton.field_22763 = false;
        TradingData<?> tradingData = this.getEasyNPC().getEasyNPCTradingData();
        TradingDataSet tradingDataSet = tradingData.getTradingDataSet();
        CustomTradingConfigurationContainerScreen.setFormerTradingType(tradingDataSet.getType());
        this.noneTradingCheckbox = (Checkbox)this.method_37063((class_364)new Checkbox(this.contentLeftPos + 100, this.field_2800 + 170, "custom_trading_checkbox", tradingDataSet.isType(TradingType.CUSTOM), checkbox -> {
            if (checkbox.selected()) {
                NetworkMessageHandlerManager.getServerHandler().changeTradingType(this.getEasyNPCUUID(), TradingType.CUSTOM);
            } else {
                NetworkMessageHandlerManager.getServerHandler().changeTradingType(this.getEasyNPCUUID(), formerTradingType != null && formerTradingType != TradingType.CUSTOM ? formerTradingType : TradingType.NONE);
            }
        }));
        this.textComponents = this.field_22793.method_1728((class_5348)TextComponent.getTranslatedConfigText("custom_trading_text"), this.field_2792 - 20);
        this.numberOfTextLines = this.textComponents.size();
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        if (!this.textComponents.isEmpty()) {
            for (int line = 0; line < this.numberOfTextLines; ++line) {
                class_5481 formattedCharSequence = this.textComponents.get(line);
                Objects.requireNonNull(this.field_22793);
                Text.drawString(guiGraphics, this.field_22793, formattedCharSequence, this.field_2776 + 15, this.field_2800 + 60 + line * (9 + 2));
            }
        }
    }
}

