/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.skin;

import de.markusbordihn.easynpc.client.screen.components.SkinSelectionButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.configuration.skin.SkinConfigurationScreen;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.ArrayList;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class DefaultSkinConfigurationScreen<T extends ConfigurationMenu>
extends SkinConfigurationScreen<T> {
    private static final float SKIN_NAME_SCALING = 0.7f;
    protected int numOfProfessions = 0;
    protected int numOfVariants = 0;

    public DefaultSkinConfigurationScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
        this.maxSkinsPerPage = 10;
    }

    private void renderSkins(class_332 guiGraphics) {
        if (this.getEasyNPCEntity() == null) {
            return;
        }
        int skinPosition = 0;
        this.skinButtons = new ArrayList();
        ProfessionData<?> professionData = this.getEasyNPC().getEasyNPCProfessionData();
        VariantData<?> variantData = this.getEasyNPC().getEasyNPCVariantData();
        for (int i = this.skinStartIndex; i < this.numOfSkins && i < this.skinStartIndex + this.maxSkinsPerPage; ++i) {
            int variantIndex = this.numOfProfessions > 0 ? i / this.numOfProfessions : i;
            Profession profession = this.numOfProfessions > 0 ? professionData.getProfessions()[i - variantIndex * this.numOfProfessions] : null;
            Enum<?> variant = variantData.getVariants()[variantIndex];
            int left = this.leftPos + (skinPosition > 4 ? -268 : 32) + skinPosition * 60;
            int top = this.contentTopPos + 102 + (skinPosition > 4 ? 84 : 0);
            this.renderSkinEntity(guiGraphics, left, top, variant, profession);
            int topNamePos = Math.round(((float)top - 76.0f) / 0.7f);
            int leftNamePos = Math.round(((float)left - 21.0f) / 0.7f);
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            guiGraphics.method_51448().method_22905(0.7f, 0.7f, 0.7f);
            String variantName = TextUtils.normalizeString(variant.name(), 14);
            Text.drawString(guiGraphics, this.field_22793, variantName, leftNamePos, topNamePos, 43520);
            if (profession != null) {
                String professionName = TextUtils.normalizeString(profession.name(), 13);
                Text.drawString(guiGraphics, this.field_22793, professionName, leftNamePos, topNamePos + 10, 0);
            }
            guiGraphics.method_51448().method_22909();
            ++skinPosition;
        }
    }

    private void renderSkinEntity(class_332 guiGraphics, int x, int y, Enum<?> variant, Profession profession) {
        SkinSelectionButton skinButton = new SkinSelectionButton(x - 24, y - 81, button -> {
            if (profession != null) {
                NetworkMessageHandlerManager.getServerHandler().changeProfession(this.getEasyNPCUUID(), profession);
            }
            NetworkMessageHandlerManager.getServerHandler().setDefaultSkin(this.getEasyNPCUUID(), variant);
        });
        SkinData<?> skinData = this.getEasyNPC().getEasyNPCSkinData();
        VariantData<?> variantData = this.getEasyNPC().getEasyNPCVariantData();
        ProfessionData<?> professionData = this.getEasyNPC().getEasyNPCProfessionData();
        skinButton.field_22763 = skinData.getSkinType() != SkinType.DEFAULT || !variantData.getVariant().equals(variant) || profession != null && !professionData.getProfession().equals((Object)profession);
        ScreenHelper.renderEntityDefaultSkin(guiGraphics, x + 4, y, (float)x - this.xMouse, (float)(y - 40) - this.yMouse, this.getEasyNPC(), variant, profession);
        this.skinButtons.add(skinButton);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.defaultSkinButton.field_22763 = false;
        this.setDescriptionText("default_skin.text");
        VariantData<?> variantData = this.getEasyNPC().getEasyNPCVariantData();
        ProfessionData<?> professionData = this.getEasyNPC().getEasyNPCProfessionData();
        this.numOfProfessions = professionData.hasProfessions() ? professionData.getProfessions().length : 0;
        this.numOfVariants = variantData.getVariants().length;
        this.numOfSkins = this.numOfProfessions > 0 ? this.numOfVariants * this.numOfProfessions : this.numOfVariants;
        log.debug("Found about {} skins with {} variants and {} professions.", (Object)this.numOfSkins, (Object)this.numOfVariants, (Object)this.numOfProfessions);
        this.defineSkinNavigationButtons();
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        this.renderDescriptionText(guiGraphics, this.contentLeftPos + 5, this.contentTopPos + 5);
        this.renderSkins(guiGraphics);
    }

    @Override
    protected void renderSkinSelectionBackground(class_332 guiGraphics) {
        guiGraphics.method_25294(this.contentLeftPos, this.contentTopPos + 20, this.contentLeftPos + 302, this.contentTopPos + 190, -16777216);
        guiGraphics.method_25294(this.contentLeftPos + 1, this.contentTopPos + 21, this.contentLeftPos + 301, this.contentTopPos + 189, -5592406);
    }
}

