/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.pose;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.RangeSliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.configuration.pose.PoseConfigurationScreen;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;

public class AdvancedPoseConfigurationScreen<T extends ConfigurationMenu>
extends PoseConfigurationScreen<T> {
    protected RangeSliderButton headRotationSliderButton;
    protected RangeSliderButton bodyRotationSliderButton;
    protected RangeSliderButton armsRotationSliderButton;
    protected RangeSliderButton leftArmRotationSliderButton;
    protected RangeSliderButton rightArmRotationSliderButton;
    protected RangeSliderButton leftLegRotationSliderButton;
    protected RangeSliderButton rightLegRotationSliderButton;

    public AdvancedPoseConfigurationScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    private RangeSliderButton createVisibilityRotationSlider(int left, int top, ModelPart modelPart, String label) {
        RangeSliderButton sliderRotationButtonX = this.createRotationSlider(left, top, modelPart, label);
        boolean modelPartVisibility = this.modelData.isModelPartVisible(modelPart);
        this.method_37063((class_364)new Checkbox(sliderRotationButtonX.method_46426() + 3, top - sliderRotationButtonX.method_25364(), "", modelPartVisibility, checkbox -> NetworkMessageHandlerManager.getServerHandler().modelVisibilityChange(this.getEasyNPCUUID(), modelPart, checkbox.selected())));
        return sliderRotationButtonX;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.advancedPoseButton.field_22763 = false;
        int sliderLeftDefaultPos = this.contentLeftPos - 3;
        int sliderTopPos = this.contentTopPos + 56;
        int sliderLeftPos = sliderLeftDefaultPos;
        int sliderLeftSpace = 200;
        int sliderTopSpace = 60;
        VariantData<?> variantData = this.getEasyNPC().getEasyNPCVariantData();
        boolean hasCrossedArms = variantData.hasVariantCrossedArms();
        if (this.modelData.hasHeadModelPart()) {
            this.headRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos, sliderTopPos, ModelPart.HEAD, "head");
        }
        if (this.modelData.hasBodyModelPart()) {
            this.bodyRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.BODY, "body");
        }
        sliderTopPos += sliderTopSpace;
        if (hasCrossedArms || !this.modelData.hasLeftArmModelPart() && !this.modelData.hasRightArmModelPart() && this.modelData.hasArmsModelPart()) {
            sliderLeftPos = sliderLeftDefaultPos;
            this.armsRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos, sliderTopPos, ModelPart.ARMS, "arms");
        }
        if (!hasCrossedArms && this.modelData.hasRightArmModelPart()) {
            sliderLeftPos = sliderLeftDefaultPos;
            this.rightArmRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos, sliderTopPos, ModelPart.RIGHT_ARM, "right_arm");
        }
        if (!hasCrossedArms && this.modelData.hasLeftArmModelPart()) {
            this.leftArmRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.LEFT_ARM, "left_arm");
        }
        sliderTopPos += sliderTopSpace;
        sliderLeftPos = sliderLeftDefaultPos;
        if (this.modelData.hasRightLegModelPart()) {
            this.rightLegRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos, sliderTopPos, ModelPart.RIGHT_LEG, "right_leg");
        }
        if (this.modelData.hasLeftLegModelPart()) {
            this.leftLegRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.LEFT_LEG, "left_leg");
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        ScreenHelper.renderCustomPoseEntityAvatar(guiGraphics, this.contentLeftPos + 157, this.contentTopPos + 165, 50, (float)(this.contentLeftPos + 150) - this.xMouse, (float)(this.contentTopPos + 80) - this.yMouse, this.getEasyNPC());
        if (this.modelData.hasHeadModelPart() && this.headRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "pose.head", this.headRotationSliderButton.method_46426() + 20, this.headRotationSliderButton.method_46427() - 12);
        }
        if (this.modelData.hasBodyModelPart() && this.bodyRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "pose.body", this.bodyRotationSliderButton.method_46426() + 20, this.bodyRotationSliderButton.method_46427() - 12);
        }
        if (this.modelData.hasLeftArmModelPart() && this.leftArmRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "pose.left_arm", this.leftArmRotationSliderButton.method_46426() + 20, this.leftArmRotationSliderButton.method_46427() - 12);
        } else if (this.modelData.hasArmsModelPart() && this.armsRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "pose.arms", this.armsRotationSliderButton.method_46426() + 20, this.armsRotationSliderButton.method_46427() - 12);
        }
        if (this.modelData.hasRightArmModelPart() && this.rightArmRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "pose.right_arm", this.rightArmRotationSliderButton.method_46426() + 20, this.rightArmRotationSliderButton.method_46427() - 12);
        }
        if (this.modelData.hasLeftLegModelPart() && this.leftLegRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "pose.left_leg", this.leftLegRotationSliderButton.method_46426() + 20, this.leftLegRotationSliderButton.method_46427() - 12);
        }
        if (this.modelData.hasRightLegModelPart() && this.rightLegRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "pose.right_leg", this.rightLegRotationSliderButton.method_46426() + 20, this.rightLegRotationSliderButton.method_46427() - 12);
        }
    }

    @Override
    protected void renderBg(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        int backgroundTopPos = this.contentTopPos + 30;
        guiGraphics.method_25294(this.contentLeftPos + 109, backgroundTopPos, this.contentLeftPos + 206, this.contentTopPos + 178, -16777216);
        guiGraphics.method_25294(this.contentLeftPos + 110, backgroundTopPos + 1, this.contentLeftPos + 205, this.contentTopPos + 177, -5592406);
    }
}

