/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.model;

import de.markusbordihn.easynpc.client.renderer.manager.EntityTypeManager;
import de.markusbordihn.easynpc.client.screen.components.SearchField;
import de.markusbordihn.easynpc.client.screen.components.SkinSelectionButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.model.ModelConfigurationScreen;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_7923;

public class CustomModelConfigurationScreen<T extends ConfigurationMenu>
extends ModelConfigurationScreen<T> {
    private static final float SKIN_NAME_SCALING = 0.7f;
    private static final int MAX_SKINS_PER_PAGE = 5;
    private static final int SKIN_PREVIEW_WIDTH = 60;
    private class_4185 skinNextButton = null;
    private class_4185 skinNextPageButton = null;
    private class_4185 skinPreviousButton = null;
    private class_4185 skinPreviousPageButton = null;
    private int lastNumOfSkins = 0;
    private int numOfEntities = 0;
    private int skinStartIndex = 0;
    private List<class_4185> customModelButtons = new ArrayList<class_4185>();
    private String searchFilter = null;

    public CustomModelConfigurationScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.customModelButton.field_22763 = false;
        this.setDescriptionText("custom_model.text");
        this.defineSkinNavigationButtons(this.contentTopPos + 189, this.contentLeftPos, this.rightPos - 29);
        class_342 modelSearchField = (class_342)this.method_37063((class_364)new SearchField(this.field_22793, this.contentLeftPos + 100, this.contentTopPos + 190, 100, 14));
        modelSearchField.method_1863(this::onSearchFieldChanged);
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        this.renderDescriptionText(guiGraphics, this.contentLeftPos + 5, this.contentTopPos + 20);
        if (!this.customModelButtons.isEmpty()) {
            for (class_4185 skinButton : this.customModelButtons) {
                skinButton.method_25394(guiGraphics, x, y, partialTicks);
            }
        }
        this.renderCustomModels(guiGraphics);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.customModelButtons.isEmpty()) {
            for (class_4185 skinButton : this.customModelButtons) {
                skinButton.method_25402(mouseX, mouseY, button);
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void defineSkinNavigationButtons(int skinButtonTop, int skinButtonLeft, int skinButtonRight) {
        this.skinPreviousPageButton = (class_4185)this.method_37063((class_364)new TextButton(skinButtonLeft, skinButtonTop, 20, "<<", onPress -> {
            this.skinStartIndex = Math.max(this.skinStartIndex - 5, 0);
            this.checkSkinNavigationButtonState();
        }));
        this.skinPreviousButton = (class_4185)this.method_37063((class_364)new TextButton(skinButtonLeft + 20, skinButtonTop, 20, "<", onPress -> {
            if (this.skinStartIndex > 0) {
                --this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextPageButton = (class_4185)this.method_37063((class_364)new TextButton(skinButtonRight, skinButtonTop, 20, ">>", onPress -> {
            this.skinStartIndex = this.skinStartIndex >= 0 && this.skinStartIndex + 5 < this.numOfEntities ? (this.skinStartIndex += 5) : (this.numOfEntities > 5 ? this.numOfEntities - 5 : this.numOfEntities);
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextButton = (class_4185)this.method_37063((class_364)new TextButton(skinButtonRight - 20, skinButtonTop, 20, ">", onPress -> {
            if (this.skinStartIndex >= 0 && this.skinStartIndex < this.numOfEntities - 5) {
                ++this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.checkSkinNavigationButtonState();
    }

    private void checkSkinNavigationButtonState() {
        if (this.skinPreviousButton != null) {
            boolean bl = this.skinPreviousButton.field_22763 = this.skinStartIndex > 0;
        }
        if (this.skinNextButton != null) {
            boolean bl = this.skinNextButton.field_22763 = this.skinStartIndex + 5 < this.numOfEntities;
        }
        if (this.skinPreviousPageButton != null) {
            boolean bl = this.skinPreviousPageButton.field_22763 = this.skinStartIndex - 5 > 0;
        }
        if (this.skinNextPageButton != null) {
            this.skinNextPageButton.field_22763 = this.skinStartIndex + 1 + 5 < this.numOfEntities;
        }
    }

    @Override
    protected void renderBg(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.renderSkinSelectionBackground(guiGraphics);
    }

    @Override
    protected void updateTick() {
        super.updateTick();
        EntityTypeManager.updateUnknownEntityType((class_1937)this.minecraftInstance.field_1687);
    }

    private void renderCustomModels(class_332 guiGraphics) {
        if (this.getEasyNPC() == null) {
            return;
        }
        int positionTop = 144;
        int skinPosition = 0;
        this.customModelButtons = new ArrayList<class_4185>();
        List<class_1299<? extends class_1297>> entityKeys = EntityTypeManager.getUnknownAndSupportedEntityTypes();
        if (this.searchFilter != null && !this.searchFilter.isEmpty()) {
            entityKeys.removeIf(entityType -> !class_7923.field_41177.method_10221(entityType).toString().toLowerCase(Locale.ROOT).contains(this.searchFilter.toLowerCase(Locale.ROOT)));
        }
        this.numOfEntities = entityKeys.size();
        if (this.lastNumOfSkins != this.numOfEntities) {
            this.checkSkinNavigationButtonState();
            this.lastNumOfSkins = this.numOfEntities;
        }
        for (int index = this.skinStartIndex; index < this.numOfEntities && index < this.skinStartIndex + 5; ++index) {
            int left = this.leftPos + 32 + skinPosition * 60;
            int top = this.topPos + 65 + positionTop;
            class_1299<? extends class_1297> entityType2 = entityKeys.get(index);
            this.renderCustomModelEntity(guiGraphics, left, top, entityType2);
            int topNamePos = Math.round(((float)top - 76.0f) / 0.7f);
            int leftNamePos = Math.round(((float)left - 21.0f) / 0.7f);
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            guiGraphics.method_51448().method_22905(0.7f, 0.7f, 0.7f);
            class_2960 entityTypeKey = class_7923.field_41177.method_10221(entityType2);
            Text.drawString(guiGraphics, this.field_22793, TextUtils.normalizeString(entityTypeKey.method_12836(), 14), leftNamePos, topNamePos, 43520);
            Text.drawString(guiGraphics, this.field_22793, TextUtils.normalizeString(entityTypeKey.method_12832(), 14), leftNamePos, topNamePos + 10, 43520);
            guiGraphics.method_51448().method_22909();
            ++skinPosition;
        }
    }

    private void renderCustomModelEntity(class_332 guiGraphics, int x, int y, class_1299<? extends class_1297> entityType) {
        SkinSelectionButton customModelButton = new SkinSelectionButton(x - 24, y - 81, button -> NetworkMessageHandlerManager.getServerHandler().setRenderEntityType(this.getEasyNPCUUID(), entityType));
        RenderData<?> renderData = this.getEasyNPC().getEasyNPCRenderData();
        RenderDataSet renderDataSet = renderData.getRenderDataSet();
        class_1299<? extends class_1297> currentEntityType = renderDataSet.getRenderEntityType();
        customModelButton.field_22763 = currentEntityType == null || !currentEntityType.equals(entityType);
        float scaleFactor = EntityTypeManager.getScaleFactor(entityType);
        ScreenHelper.renderEntityCustomModel(guiGraphics, x + 4, y, Math.round(30.0f / scaleFactor), (float)x - this.xMouse, (float)(y - 40) - this.yMouse, this.getEasyNPC(), entityType);
        this.customModelButtons.add(customModelButton);
    }

    private void renderSkinSelectionBackground(class_332 guiGraphics) {
        guiGraphics.method_25294(this.contentLeftPos, this.contentTopPos + 104, this.contentLeftPos + 302, this.contentTopPos + 190, -16777216);
        guiGraphics.method_25294(this.contentLeftPos + 1, this.contentTopPos + 105, this.contentLeftPos + 301, this.contentTopPos + 189, -5592406);
    }

    private void onSearchFieldChanged(String searchText) {
        if (searchText != null && !searchText.isEmpty()) {
            this.searchFilter = searchText;
            this.skinStartIndex = 0;
            this.checkSkinNavigationButtonState();
        } else {
            this.searchFilter = "";
        }
    }
}

