/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.attribute;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.attribute.AttributeConfigurationScreen;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import de.markusbordihn.easynpc.utils.ValueUtils;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;

public class DisplayAttributeConfigurationScreen<T extends ConfigurationMenu>
extends AttributeConfigurationScreen<T> {
    private static final HashSet<DisplayAttributeType> VISIBILITY_ATTRIBUTES = new HashSet<DisplayAttributeType>(Arrays.asList(DisplayAttributeType.VISIBLE_AT_DAY, DisplayAttributeType.VISIBLE_AT_NIGHT, DisplayAttributeType.VISIBLE_IN_CREATIVE, DisplayAttributeType.VISIBLE_IN_SPECTATOR, DisplayAttributeType.VISIBLE_IN_STANDARD, DisplayAttributeType.VISIBLE_TO_OWNER, DisplayAttributeType.VISIBLE_TO_TEAM));
    private final HashSet<Checkbox> visibilityCheckboxSet = new HashSet();
    private class_342 lightLevelBox;
    private class_4185 lightLevelSaveButton;

    public DisplayAttributeConfigurationScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.displayAttributeButton.field_22763 = false;
        int firstButtonRow = this.leftPos + 10;
        DisplayAttributeData<?> displayAttributeData = this.getEasyNPC().getEasyNPCDisplayAttributeData();
        this.lightLevelBox = (class_342)this.method_37063((class_364)new TextField(this.field_22793, firstButtonRow + 100, this.buttonTopPos + 25, 20, displayAttributeData.getDisplayIntAttribute(DisplayAttributeType.LIGHT_LEVEL), 2));
        this.lightLevelBox.method_1863(value -> {
            if (this.lightLevelSaveButton != null) {
                this.lightLevelSaveButton.field_22763 = ValueUtils.isNumericValue(value, 0, 15) && ValueUtils.getIntValue(value).intValue() != this.getEasyNPC().getEasyNPCDisplayAttributeData().getDisplayIntAttribute(DisplayAttributeType.LIGHT_LEVEL);
            }
        });
        this.lightLevelSaveButton = (class_4185)this.method_37063((class_364)new SaveButton(this.lightLevelBox.method_46426() + this.lightLevelBox.method_25368() + 2, this.lightLevelBox.method_46427() - 1, onPress -> {
            int lightLevel = Integer.parseInt(this.lightLevelBox.method_1882());
            if (lightLevel >= 0 && lightLevel <= 15) {
                NetworkMessageHandlerManager.getServerHandler().changeDisplayAttribute(this.getEasyNPCUUID(), DisplayAttributeType.LIGHT_LEVEL, lightLevel);
            }
        }));
        this.lightLevelSaveButton.field_22763 = false;
        Checkbox isVisibleCheckbox = (Checkbox)this.method_37063((class_364)new Checkbox(firstButtonRow, this.buttonTopPos + 45, DisplayAttributeType.VISIBLE.getAttributeName(), displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE), checkbox -> {
            this.visibilityCheckboxSet.forEach(visibilityCheckbox -> {
                visibilityCheckbox.field_22763 = checkbox.selected();
            });
            NetworkMessageHandlerManager.getServerHandler().changeDisplayAttribute(this.getEasyNPCUUID(), DisplayAttributeType.VISIBLE, checkbox.selected());
        }));
        int checkboxTopPos = this.buttonTopPos + 65;
        for (DisplayAttributeType displayAttributeType : VISIBILITY_ATTRIBUTES) {
            Checkbox visibilityCheckbox = new Checkbox(firstButtonRow, checkboxTopPos, displayAttributeType.getAttributeName(), displayAttributeData.getDisplayBooleanAttribute(displayAttributeType), checkbox -> NetworkMessageHandlerManager.getServerHandler().changeDisplayAttribute(this.getEasyNPCUUID(), displayAttributeType, checkbox.selected()));
            visibilityCheckbox.field_22763 = isVisibleCheckbox.selected();
            this.visibilityCheckboxSet.add((Checkbox)this.method_37063((class_364)visibilityCheckbox));
            checkboxTopPos += 20;
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        if (this.lightLevelBox != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "light_level", this.lightLevelBox.method_46426() - 100, this.lightLevelBox.method_46427() + 4);
        }
        if (this.getEasyNPC() != null) {
            ScreenHelper.renderScaledEntityAvatar(guiGraphics, this.leftPos + 260, this.contentTopPos + 180, 30, (float)(this.leftPos + 50) - this.xMouse, (float)(this.contentTopPos + 70) - this.yMouse, this.getEasyNPC());
        }
    }
}

