/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.raw;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.entity.easynpc.raw.PiglinRaw;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1308;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_4842;
import net.minecraft.class_5601;
import net.minecraft.class_5617;

public class PiglinRawRenderer
extends class_4842 {
    protected static final Map<PiglinRaw.Variant, class_2960> TEXTURE_BY_VARIANT = (Map)class_156.method_654(new EnumMap(PiglinRaw.Variant.class), map -> {
        map.put(PiglinRaw.Variant.PIGLIN, class_2960.method_60656((String)"textures/entity/piglin/piglin.png"));
        map.put(PiglinRaw.Variant.PIGLIN_BRUTE, class_2960.method_60656((String)"textures/entity/piglin/piglin_brute.png"));
        map.put(PiglinRaw.Variant.ZOMBIFIED_PIGLIN, class_2960.method_60656((String)"textures/entity/piglin/zombified_piglin.png"));
    });
    protected static final class_2960 DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)PiglinRaw.Variant.PIGLIN);

    public PiglinRawRenderer(class_5617.class_5618 context, class_5601 variantModelLocation, class_5601 innerArmorModelLocation, class_5601 outerArmorModelLocation, boolean isZombified) {
        super(context, variantModelLocation, innerArmorModelLocation, outerArmorModelLocation, isZombified);
    }

    public class_2960 method_3982(class_1308 skeleton) {
        if (skeleton instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)skeleton;
            return this.getEntityTexture(easyNPC);
        }
        return super.method_3982(skeleton);
    }

    public class_2960 getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    public class_2960 getCustomTexture(SkinData<?> entity) {
        return CustomTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    public class_2960 getRemoteTexture(SkinData<?> entity) {
        return RemoteTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    public class_2960 getTextureByVariant(Enum<?> variant) {
        return TEXTURE_BY_VARIANT != null ? TEXTURE_BY_VARIANT.getOrDefault(variant, DEFAULT_TEXTURE) : Constants.BLANK_ENTITY_TEXTURE;
    }

    public <N extends EasyNPC<?>> class_2960 getEntityTexture(N easyNPC) {
        SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> this.getTextureByVariant(easyNPC.getEasyNPCVariantData().getVariant());
        };
    }
}

