/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.renderer.manager.EntityTypeManager;
import de.markusbordihn.easynpc.client.renderer.manager.RendererManager;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.client.texture.PlayerTextureManager;
import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface EasyNPCRenderer<E extends class_1314, M extends class_583<E>> {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC");

    default public boolean renderEntity(class_1314 entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        if (!(entity instanceof EasyNPC)) {
            return false;
        }
        EasyNPC easyNPC = (EasyNPC)entity;
        RenderData renderData = easyNPC.getEasyNPCRenderData();
        if (renderData == null || renderData.getRenderDataSet() == null || renderData.getRenderDataSet().getRenderType() != RenderType.CUSTOM_ENTITY) {
            return false;
        }
        class_1299<? extends class_1297> renderEntityType = renderData.getRenderDataSet().getRenderEntityType();
        class_1314 customEntity = EntityTypeManager.getPathfinderMob(renderEntityType, entity.method_37908());
        if (customEntity == null) {
            return false;
        }
        String entityTypeName = EntityTypeManager.getEntityTypeName(renderEntityType);
        class_922<? extends class_1309, ? extends class_583<? extends class_1309>> livingEntityRenderer = RendererManager.getLivingEntityRenderer(renderEntityType, customEntity);
        if (livingEntityRenderer != null) {
            try {
                RendererManager.copyCustomLivingEntityData(entity, (class_1309)customEntity, entityTypeName);
                livingEntityRenderer.method_4054((class_1309)customEntity, entityYaw, partialTicks, poseStack, buffer, packedLight);
                return true;
            }
            catch (Exception exception) {
                log.error("Failed to render custom living entity {} ({}):", (Object)customEntity, renderEntityType, (Object)exception);
                EntityTypeManager.addUnsupportedEntityType(renderEntityType);
                return false;
            }
        }
        class_897<? extends class_1297> entityRenderer = RendererManager.getEntityRenderer(renderEntityType, customEntity);
        if (entityRenderer != null) {
            try {
                RendererManager.copyCustomLivingEntityData(entity, (class_1309)customEntity, entityTypeName);
                entityRenderer.method_3936((class_1297)customEntity, entityYaw, partialTicks, poseStack, buffer, packedLight);
                return true;
            }
            catch (Exception exception) {
                log.error("Failed to render custom entity {} ({}):", (Object)customEntity, renderEntityType, (Object)exception);
                EntityTypeManager.addUnsupportedEntityType(renderEntityType);
                return false;
            }
        }
        return false;
    }

    public class_2960 getTextureByVariant(Enum<?> var1);

    public class_2960 getDefaultTexture();

    default public class_2960 getTextureOverlayByVariant(Enum<?> variant) {
        return Constants.BLANK_ENTITY_TEXTURE;
    }

    default public class_2960 getCustomTexture(SkinData<?> entity) {
        return CustomTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    default public class_2960 getPlayerTexture(SkinData<?> entity) {
        return PlayerTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    default public class_2960 getRemoteTexture(SkinData<?> entity) {
        return RemoteTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    default public <N extends EasyNPC<E>> class_2960 getEntityTexture(N easyNPC) {
        SkinData<E> skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> this.getTextureByVariant(easyNPC.getEasyNPCVariantData().getVariant());
        };
    }

    default public <N extends EasyNPC<E>> class_2960 getEntityPlayerTexture(N easyNPC) {
        SkinData<E> skinData = easyNPC.getEasyNPCSkinData();
        return switch (easyNPC.getEasyNPCSkinData().getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.PLAYER_SKIN -> this.getPlayerTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> this.getTextureByVariant(easyNPC.getEasyNPCVariantData().getVariant());
        };
    }
}

