/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.animation.HumanoidLegAnimation;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_620;
import net.minecraft.class_630;

public class StandardVillagerModel<T extends class_1297>
extends class_620<T>
implements EasyNPCModel<T> {
    protected final Map<ModelPartType, CustomPosition> modelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    protected final Map<ModelPartType, CustomRotation> modelPartRotationMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
    protected final Map<ModelPartType, Boolean> modelPartVisibilityMap = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
    protected final Map<ModelPartType, class_630> modelPartMap = new EnumMap<ModelPartType, class_630>(ModelPartType.class);
    private final class_630 arms;
    private final class_630 body;
    private final class_630 head;
    private final class_630 leftLeg;
    private final class_630 rightLeg;

    public StandardVillagerModel(class_630 modelPart) {
        super(modelPart);
        this.arms = this.defineModelPart(ModelPartType.ARMS, modelPart, "arms");
        this.body = this.defineModelPart(ModelPartType.BODY, modelPart, "body");
        this.head = this.defineModelPart(ModelPartType.HEAD, modelPart, "head");
        this.leftLeg = this.defineModelPart(ModelPartType.LEFT_LEG, modelPart, "left_leg");
        this.rightLeg = this.defineModelPart(ModelPartType.RIGHT_LEG, modelPart, "right_leg");
    }

    public void method_2819(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!this.setupAnimation((class_1297)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch)) {
            super.method_2819(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.ARMS, this.arms);
        this.resetModelPart(ModelPartType.HEAD, this.head);
        this.resetModelPart(ModelPartType.BODY, this.body);
        this.resetModelPart(ModelPartType.RIGHT_LEG, this.rightLeg);
        this.resetModelPart(ModelPartType.LEFT_LEG, this.leftLeg);
    }

    @Override
    public void setupCustomModelPose(T entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.head, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.body, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.arms, modelData.getModelArmsPosition(), modelData.getModelArmsRotation(), modelData.isModelArmsVisible());
        ModelHelper.setPositionRotationVisibility(this.leftLeg, modelData.getModelLeftLegPosition(), modelData.getModelLeftLegRotation(), modelData.isModelLeftLegVisible());
        ModelHelper.setPositionRotationVisibility(this.rightLeg, modelData.getModelRightLegPosition(), modelData.getModelRightLegRotation(), modelData.isModelRightLegVisible());
    }

    @Override
    public boolean animateModelHead(T entity, AttackData<?> attackData, ModelData<?> modelData, class_630 headPart, float ageInTicks, float netHeadYaw, float headPitch) {
        headPart.field_3654 = headPitch * ((float)Math.PI / 180);
        headPart.field_3675 = netHeadYaw * ((float)Math.PI / 180);
        return true;
    }

    @Override
    public boolean animateModelLegs(T entity, AttackData<?> attackData, ModelData<?> modelData, class_630 rightLegPart, class_630 leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return HumanoidLegAnimation.animateHumanoidModelLegs(rightLegPart, leftLegPart, ageInTicks, limbSwing, limbSwingAmount);
    }

    @Override
    public boolean setupCrouchingModelPose(T entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.arms.field_3654 += 0.4f;
        this.arms.field_3656 = 5.2f;
        this.body.field_3654 = 0.5f;
        this.body.field_3656 = 3.2f;
        this.head.field_3656 = 4.2f;
        this.leftLeg.field_3656 = 12.2f;
        this.leftLeg.field_3655 = 4.0f;
        this.rightLeg.field_3656 = 12.2f;
        this.rightLeg.field_3655 = 4.0f;
        return true;
    }

    @Override
    public Map<ModelPartType, CustomPosition> getModelPartPositionMap() {
        return this.modelPartPositionMap;
    }

    @Override
    public Map<ModelPartType, CustomRotation> getModelPartRotationMap() {
        return this.modelPartRotationMap;
    }

    @Override
    public Map<ModelPartType, Boolean> getModelPartVisibilityMap() {
        return this.modelPartVisibilityMap;
    }

    @Override
    public Map<ModelPartType, class_630> getModelPartMap() {
        return this.modelPartMap;
    }
}

