/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.animation.HumanoidLegAnimation;
import de.markusbordihn.easynpc.client.model.base.BaseHierarchicalArmHeadModel;
import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_630;

public class StandardIllagerModel<T extends class_1308>
extends BaseHierarchicalArmHeadModel<T> {
    private final class_630 arms;

    public StandardIllagerModel(class_630 modelPart) {
        super(modelPart);
        class_630 hat = this.head.method_32086("hat");
        hat.field_3665 = false;
        this.arms = this.defineModelPart(ModelPartType.ARMS, modelPart, "arms");
    }

    @Override
    public void resetModelParts() {
        super.resetModelParts();
        this.resetModelPart(ModelPartType.ARMS, this.arms);
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean isCrossedArms;
        if (!(entity instanceof EasyNPC)) {
            return;
        }
        EasyNPC easyNPC = (EasyNPC)entity;
        this.setupAnimation((class_1297)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ModelData modelData = easyNPC.getEasyNPCModelData();
        VariantData variantData = easyNPC.getEasyNPCVariantData();
        this.arms.field_3665 = isCrossedArms = (modelData.getModelArmPose() == ModelArmPose.CROSSED || variantData.hasVariantCrossedArms()) && !AttackHandler.isHoldingWeapon(entity);
        this.leftArm.field_3665 = !isCrossedArms;
        this.rightArm.field_3665 = !isCrossedArms;
    }

    @Override
    public boolean animateModelLegs(T entity, AttackData<?> attackData, ModelData<?> modelData, class_630 rightLegPart, class_630 leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return HumanoidLegAnimation.animateHumanoidModelLegs(rightLegPart, leftLegPart, ageInTicks, limbSwing, limbSwingAmount);
    }

    @Override
    public boolean setupCrouchingModelPose(T entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.field_3654 = 0.5f;
        this.body.field_3656 = 3.2f;
        this.head.field_3656 = 4.2f;
        if (this.arms.field_3665) {
            this.arms.field_3654 += 0.4f;
            this.arms.field_3656 = 5.2f;
        }
        if (this.leftArm.field_3665) {
            this.leftArm.field_3654 += 0.4f;
            this.leftArm.field_3656 = 5.2f;
        }
        this.leftLeg.field_3656 = 12.2f;
        this.leftLeg.field_3655 = 4.0f;
        if (this.rightArm.field_3665) {
            this.rightArm.field_3654 += 0.4f;
            this.rightArm.field_3656 = 5.2f;
        }
        this.rightLeg.field_3656 = 12.2f;
        this.rightLeg.field_3655 = 4.0f;
        return true;
    }
}

