/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.base;

import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.animation.HumanoidArmAnimation;
import de.markusbordihn.easynpc.client.model.animation.HumanoidHeadAnimation;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_3881;
import net.minecraft.class_4587;
import net.minecraft.class_5597;
import net.minecraft.class_630;
import net.minecraft.class_7833;

public class BaseHierarchicalArmModel<E extends class_1308>
extends class_5597<E>
implements class_3881,
EasyNPCModel<E> {
    public final class_630 head;
    protected final Map<ModelPartType, CustomPosition> modelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    protected final Map<ModelPartType, CustomRotation> modelPartRotationMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
    protected final Map<ModelPartType, Boolean> modelPartVisibilityMap = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
    protected final Map<ModelPartType, class_630> modelPartMap = new EnumMap<ModelPartType, class_630>(ModelPartType.class);
    protected final class_630 root;
    protected final class_630 body;
    protected final class_630 rightArm;
    protected final class_630 leftArm;

    public BaseHierarchicalArmModel(class_630 modelPart) {
        this.root = ModelHelper.hasModelPart(modelPart, "root") ? this.defineModelPart(ModelPartType.ROOT, modelPart, "root") : this.defineModelPart(ModelPartType.ROOT, modelPart);
        this.head = ModelHelper.hasModelPart(modelPart, "head") ? this.defineModelPart(ModelPartType.HEAD, modelPart, "head") : this.defineModelPart(ModelPartType.HEAD, this.root, "head");
        this.body = ModelHelper.hasModelPart(modelPart, "body") ? this.defineModelPart(ModelPartType.BODY, modelPart, "body") : this.defineModelPart(ModelPartType.BODY, this.root, "body");
        this.rightArm = ModelHelper.hasModelPart(modelPart, "right_arm") ? this.defineModelPart(ModelPartType.RIGHT_ARM, modelPart, "right_arm") : this.defineModelPart(ModelPartType.RIGHT_ARM, this.body, "right_arm");
        this.leftArm = ModelHelper.hasModelPart(modelPart, "left_arm") ? this.defineModelPart(ModelPartType.LEFT_ARM, modelPart, "left_arm") : this.defineModelPart(ModelPartType.LEFT_ARM, this.body, "left_arm");
    }

    public class_630 method_32008() {
        return this.root;
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.HEAD, this.head);
        this.resetModelPart(ModelPartType.BODY, this.body);
        this.resetModelPart(ModelPartType.RIGHT_ARM, this.rightArm);
        this.resetModelPart(ModelPartType.LEFT_ARM, this.leftArm);
    }

    public void setupAnim(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupAnimation((class_1297)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    @Override
    public void setupCustomModelPose(E entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.head, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.body, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.leftArm, modelData.getModelLeftArmPosition(), modelData.getModelLeftArmRotation(), modelData.isModelLeftArmVisible());
        ModelHelper.setPositionRotationVisibility(this.rightArm, modelData.getModelRightArmPosition(), modelData.getModelRightArmRotation(), modelData.isModelRightArmVisible());
    }

    @Override
    public boolean animateModelHead(E entity, AttackData<?> attackData, ModelData<?> modelData, class_630 headPart, float ageInTicks, float netHeadYaw, float headPitch) {
        return HumanoidHeadAnimation.animateHumanoidModelHead(headPart, netHeadYaw, headPitch);
    }

    @Override
    public boolean animateModelArms(E entity, AttackData<?> attackData, ModelData<?> modelData, class_630 rightArmPart, class_630 leftArmPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return HumanoidArmAnimation.animateHumanoidModelArms(rightArmPart, leftArmPart, ageInTicks, limbSwing, limbSwingAmount);
    }

    @Override
    public boolean setupCrouchingModelPose(E entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.field_3654 = 0.5f;
        this.body.field_3656 = 3.2f;
        this.head.field_3656 = 4.2f;
        this.leftArm.field_3654 += 0.4f;
        this.leftArm.field_3656 = 5.2f;
        this.rightArm.field_3654 += 0.4f;
        this.rightArm.field_3656 = 5.2f;
        return true;
    }

    @Override
    public Map<ModelPartType, CustomPosition> getModelPartPositionMap() {
        return this.modelPartPositionMap;
    }

    @Override
    public Map<ModelPartType, CustomRotation> getModelPartRotationMap() {
        return this.modelPartRotationMap;
    }

    @Override
    public Map<ModelPartType, Boolean> getModelPartVisibilityMap() {
        return this.modelPartVisibilityMap;
    }

    @Override
    public Map<ModelPartType, class_630> getModelPartMap() {
        return this.modelPartMap;
    }

    protected class_630 getArm(class_1306 humanoidArm) {
        return humanoidArm == class_1306.field_6182 ? this.leftArm : this.rightArm;
    }

    public void method_2803(class_1306 humanoidArm, class_4587 poseStack) {
        this.root.method_22703(poseStack);
        this.body.method_22703(poseStack);
        poseStack.method_22904(0.0, -0.09375, 0.09375);
        poseStack.method_22907(class_7833.field_40714.rotation(this.rightArm.field_3654 + 0.43633232f));
        poseStack.method_22905(0.7f, 0.7f, 0.7f);
        poseStack.method_22904(0.0625, 0.0, 0.0);
    }
}

