/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model;

import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.animation.HumanoidLegAnimation;
import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_4050;
import net.minecraft.class_630;

public interface EasyNPCModel<E extends class_1297> {
    public static final CustomPosition EMPTY_POSITION = new CustomPosition(0.0f, 0.0f, 0.0f);
    public static final CustomRotation EMPTY_ROTATION = new CustomRotation(0.0f, 0.0f, 0.0f);

    private static boolean equalPositionAndRotation(class_630 modelPart, CustomPosition position, CustomRotation rotation) {
        return EasyNPCModel.equalPosition(modelPart, position) && EasyNPCModel.equalRotation(modelPart, rotation);
    }

    private static boolean equalPosition(class_630 modelPart, CustomPosition position) {
        return modelPart != null && (double)Math.abs(modelPart.field_3657 - position.x()) < 0.01 && (double)Math.abs(modelPart.field_3656 - position.y()) < 0.01 && (double)Math.abs(modelPart.field_3655 - position.z()) < 0.01;
    }

    private static boolean equalRotation(class_630 modelPart, CustomRotation rotation) {
        return modelPart != null && (double)Math.abs(modelPart.field_3654 - rotation.x()) < 0.01 && (double)Math.abs(modelPart.field_3675 - rotation.y()) < 0.01 && (double)Math.abs(modelPart.field_3674 - rotation.z()) < 0.01;
    }

    default public void resetModelPart(ModelPartType modelPartType, class_630 modelPart) {
        if (this.getDefaultModelPartVisibility(modelPartType)) {
            CustomPosition defaultPosition = this.getDefaultModelPartPosition(modelPartType);
            modelPart.method_2851(defaultPosition.x(), defaultPosition.y(), defaultPosition.z());
            CustomRotation defaultRotation = this.getDefaultModelPartRotation(modelPartType);
            modelPart.method_33425(defaultRotation.x(), defaultRotation.y(), defaultRotation.z());
            modelPart.field_3665 = true;
        } else {
            modelPart.field_3665 = false;
        }
    }

    default public boolean isHumanoidModel() {
        return true;
    }

    default public boolean hasDefaultModelPart(ModelPartType modelPartType, class_630 modelPart) {
        CustomPosition defaultPosition = this.getDefaultModelPartPosition(modelPartType);
        CustomRotation defaultRotation = this.getDefaultModelPartRotation(modelPartType);
        return EasyNPCModel.equalPositionAndRotation(modelPart, defaultPosition, defaultRotation);
    }

    default public class_630 defineModelPart(ModelPartType modelPartType, class_630 parentModel, String name) {
        class_630 modelPart = parentModel.method_32086(name);
        return this.defineModelPart(modelPartType, modelPart);
    }

    default public class_630 defineModelPart(ModelPartType modelPartType, class_630 modelPart) {
        this.setDefaultModelPartPosition(modelPartType, new CustomPosition(modelPart.field_3657, modelPart.field_3656, modelPart.field_3655));
        this.setDefaultModelPartRotation(modelPartType, new CustomRotation(modelPart.field_3654, modelPart.field_3675, modelPart.field_3674));
        this.setDefaultModelPartVisibility(modelPartType, modelPart.field_3665);
        this.setDefaultModelPart(modelPartType, modelPart);
        return modelPart;
    }

    public void resetModelParts();

    public Map<ModelPartType, CustomPosition> getModelPartPositionMap();

    public Map<ModelPartType, CustomRotation> getModelPartRotationMap();

    public Map<ModelPartType, Boolean> getModelPartVisibilityMap();

    public Map<ModelPartType, class_630> getModelPartMap();

    default public void setDefaultModelPartPosition(ModelPartType modelPartType, CustomPosition customPosition) {
        this.getModelPartPositionMap().put(modelPartType, customPosition);
    }

    default public void setDefaultModelPartRotation(ModelPartType modelPartType, CustomRotation rotation) {
        this.getModelPartRotationMap().put(modelPartType, rotation);
    }

    default public void setDefaultModelPartVisibility(ModelPartType modelPartType, boolean isVisible) {
        this.getModelPartVisibilityMap().put(modelPartType, isVisible);
    }

    default public void setDefaultModelPart(ModelPartType modelPartType, class_630 modelPart) {
        this.getModelPartMap().put(modelPartType, modelPart);
    }

    default public CustomPosition getDefaultModelPartPosition(ModelPartType modelPartType) {
        return this.getModelPartPositionMap().getOrDefault((Object)modelPartType, EMPTY_POSITION);
    }

    default public CustomRotation getDefaultModelPartRotation(ModelPartType modelPartType) {
        return this.getModelPartRotationMap().getOrDefault((Object)modelPartType, EMPTY_ROTATION);
    }

    default public boolean getDefaultModelPartVisibility(ModelPartType modelPartType) {
        return this.getModelPartVisibilityMap().getOrDefault((Object)modelPartType, true);
    }

    default public class_630 getDefaultModelPart(ModelPartType modelPartType) {
        return this.getModelPartMap().getOrDefault((Object)modelPartType, null);
    }

    default public void setupCustomModelPose(E entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    default public void animateCustomModelPose(E entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    default public void adjustDefaultModelParts(E entity, EasyNPC<?> easyNPC) {
    }

    default public boolean setupDefaultModelPose(E entity, class_4050 pose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return false;
    }

    default public boolean animateDefaultModelPose(E entity, class_4050 pose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return false;
    }

    default public boolean setupStandingModelPose(E entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return false;
    }

    default public boolean setupCrouchingModelPose(E entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return false;
    }

    default public boolean setupFallbackModelPose(E entity, class_4050 pose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return false;
    }

    default public boolean additionalModelAnimation(E entity, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return false;
    }

    default public boolean animateModelHead(E entity, AttackData<?> attackData, ModelData<?> modelData, class_630 headPart, float ageInTicks, float netHeadYaw, float headPitch) {
        return false;
    }

    default public boolean animateModelBody(E entity, AttackData<?> attackData, ModelData<?> modelData, class_630 bodyPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return false;
    }

    default public boolean animateModelArmPose(E entity, ModelArmPose modelArmPose, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return false;
    }

    default public boolean animateModelArms(E entity, AttackData<?> attackData, ModelData<?> modelData, class_630 rightArmPart, class_630 leftArmPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        boolean result = false;
        if (rightArmPart != null) {
            result = this.animateModelRightArm(entity, attackData, modelData, rightArmPart, ageInTicks, limbSwing, limbSwingAmount);
        }
        if (leftArmPart != null) {
            result = this.animateModelLeftArm(entity, attackData, modelData, leftArmPart, ageInTicks, limbSwing, limbSwingAmount);
        }
        return result;
    }

    default public boolean animateModelRightArm(E entity, AttackData<?> attackData, ModelData<?> modelData, class_630 rightArmPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return false;
    }

    default public boolean animateModelLeftArm(E entity, AttackData<?> attackData, ModelData<?> modelData, class_630 leftArmPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return false;
    }

    default public boolean animateModelLegs(E entity, AttackData<?> attackData, ModelData<?> modelData, class_630 rightLegPart, class_630 leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        if (rightLegPart == null || leftLegPart == null) {
            return false;
        }
        return HumanoidLegAnimation.animateHumanoidModelLegs(rightLegPart, leftLegPart, ageInTicks, limbSwing, limbSwingAmount);
    }

    default public boolean animateModelFrontLegs(E entity, AttackData<?> attackData, ModelData<?> modelData, class_630 rightLegPart, class_630 leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return false;
    }

    default public boolean animateModelHindLegs(E entity, AttackData<?> attackData, ModelData<?> modelData, class_630 rightLegPart, class_630 leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return false;
    }

    default public void animateAttackModelPose(E entity, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    default public boolean handleDefaultModelPose(E entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        class_4050 pose = modelData.getDefaultPose();
        boolean hasAdjustedDefaultModelPose = this.setupDefaultModelPose(entity, pose, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        hasAdjustedDefaultModelPose = switch (pose) {
            case class_4050.field_18076 -> {
                if (hasAdjustedDefaultModelPose || this.setupStandingModelPose(entity, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch)) {
                    yield true;
                }
                yield false;
            }
            case class_4050.field_18081 -> {
                if (hasAdjustedDefaultModelPose || this.setupCrouchingModelPose(entity, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch)) {
                    yield true;
                }
                yield false;
            }
            default -> hasAdjustedDefaultModelPose || this.setupFallbackModelPose(entity, pose, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        };
        hasAdjustedDefaultModelPose = hasAdjustedDefaultModelPose || this.animateDefaultModelPose(entity, pose, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        return hasAdjustedDefaultModelPose;
    }

    default public boolean handleSmartAnimations(E entity, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        class_630 body;
        boolean hasDefaultBody;
        boolean hasDefaultHead;
        boolean isHumanoidModel = this.isHumanoidModel();
        boolean hasAnimatedModelBody = false;
        boolean hasAnimatedModelHead = false;
        boolean hasAnimatedModelArms = false;
        boolean hasAnimatedModelArmPose = false;
        boolean hasAnimatedModelLegs = false;
        boolean hasAnimatedModelFrontLegs = false;
        boolean hasAnimatedModelHindLegs = false;
        this.animateAttackModelPose(entity, attackData, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        class_630 head = this.getDefaultModelPart(ModelPartType.HEAD);
        boolean bl = hasDefaultHead = head != null && this.hasDefaultModelPart(ModelPartType.HEAD, head);
        if (hasDefaultHead) {
            hasAnimatedModelHead = this.animateModelHead(entity, attackData, modelData, head, ageInTicks, netHeadYaw, headPitch);
        }
        boolean bl2 = hasDefaultBody = (body = this.getDefaultModelPart(ModelPartType.BODY)) != null && this.hasDefaultModelPart(ModelPartType.BODY, body);
        if (hasDefaultBody) {
            hasAnimatedModelBody = this.animateModelBody(entity, attackData, modelData, body, ageInTicks, limbSwing, limbSwingAmount);
        }
        if (isHumanoidModel) {
            ModelArmPose modelArmPose = modelData.getModelArmPose();
            if (modelArmPose == ModelArmPose.DEFAULT || modelArmPose == ModelArmPose.NEUTRAL) {
                class_630 rightArm = this.getDefaultModelPart(ModelPartType.RIGHT_ARM);
                boolean hasDefaultRightArm = rightArm != null && this.hasDefaultModelPart(ModelPartType.RIGHT_ARM, rightArm);
                class_630 leftArm = this.getDefaultModelPart(ModelPartType.LEFT_ARM);
                boolean hasDefaultLeftArm = leftArm != null && this.hasDefaultModelPart(ModelPartType.LEFT_ARM, leftArm);
                hasAnimatedModelArms = this.animateModelArms(entity, attackData, modelData, (class_630)(hasDefaultRightArm ? rightArm : null), (class_630)(hasDefaultLeftArm ? leftArm : null), ageInTicks, limbSwing, limbSwingAmount);
            } else {
                hasAnimatedModelArmPose = this.animateModelArmPose(entity, modelArmPose, attackData, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            }
            class_630 rightLeg = this.getDefaultModelPart(ModelPartType.RIGHT_LEG);
            class_630 leftLeg = this.getDefaultModelPart(ModelPartType.LEFT_LEG);
            hasAnimatedModelLegs = this.animateModelLegs(entity, attackData, modelData, rightLeg != null && this.hasDefaultModelPart(ModelPartType.RIGHT_LEG, rightLeg) ? rightLeg : null, leftLeg != null && this.hasDefaultModelPart(ModelPartType.LEFT_LEG, leftLeg) ? leftLeg : null, ageInTicks, limbSwing, limbSwingAmount);
        } else {
            class_630 rightFrontLeg = this.getDefaultModelPart(ModelPartType.RIGHT_FRONT_LEG);
            class_630 leftFrontLeg = this.getDefaultModelPart(ModelPartType.LEFT_FRONT_LEG);
            hasAnimatedModelFrontLegs = this.animateModelFrontLegs(entity, attackData, modelData, rightFrontLeg != null && this.hasDefaultModelPart(ModelPartType.RIGHT_FRONT_LEG, rightFrontLeg) ? rightFrontLeg : null, leftFrontLeg != null && this.hasDefaultModelPart(ModelPartType.LEFT_FRONT_LEG, leftFrontLeg) ? leftFrontLeg : null, ageInTicks, limbSwing, limbSwingAmount);
            class_630 rightHindLeg = this.getDefaultModelPart(ModelPartType.RIGHT_HIND_LEG);
            class_630 leftHindLeg = this.getDefaultModelPart(ModelPartType.LEFT_HIND_LEG);
            hasAnimatedModelHindLegs = this.animateModelHindLegs(entity, attackData, modelData, rightHindLeg != null && this.hasDefaultModelPart(ModelPartType.RIGHT_HIND_LEG, rightHindLeg) ? rightHindLeg : null, leftHindLeg != null && this.hasDefaultModelPart(ModelPartType.LEFT_HIND_LEG, leftHindLeg) ? leftHindLeg : null, ageInTicks, limbSwing, limbSwingAmount);
        }
        return hasAnimatedModelHead || hasAnimatedModelBody || hasAnimatedModelArms || hasAnimatedModelArmPose || hasAnimatedModelLegs || hasAnimatedModelFrontLegs || hasAnimatedModelHindLegs || !hasDefaultHead;
    }

    default public boolean setupAnimation(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(entity instanceof EasyNPC)) {
            return false;
        }
        EasyNPC easyNPC = (EasyNPC)entity;
        this.resetModelParts();
        ModelData modelData = easyNPC.getEasyNPCModelData();
        ModelPose modelPose = modelData.getModelPose();
        AttackData attackData = easyNPC.getEasyNPCAttackData();
        boolean isCustomModelPose = modelPose == ModelPose.CUSTOM;
        boolean isDefaultModelPose = modelPose == ModelPose.DEFAULT;
        boolean hasAdjustedDefaultModelPose = false;
        boolean hasSmartAnimations = modelData.useSmartAnimations();
        if (isCustomModelPose) {
            this.setupCustomModelPose(entity, modelPose, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.animateCustomModelPose(entity, modelPose, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        } else if (isDefaultModelPose) {
            this.resetModelParts();
            hasAdjustedDefaultModelPose = this.handleDefaultModelPose(entity, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
        if (modelData.useSmartAnimations() || isCustomModelPose || hasAdjustedDefaultModelPose) {
            hasSmartAnimations = this.handleSmartAnimations(entity, attackData, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
        boolean hasAdditionalModelAnimation = this.additionalModelAnimation(entity, attackData, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.adjustDefaultModelParts(entity, easyNPC);
        return isCustomModelPose || isDefaultModelPose && hasAdjustedDefaultModelPose || hasSmartAnimations || hasAdditionalModelAnimation;
    }
}

