/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.block.entity;

import de.markusbordihn.easynpc.block.BaseEasyNPCSpawnerBlock;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.item.configuration.EasyNPCPresetItem;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseEasyNPCSpawnerBlockEntity
extends class_2624 {
    public static final int BLOCK_POS_X_DATA = 0;
    public static final int BLOCK_POS_Y_DATA = 1;
    public static final int BLOCK_POS_Z_DATA = 2;
    public static final int DATA_SIZE = 9;
    public static final int DELAY_DATA = 5;
    public static final String DELAY_TAG = "Delay";
    public static final int DESPAWN_RANGE_DATA = 8;
    public static final String DESPAWN_RANGE_TAG = "DespawnRange";
    public static final int MAX_NEARBY_ENTITIES_DATA = 6;
    public static final String MAX_NEARBY_ENTITIES_TAG = "MaxNearbyEntities";
    public static final String NAME = "easy_npc_spawner_entity";
    public static final int REQUIRED_PLAYER_RANGE_DATA = 4;
    public static final String REQUIRED_PLAYER_RANGE_TAG = "RequiredPlayerRange";
    public static final String SPAWNER_OWNER_TAG = "Owner";
    public static final int SPAWNER_TICK = 20;
    public static final int SPAWN_COUNT_DATA = 7;
    public static final String SPAWN_COUNT_TAG = "SpawnCount";
    public static final int SPAWN_RANGE_DATA = 3;
    public static final String SPAWN_RANGE_TAG = "SpawnRange";
    public static final String UUID_TAG = "UUID";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final Random random = new Random();
    protected class_2371<class_1799> items = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
    private int delay = 10;
    private int despawnRange = 32;
    private int maxNearbyEntities = 1;
    private int numbersPerSpawnInterval = 1;
    private UUID owner;
    private int requiredPlayerRange = 16;
    private int spawnRange = 2;
    protected final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> BaseEasyNPCSpawnerBlockEntity.this.field_11867.method_10263();
                case 1 -> BaseEasyNPCSpawnerBlockEntity.this.field_11867.method_10264();
                case 2 -> BaseEasyNPCSpawnerBlockEntity.this.field_11867.method_10260();
                case 5 -> BaseEasyNPCSpawnerBlockEntity.this.delay;
                case 8 -> BaseEasyNPCSpawnerBlockEntity.this.despawnRange;
                case 6 -> BaseEasyNPCSpawnerBlockEntity.this.maxNearbyEntities;
                case 4 -> BaseEasyNPCSpawnerBlockEntity.this.requiredPlayerRange;
                case 7 -> BaseEasyNPCSpawnerBlockEntity.this.numbersPerSpawnInterval;
                case 3 -> BaseEasyNPCSpawnerBlockEntity.this.spawnRange;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 3: {
                    BaseEasyNPCSpawnerBlockEntity.this.spawnRange = value;
                    break;
                }
                case 8: {
                    BaseEasyNPCSpawnerBlockEntity.this.despawnRange = value;
                    break;
                }
                case 4: {
                    BaseEasyNPCSpawnerBlockEntity.this.requiredPlayerRange = value;
                    break;
                }
                case 5: {
                    BaseEasyNPCSpawnerBlockEntity.this.delay = value;
                    break;
                }
                case 6: {
                    BaseEasyNPCSpawnerBlockEntity.this.maxNearbyEntities = value;
                    break;
                }
                case 7: {
                    BaseEasyNPCSpawnerBlockEntity.this.numbersPerSpawnInterval = value;
                    break;
                }
            }
        }

        public int method_17389() {
            return 9;
        }
    };
    private int spawnTicker = 0;
    private int spawnerTicker = this.random.nextInt(20);
    private UUID spawnerUUID;

    public BaseEasyNPCSpawnerBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public static void clientTick(class_1937 level, class_2338 blockPos, class_2680 blockState, BaseEasyNPCSpawnerBlockEntity blockEntity) {
    }

    public static void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState, BaseEasyNPCSpawnerBlockEntity blockEntity) {
        if (blockEntity.spawnerTicker++ >= 20) {
            if (blockEntity.spawnTicker++ >= blockEntity.delay) {
                BaseEasyNPCSpawnerBlockEntity.despawnTick(level, blockPos, blockState, blockEntity);
                BaseEasyNPCSpawnerBlockEntity.spawnTick(level, blockPos, blockState, blockEntity);
                blockEntity.spawnTicker = 0;
            }
            blockEntity.spawnerTicker = 0;
        }
    }

    public static void despawnTick(class_1937 level, class_2338 blockPos, class_2680 blockState, BaseEasyNPCSpawnerBlockEntity blockEntity) {
        if (!blockEntity.checkDespawnConditions()) {
            return;
        }
        log.debug("Despawn tick for {}", (Object)blockEntity);
        Set<EasyNPC<?>> validEasyNPCs = blockEntity.getEasyNPCsInRange(blockEntity.field_11867, blockEntity.despawnRange);
        Set<EasyNPC<?>> nearbyEasyNPCs = blockEntity.getEasyNPCsInRange(blockEntity.field_11867, blockEntity.despawnRange + 256);
        for (EasyNPC<?> easyNPC : nearbyEasyNPCs) {
            if (validEasyNPCs.contains(easyNPC)) continue;
            log.debug("Despawn {} from spawner at {} outside of range {}", easyNPC, (Object)blockPos, (Object)blockEntity.despawnRange);
            easyNPC.getEntity().method_31472();
        }
    }

    public static void spawnTick(class_1937 level, class_2338 blockPos, class_2680 blockState, BaseEasyNPCSpawnerBlockEntity blockEntity) {
        if (!blockEntity.checkSpawnConditions()) {
            return;
        }
        log.debug("Spawn tick for {}", (Object)blockEntity);
        class_2338 spawnerBlockPos = BaseEasyNPCSpawnerBlockEntity.getFreeSpawnerBlockPos(blockPos, level);
        class_1799 presetItemStack = blockEntity.getPresetItemStack().method_7972();
        EasyNPCPresetItem.setSpawnerUUID(presetItemStack, blockEntity.getSpawnerUUID());
        int numbersPerSpawnInterval = blockEntity.getSpawnCount();
        Iterable possibleSpawnPositions = class_2338.method_30512((class_2338)spawnerBlockPos, (int)blockEntity.getSpawnRange(), (class_2350)class_2350.field_11043, (class_2350)class_2350.field_11034);
        for (class_2338.class_2339 spawnBlockPos : possibleSpawnPositions) {
            class_238 aabb = new class_238((class_2338)spawnBlockPos).method_1014(0.1);
            class_2338 targetBlockPos = new class_2338(spawnBlockPos.method_10263(), spawnBlockPos.method_10264(), spawnBlockPos.method_10260());
            if (!level.method_8320(targetBlockPos.method_10084()).method_26215() || level.method_8320(targetBlockPos).method_26204() instanceof BaseEasyNPCSpawnerBlock || !level.method_18467(class_1309.class, aabb).isEmpty() || !EasyNPCPresetItem.spawnAtPosition((class_2338)spawnBlockPos, presetItemStack, level)) continue;
            if (blockEntity.getSpawnCount() > 0) {
                if (--numbersPerSpawnInterval <= 0) break;
                log.info("Spawned {} ({} / {}) at {} with in {}", (Object)presetItemStack, (Object)numbersPerSpawnInterval, (Object)blockEntity.getSpawnCount(), (Object)spawnBlockPos, (Object)level);
                continue;
            }
            log.info("Spawned {} at {} with in {}", (Object)presetItemStack, (Object)spawnBlockPos, (Object)level);
        }
    }

    public static class_2338 getFreeSpawnerBlockPos(class_2338 blockPos, class_1937 level) {
        for (int yExpand = 0; yExpand < 3; ++yExpand) {
            if (!level.method_8320(blockPos.method_10086(yExpand).method_10095()).method_26215() && !level.method_8320(blockPos.method_10086(yExpand).method_10072()).method_26215() && !level.method_8320(blockPos.method_10086(yExpand).method_10078()).method_26215() && !level.method_8320(blockPos.method_10086(yExpand).method_10067()).method_26215()) continue;
            return blockPos.method_10086(yExpand);
        }
        return blockPos;
    }

    public boolean checkDespawnConditions() {
        class_1937 level;
        if (this.getPresetItemStack() == null) {
            return false;
        }
        if (this.despawnRange > 0 && (level = this.method_10997()) != null) {
            Set<EasyNPC<?>> validEasyNPCs = this.getEasyNPCsInRange(this.field_11867, this.despawnRange);
            Set<EasyNPC<?>> nearbyEasyNPCs = this.getEasyNPCsInRange(this.field_11867, this.despawnRange + 256);
            for (EasyNPC<?> easyNPC : nearbyEasyNPCs) {
                if (validEasyNPCs.contains(easyNPC)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkSpawnConditions() {
        class_1937 level;
        if (this.getPresetItemStack() == null) {
            return false;
        }
        if (this.requiredPlayerRange > 0 && (level = this.method_10997()) != null) {
            boolean isPlayerInRange = false;
            for (class_1657 player : level.method_18456()) {
                if (!(player.method_5649((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260()) <= (double)(this.requiredPlayerRange * this.requiredPlayerRange))) continue;
                isPlayerInRange = true;
                break;
            }
            if (!isPlayerInRange) {
                return false;
            }
        }
        if (this.maxNearbyEntities > 0) {
            Set<EasyNPC<?>> nearbyEasyNPCs = this.getEasyNPCsInRange(this.field_11867, this.spawnRange);
            return nearbyEasyNPCs.size() < this.maxNearbyEntities;
        }
        return true;
    }

    public class_1799 getPresetItemStack() {
        if (this.items.isEmpty() || ((class_1799)this.items.getFirst()).method_7960() && !EasyNPCPresetItem.hasPreset((class_1799)this.items.getFirst())) {
            return null;
        }
        return (class_1799)this.items.getFirst();
    }

    public UUID getSpawnerUUID() {
        return this.spawnerUUID;
    }

    public void setSpawnerUUID(UUID spawnerUUID) {
        this.spawnerUUID = spawnerUUID;
        this.method_5431();
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(class_1309 livingEntity) {
        this.owner = livingEntity.method_5667();
        this.method_5431();
    }

    protected class_2561 method_17823() {
        return TextComponent.getTranslatedTextRaw("text.easy_npc.container.easy_npc_spawner_entity");
    }

    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> items) {
        this.items = items;
    }

    protected class_1703 method_5465(int containerId, class_1661 inventory) {
        return null;
    }

    public int getSpawnRange() {
        return this.dataAccess.method_17390(3);
    }

    public void setSpawnRange(int spawnRange) {
        this.dataAccess.method_17391(3, Math.clamp((long)spawnRange, 0, 64));
        this.method_5431();
    }

    public int getDespawnRange() {
        return this.dataAccess.method_17390(8);
    }

    public void setDespawnRange(int despawnRange) {
        this.dataAccess.method_17391(8, Math.clamp((long)despawnRange, 0, 128));
        this.method_5431();
    }

    public int getRequiredPlayerRange() {
        return this.dataAccess.method_17390(4);
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        this.dataAccess.method_17391(4, Math.clamp((long)requiredPlayerRange, 0, 64));
        this.method_5431();
    }

    public int getDelay() {
        return this.dataAccess.method_17390(5);
    }

    public void setDelay(int delay) {
        this.dataAccess.method_17391(5, Math.clamp((long)delay, 0, 3600));
        this.method_5431();
    }

    public int getMaxNearbyEntities() {
        return this.dataAccess.method_17390(6);
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        this.dataAccess.method_17391(6, Math.clamp((long)maxNearbyEntities, 0, 256));
        this.method_5431();
    }

    public int getSpawnCount() {
        return this.dataAccess.method_17390(7);
    }

    public void setSpawnCount(int spawnCount) {
        this.dataAccess.method_17391(7, Math.clamp((long)spawnCount, 0, 32));
        this.method_5431();
    }

    public Set<EasyNPC<?>> getEasyNPCsInRange(class_2338 blockPos, int range) {
        if (this.field_11863 == null) {
            return new HashSet();
        }
        HashSet foundEasyNPCs = new HashSet();
        class_238 aabb = new class_238(blockPos).method_1014((double)range);
        for (class_1309 livingEntity : this.field_11863.method_18467(class_1309.class, aabb)) {
            EasyNPC easyNPC;
            if (!(livingEntity instanceof EasyNPC) || !(easyNPC = (EasyNPC)livingEntity).getEasyNPCSpawnerData().hasSpawnerUUID() || !easyNPC.getEasyNPCSpawnerData().getSpawnerUUID().equals(this.spawnerUUID)) continue;
            foundEasyNPCs.add(easyNPC);
        }
        return foundEasyNPCs;
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.items) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int index) {
        return (class_1799)this.items.get(index);
    }

    public class_1799 method_5434(int index, int count) {
        return class_1262.method_5430(this.items, (int)index, (int)count);
    }

    public class_1799 method_5441(int index) {
        return class_1262.method_5428(this.items, (int)index);
    }

    public void method_5447(int index, class_1799 itemStack) {
        class_1799 itemStackFromIndex = (class_1799)this.items.get(index);
        if (itemStack.method_31574(itemStackFromIndex.method_7909())) {
            return;
        }
        this.items.set(index, (Object)itemStack);
    }

    public boolean method_5443(class_1657 player) {
        class_1937 level = this.field_11863;
        return level != null && level.method_8321(this.field_11867) == this && player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.items.clear();
    }

    public void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        this.spawnerUUID = compoundTag.method_25926(UUID_TAG);
        this.owner = compoundTag.method_25926(SPAWNER_OWNER_TAG);
        this.spawnRange = compoundTag.method_10550(SPAWN_RANGE_TAG);
        this.despawnRange = compoundTag.method_10550(DESPAWN_RANGE_TAG);
        this.requiredPlayerRange = compoundTag.method_10550(REQUIRED_PLAYER_RANGE_TAG);
        this.delay = compoundTag.method_10550(DELAY_TAG);
        this.maxNearbyEntities = compoundTag.method_10550(MAX_NEARBY_ENTITIES_TAG);
        this.numbersPerSpawnInterval = compoundTag.method_10550(SPAWN_COUNT_TAG);
        this.items.clear();
        class_1262.method_5429((class_2487)compoundTag, this.items, (class_7225.class_7874)provider);
    }

    public void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        compoundTag.method_25927(UUID_TAG, Objects.requireNonNullElseGet(this.spawnerUUID, UUID::randomUUID));
        if (this.owner != null) {
            compoundTag.method_25927(SPAWNER_OWNER_TAG, this.owner);
        }
        compoundTag.method_10569(SPAWN_RANGE_TAG, this.spawnRange);
        compoundTag.method_10569(DESPAWN_RANGE_TAG, this.despawnRange);
        compoundTag.method_10569(REQUIRED_PLAYER_RANGE_TAG, this.requiredPlayerRange);
        compoundTag.method_10569(DELAY_TAG, this.delay);
        compoundTag.method_10569(MAX_NEARBY_ENTITIES_TAG, this.maxNearbyEntities);
        compoundTag.method_10569(SPAWN_COUNT_TAG, this.numbersPerSpawnInterval);
        class_1262.method_5426((class_2487)compoundTag, this.items, (class_7225.class_7874)provider);
    }
}

