/*
 * Decompiled with CFR 0.152.
 */
package dev.custom.portals.data;

import dev.custom.portals.data.CustomPortal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;

public class PortalRegistry {
    private List<CustomPortal> portals = new ArrayList<CustomPortal>();
    private Map<class_2338, CustomPortal> portalPositions = new HashMap<class_2338, CustomPortal>();

    public void register(CustomPortal portal) {
        this.tryWithAll(portal);
        for (class_2338 blockPos : portal.getPortalBlocks()) {
            this.portalPositions.put(blockPos, portal);
        }
        this.portals.add(portal);
    }

    public void unregister(CustomPortal portal) {
        this.portals.remove(portal);
        if (portal.hasLinked()) {
            this.tryWithAll(portal.getLinked());
        }
        for (class_2338 blockPos : portal.getPortalBlocks()) {
            this.portalPositions.remove(blockPos);
        }
    }

    public void tryWithAll(CustomPortal portal) {
        portal.setLinked(null);
        for (CustomPortal p : this.portals) {
            portal.tryLink(p);
        }
    }

    public void refreshPortals() {
        for (CustomPortal portal : this.portals) {
            this.tryWithAll(portal);
        }
    }

    public List<CustomPortal> getPortals() {
        return this.portals;
    }

    public CustomPortal getPortalFromPos(class_2338 pos) {
        return this.portalPositions.get(pos);
    }
}

