/*
 * Decompiled with CFR 0.152.
 */
package dev.custom.portals.data;

import dev.custom.portals.data.BasePortalComponent;
import dev.custom.portals.data.CustomPortal;
import dev.custom.portals.data.PortalRegistry;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3620;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class PortalComponent
implements BasePortalComponent {
    private PortalRegistry portalRegistry = new PortalRegistry();

    @Override
    public PortalRegistry getPortalRegistry() {
        return this.portalRegistry;
    }

    @Override
    public CustomPortal getPortalFromPos(class_2338 pos) {
        return this.portalRegistry.getPortalFromPos(pos);
    }

    @Override
    public void setPortalRegistry(PortalRegistry portalRegistry) {
        this.portalRegistry = portalRegistry;
    }

    @Override
    public void registerPortal(CustomPortal portal) {
        this.portalRegistry.register(portal);
    }

    @Override
    public void unregisterPortal(CustomPortal portal) {
        this.portalRegistry.unregister(portal);
    }

    @Override
    public void tryWithAll(CustomPortal portal) {
        this.portalRegistry.tryWithAll(portal);
    }

    @Override
    public void refreshPortals() {
        this.portalRegistry.refreshPortals();
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        class_2499 portalData = tag.method_10554("portals", 10);
        for (int i = 0; i < portalData.size(); ++i) {
            float offsetZ;
            float offsetX;
            class_2487 curTag = portalData.method_10602(i);
            String frameId = curTag.method_10558("frameId");
            String dimensionId = curTag.method_10558("dimensionId");
            class_2338 spawnPos = new class_2338(curTag.method_10550("xSpawn"), curTag.method_10550("ySpawn"), curTag.method_10550("zSpawn"));
            class_3620 color = class_3620.method_38479((int)curTag.method_10550("color"));
            ArrayList<class_2338> portalBlocks = new ArrayList<class_2338>();
            class_2499 portalBlocksData = curTag.method_10554("blocks", 10);
            for (int j = 0; j < portalBlocksData.size(); ++j) {
                class_2487 curBlockTag = portalBlocksData.method_10602(j);
                portalBlocks.add(new class_2338(curBlockTag.method_10550("xPos"), curBlockTag.method_10550("yPos"), curBlockTag.method_10550("zPos")));
            }
            int length = curTag.method_10550("length");
            int width = curTag.method_10550("width");
            if (length != 0 || width != 0) {
                float f = offsetX = length == 0 || length % 2 != 0 ? 0.5f : 0.0f;
                offsetZ = width == 0 ? 0.5f : (width % 2 != 0 ? -0.5f : 0.0f);
            } else {
                offsetX = curTag.method_10583("offsetX");
                offsetZ = curTag.method_10583("offsetZ");
            }
            int hasteRunes = curTag.method_10550("haste");
            int gateRunes = curTag.method_10550("gate");
            int weakEnhancerRunes = curTag.method_10550("weak");
            int strongEnhancerRunes = curTag.method_10550("strong");
            int infinityRunes = curTag.method_10550("infinity");
            UUID creatorId = curTag.method_25926("creatorId");
            CustomPortal portal = new CustomPortal(frameId, dimensionId, color, spawnPos, portalBlocks, offsetX, offsetZ, creatorId, hasteRunes, gateRunes, weakEnhancerRunes, strongEnhancerRunes, infinityRunes);
            this.registerPortal(portal);
        }
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        class_2499 portalData = new class_2499();
        for (CustomPortal curPortal : this.portalRegistry.getPortals()) {
            class_2487 curTag = new class_2487();
            curTag.method_10582("frameId", curPortal.getFrameId());
            curTag.method_10582("dimensionId", curPortal.getDimensionId());
            curTag.method_10569("xSpawn", curPortal.getSpawnPos().method_10263());
            curTag.method_10569("ySpawn", curPortal.getSpawnPos().method_10264());
            curTag.method_10569("zSpawn", curPortal.getSpawnPos().method_10260());
            curTag.method_10548("offsetX", curPortal.offsetX);
            curTag.method_10548("offsetZ", curPortal.offsetZ);
            curTag.method_10569("color", curPortal.getColor().field_16021);
            curTag.method_10569("haste", curPortal.getHasteRunes());
            curTag.method_10569("gate", curPortal.getGateRunes());
            curTag.method_10569("weak", curPortal.getWeakEnhancerRunes());
            curTag.method_10569("strong", curPortal.getStrongEnhancerRunes());
            curTag.method_10569("infinity", curPortal.getInfinityRunes());
            if (curPortal.getCreatorId() != null) {
                curTag.method_25927("creatorId", curPortal.getCreatorId());
            }
            class_2499 portalBlockData = new class_2499();
            for (class_2338 blockPos : curPortal.getPortalBlocks()) {
                class_2487 blockTag = new class_2487();
                blockTag.method_10569("xPos", blockPos.method_10263());
                blockTag.method_10569("yPos", blockPos.method_10264());
                blockTag.method_10569("zPos", blockPos.method_10260());
                portalBlockData.add((Object)blockTag);
            }
            curTag.method_10566("blocks", (class_2520)portalBlockData);
            portalData.add((Object)curTag);
        }
        tag.method_10566("portals", (class_2520)portalData);
    }

    @Override
    public void syncWithAll(MinecraftServer server) {
    }
}

