/*
 * Decompiled with CFR 0.152.
 */
package dev.custom.portals.blocks;

import dev.custom.portals.CustomPortals;
import dev.custom.portals.blocks.PortalBlockEntity;
import dev.custom.portals.config.CPSettings;
import dev.custom.portals.data.BasePortalComponent;
import dev.custom.portals.data.CustomPortal;
import dev.custom.portals.registry.CPItems;
import dev.custom.portals.registry.CPParticles;
import dev.custom.portals.util.EntityMixinAccess;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2424;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_9062;
import net.minecraft.class_9797;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PortalBlock
extends class_2248
implements class_2343,
class_3737,
class_9797 {
    public static final class_2746 LIT = class_2741.field_12548;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12496;
    protected static final class_265 X_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final class_265 Z_SHAPE = class_2248.method_9541((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    protected static final class_265 Y_SHAPE = class_2248.method_9541((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public PortalBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048)).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        switch ((class_2350.class_2351)state.method_11654(AXIS)) {
            case field_11051: {
                return Z_SHAPE;
            }
            case field_11052: {
                return Y_SHAPE;
            }
        }
        return X_SHAPE;
    }

    public class_9062 method_55765(class_1799 itemStack, class_2680 blockState, class_1937 world, class_2338 blockPos, class_1657 playerEntity, class_1268 hand, class_3965 blockHitResult) {
        if (playerEntity.method_5715() && itemStack.method_7960()) {
            CustomPortal portal = ((BasePortalComponent)CustomPortals.PORTALS.get((Object)world)).getPortalFromPos(blockPos);
            if (portal == null) {
                return class_9062.field_47733;
            }
            portal.setSpawnPos(blockPos);
            if (world.field_9236) {
                playerEntity.method_43496(class_2561.method_30163((String)("Set portal's spawn position to " + CustomPortals.blockPosToString(blockPos))));
            }
            return class_9062.field_47728;
        }
        return class_9062.field_47731;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        CustomPortal portal = ((BasePortalComponent)CustomPortals.PORTALS.get((Object)world)).getPortalFromPos(pos);
        if (portal == null) {
            return;
        }
        if (portal.isInterdimensional()) {
            class_1297 entity;
            if (portal.getLinked().getDimensionId().equals("minecraft:the_nether") && world.method_8450().method_8355(class_1928.field_19390) && random.method_43048(2000) < world.method_8407().method_5461()) {
                while (world.method_8320(pos).method_27852((class_2248)this)) {
                    pos = pos.method_10074();
                }
                if (world.method_8320(pos).method_26170((class_1922)world, pos, class_1299.field_6050) && (entity = class_1299.field_6050.method_47821(world, pos.method_10084(), class_3730.field_16474)) != null) {
                    entity.method_30229();
                }
            }
            if (portal.getLinked().getDimensionId().equals("minecraft:the_end") && world.method_8450().method_8355(class_1928.field_19390) && random.method_43048(2000) < world.method_8407().method_5461()) {
                while (world.method_8320(pos).method_27852((class_2248)this)) {
                    pos = pos.method_10074();
                }
                if (world.method_8320(pos).method_26170((class_1922)world, pos, class_1299.field_6091) && (entity = class_1299.field_6091.method_47821(world, pos.method_10084(), class_3730.field_16474)) != null) {
                    entity.method_30229();
                }
            }
        }
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        super.method_9576(world, pos, state, player);
        CustomPortal portal = ((BasePortalComponent)CustomPortals.PORTALS.get((Object)world)).getPortalFromPos(pos);
        if (portal != null) {
            ((BasePortalComponent)CustomPortals.PORTALS.get((Object)world)).unregisterPortal(portal);
            if (!world.field_9236) {
                ((BasePortalComponent)CustomPortals.PORTALS.get((Object)world)).syncWithAll(((class_3218)world).method_8503());
            }
        }
        return state;
    }

    private void dropCatalyst(CustomPortal portal, class_1937 world) {
        class_1799 itemStack = new class_1799((class_1935)(switch (this.method_26403().field_16021) {
            case 29 -> CPItems.BLACK_PORTAL_CATALYST;
            case 25 -> CPItems.BLUE_PORTAL_CATALYST;
            case 26 -> CPItems.BROWN_PORTAL_CATALYST;
            case 23 -> CPItems.CYAN_PORTAL_CATALYST;
            case 21 -> CPItems.GRAY_PORTAL_CATALYST;
            case 27 -> CPItems.GREEN_PORTAL_CATALYST;
            case 17 -> CPItems.LIGHT_BLUE_PORTAL_CATALYST;
            case 22 -> CPItems.LIGHT_GRAY_PORTAL_CATALYST;
            case 19 -> CPItems.LIME_PORTAL_CATALYST;
            case 16 -> CPItems.MAGENTA_PORTAL_CATALYST;
            case 15 -> CPItems.ORANGE_PORTAL_CATALYST;
            case 20 -> CPItems.PINK_PORTAL_CATALYST;
            case 24 -> CPItems.PURPLE_PORTAL_CATALYST;
            case 28 -> CPItems.RED_PORTAL_CATALYST;
            case 8 -> CPItems.WHITE_PORTAL_CATALYST;
            default -> CPItems.YELLOW_PORTAL_CATALYST;
        }));
        class_2248.method_9577((class_1937)world, (class_2338)portal.getSpawnPos(), (class_1799)itemStack);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        boolean bl;
        class_2350.class_2351 axis = direction.method_10166();
        class_2350.class_2351 axis2 = (class_2350.class_2351)state.method_11654(AXIS);
        boolean bl2 = axis2 == class_2350.class_2351.field_11052 ? axis2 == axis && axis.method_10178() : (bl = axis2 != axis && axis.method_10179());
        if (!(bl || newState.method_27852((class_2248)this) || new class_2424(world, pos, axis2).method_10362())) {
            CustomPortal portal = ((BasePortalComponent)CustomPortals.PORTALS.get((Object)((class_1937)world))).getPortalFromPos(pos);
            if (portal != null) {
                if (newState.method_26204().method_9539().equals(portal.getFrameId())) {
                    return super.method_9559(state, direction, newState, world, pos, posFrom);
                }
                ((BasePortalComponent)CustomPortals.PORTALS.get((Object)((class_1937)world))).unregisterPortal(portal);
                if (!((class_1937)world).field_9236) {
                    ((BasePortalComponent)CustomPortals.PORTALS.get((Object)((class_1937)world))).syncWithAll(((class_3218)world).method_8503());
                }
                this.dropCatalyst(portal, (class_1937)world);
            }
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, direction, newState, world, pos, posFrom);
    }

    private boolean checkRedstoneSignal(class_1937 world, CustomPortal portal) {
        for (class_2338 pos : portal.getPortalBlocks()) {
            if (!world.method_49803(pos)) continue;
            return true;
        }
        return false;
    }

    public void method_9612(class_2680 blockState, class_1937 world, class_2338 blockPos, class_2248 block, class_2338 blockPos2, boolean bl) {
        CustomPortal portal = ((BasePortalComponent)CustomPortals.PORTALS.get((Object)world)).getPortalFromPos(blockPos);
        if (portal == null) {
            return;
        }
        boolean bl2 = this.checkRedstoneSignal(world, portal);
        if (bl2 != portal.hasRedstoneSignal()) {
            portal.setHasRedstoneSignal(bl2);
        }
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (!((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            return;
        }
        CustomPortal portal = ((BasePortalComponent)CustomPortals.PORTALS.get((Object)world)).getPortalFromPos(pos);
        if (portal != null && entity.method_5822(false)) {
            entity.method_60697((class_9797)this, pos);
            ((EntityMixinAccess)entity).setInCustomPortal(portal);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (!((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            return;
        }
        if (random.method_43048(100) == 0) {
            world.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_14802, class_3419.field_15245, 0.5f, random.method_43057() * 0.4f + 0.8f, false);
        }
        block18: for (int i = 0; i < 4; ++i) {
            double d = (double)pos.method_10263() + random.method_43058();
            double e = (double)pos.method_10264() + random.method_43058();
            double f = (double)pos.method_10260() + random.method_43058();
            double g = ((double)random.method_43057() - 0.5) * 0.5;
            double h = ((double)random.method_43057() - 0.5) * 0.5;
            double j = ((double)random.method_43057() - 0.5) * 0.5;
            int k = random.method_43048(2) * 2 - 1;
            if (!world.method_8320(pos.method_10067()).method_27852((class_2248)this) && !world.method_8320(pos.method_10078()).method_27852((class_2248)this) && (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496) == class_2350.class_2351.field_11051) {
                d = (double)pos.method_10263() + 0.5 + 0.25 * (double)k;
                g = random.method_43057() * 2.0f * (float)k;
            } else if (!world.method_8320(pos.method_10084()).method_27852((class_2248)this) && !world.method_8320(pos.method_10074()).method_27852((class_2248)this)) {
                e = (double)pos.method_10264() + 0.5 + 0.25 * (double)k;
                h = random.method_43057() * 2.0f * (float)k;
            } else {
                f = (double)pos.method_10260() + 0.5 + 0.25 * (double)k;
                j = random.method_43057() * 2.0f * (float)k;
            }
            switch (this.method_26403().field_16021) {
                case 29: {
                    world.method_8406((class_2394)CPParticles.BLACK_PORTAL_PARTICLE, d, e, f, g, h, j);
                    continue block18;
                }
                case 25: {
                    world.method_8406((class_2394)CPParticles.BLUE_PORTAL_PARTICLE, d, e, f, g, h, j);
                    continue block18;
                }
                case 26: {
                    world.method_8406((class_2394)CPParticles.BROWN_PORTAL_PARTICLE, d, e, f, g, h, j);
                    continue block18;
                }
                case 23: {
                    world.method_8406((class_2394)CPParticles.CYAN_PORTAL_PARTICLE, d, e, f, g, h, j);
                    continue block18;
                }
                case 21: {
                    world.method_8406((class_2394)CPParticles.GRAY_PORTAL_PARTICLE, d, e, f, g, h, j);
                    continue block18;
                }
                case 27: {
                    world.method_8406((class_2394)CPParticles.GREEN_PORTAL_PARTICLE, d, e, f, g, h, j);
                    continue block18;
                }
                case 17: {
                    world.method_8406((class_2394)CPParticles.LIGHT_BLUE_PORTAL_PARTICLE, d, e, f, g, h, j);
                    continue block18;
                }
                case 22: {
                    world.method_8406((class_2394)CPParticles.LIGHT_GRAY_PORTAL_PARTICLE, d, e, f, g, h, j);
                    continue block18;
                }
                case 19: {
                    world.method_8406((class_2394)CPParticles.LIME_PORTAL_PARTICLE, d, e, f, g, h, j);
                    continue block18;
                }
                case 16: {
                    world.method_8406((class_2394)CPParticles.MAGENTA_PORTAL_PARTICLE, d, e, f, g, h, j);
                    continue block18;
                }
                case 15: {
                    world.method_8406((class_2394)CPParticles.ORANGE_PORTAL_PARTICLE, d, e, f, g, h, j);
                    continue block18;
                }
                case 20: {
                    world.method_8406((class_2394)CPParticles.PINK_PORTAL_PARTICLE, d, e, f, g, h, j);
                    continue block18;
                }
                case 24: {
                    world.method_8406((class_2394)class_2398.field_11214, d, e, f, g, h, j);
                    continue block18;
                }
                case 28: {
                    world.method_8406((class_2394)CPParticles.RED_PORTAL_PARTICLE, d, e, f, g, h, j);
                    continue block18;
                }
                case 8: {
                    world.method_8406((class_2394)CPParticles.WHITE_PORTAL_PARTICLE, d, e, f, g, h, j);
                    continue block18;
                }
                case 18: {
                    world.method_8406((class_2394)CPParticles.YELLOW_PORTAL_PARTICLE, d, e, f, g, h, j);
                }
            }
        }
    }

    public boolean method_10310(@Nullable class_1657 playerEntity, class_1922 blockView, class_2338 blockPos, class_2680 blockState, class_3611 fluid) {
        return false;
    }

    protected boolean method_22358(class_2680 blockState, class_3611 fluid) {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public class_1799 getPickStack(class_1922 world, class_2338 pos, class_2680 state) {
        return class_1799.field_8037;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        switch (rotation) {
            case field_11465: {
                switch ((class_2350.class_2351)state.method_11654(AXIS)) {
                    case field_11051: 
                    case field_11048: {
                        return (class_2680)state.method_11657(AXIS, (Comparable)class_2350.class_2351.field_11052);
                    }
                    case field_11052: {
                        return (class_2680)state.method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048);
                    }
                }
                return state;
            }
            case field_11463: {
                switch ((class_2350.class_2351)state.method_11654(AXIS)) {
                    case field_11051: {
                        return (class_2680)state.method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048);
                    }
                    case field_11052: 
                    case field_11048: {
                        return (class_2680)state.method_11657(AXIS, (Comparable)class_2350.class_2351.field_11051);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AXIS, LIT, WATERLOGGED});
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PortalBlockEntity(pos, state);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return PortalBlockEntity::tick;
    }

    @Nullable
    public class_5454 method_60770(class_3218 serverWorld, class_1297 entity, class_2338 blockPos) {
        CustomPortal portal = ((BasePortalComponent)CustomPortals.PORTALS.get((Object)serverWorld)).getPortalFromPos(blockPos);
        if (portal == null) {
            return null;
        }
        CustomPortal destPortal = portal.getLinked();
        if (destPortal == null) {
            return null;
        }
        MinecraftServer minecraftServer = serverWorld.method_8503();
        String dimensionId = portal.getDimensionId();
        String destDimensionId = destPortal.getDimensionId();
        class_3218 serverWorld2 = null;
        if (!destDimensionId.equals(dimensionId)) {
            for (class_5321 registryKey : minecraftServer.method_29435()) {
                if (!registryKey.method_29177().toString().equals(destDimensionId)) continue;
                serverWorld2 = minecraftServer.method_3847(registryKey);
            }
        } else {
            serverWorld2 = serverWorld;
        }
        if (serverWorld2 == null) {
            return null;
        }
        class_2338 dest = destPortal.getSpawnPos();
        float destX = dest.method_10263();
        float destY = dest.method_10264();
        float destZ = dest.method_10260();
        destX += destPortal.offsetX;
        destZ += destPortal.offsetZ;
        if (destPortal.getDimensionId().equals("minecraft:the_end") && serverWorld2.method_27983() == class_1937.field_25179) {
            destY += 1.0f;
        }
        return new class_5454(serverWorld2, new class_243((double)destX, (double)destY, (double)destZ), entity.method_18798(), entity.method_36454(), entity.method_36455(), class_5454.field_52245);
    }

    public int method_60772(class_3218 serverWorld, class_1297 entity) {
        CustomPortal destPortal = ((EntityMixinAccess)entity).getDestPortal();
        if (entity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)entity;
            if (destPortal != null) {
                if (CPSettings.instance().alwaysHaste == CPSettings.HasteEnum.CREATIVE) {
                    return Math.max(1, playerEntity.method_31549().field_7480 ? serverWorld.method_8450().method_8356(class_1928.field_46795) : destPortal.getPlayerTeleportDelay());
                }
                return destPortal.getPlayerTeleportDelay();
            }
        }
        return 0;
    }
}

