/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.crafting;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.blay09.mods.craftingtweaks.crafting.CraftingContext;
import net.blay09.mods.craftingtweaks.crafting.IngredientCacheHint;
import net.blay09.mods.craftingtweaks.crafting.IngredientProvider;
import net.blay09.mods.craftingtweaks.crafting.IngredientToken;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class CraftingOperation {
    private final CraftingContext context;
    private final class_1860<?> recipe;
    private final Multimap<IngredientTokenKey, IngredientToken> tokensByIngredient = ArrayListMultimap.create();
    private final List<IngredientToken> ingredientTokens = new ArrayList<IngredientToken>();
    private final List<class_1856> missingIngredients = new ArrayList<class_1856>();
    private class_2371<class_1799> lockedInputs;
    private int missingIngredientsMask;

    public CraftingOperation(CraftingContext context, class_8786<class_1860<?>> recipe) {
        this.context = context;
        this.recipe = recipe.comp_1933();
    }

    public CraftingOperation withLockedInputs(@Nullable class_2371<class_1799> lockedInputs) {
        this.lockedInputs = lockedInputs;
        return this;
    }

    public CraftingOperation prepare() {
        this.tokensByIngredient.clear();
        this.ingredientTokens.clear();
        this.missingIngredients.clear();
        this.missingIngredientsMask = 0;
        class_2371 ingredients = this.recipe.method_8117();
        for (int i = 0; i < ingredients.size(); ++i) {
            class_1856 ingredient = (class_1856)ingredients.get(i);
            if (ingredient.method_8103()) {
                this.ingredientTokens.add(IngredientToken.EMPTY);
                continue;
            }
            class_1799 lockedInput = this.lockedInputs != null ? (class_1799)this.lockedInputs.get(i) : class_1799.field_8037;
            IngredientToken ingredientToken = this.accountForIngredient(ingredient, lockedInput);
            if (ingredientToken != null) {
                if (ingredient.method_8105().length <= 1) continue;
                if (this.lockedInputs == null) {
                    this.lockedInputs = class_2371.method_10213((int)this.recipe.method_8117().size(), (Object)class_1799.field_8037);
                }
                this.lockedInputs.set(i, (Object)ingredientToken.peek());
                continue;
            }
            this.missingIngredients.add(ingredient);
            this.missingIngredientsMask |= 1 << i;
        }
        return this;
    }

    @Nullable
    private IngredientToken accountForIngredient(class_1856 ingredient, class_1799 lockedInput) {
        IngredientProvider ingredientProvider;
        IngredientToken ingredientToken;
        List<IngredientProvider> ingredientProviders = this.context.getIngredientProviders();
        int cachedProviderIndex = this.context.getCachedIngredientProviderIndexFor(ingredient);
        if (cachedProviderIndex != -1 && (ingredientToken = this.accountForIngredient(cachedProviderIndex, ingredientProvider = ingredientProviders.get(cachedProviderIndex), ingredient, lockedInput, true)) != null) {
            return ingredientToken;
        }
        for (int j = 0; j < ingredientProviders.size(); ++j) {
            IngredientProvider ingredientProvider2 = ingredientProviders.get(j);
            IngredientToken ingredientToken2 = this.accountForIngredient(j, ingredientProvider2, ingredient, lockedInput, false);
            if (ingredientToken2 == null) continue;
            return ingredientToken2;
        }
        return null;
    }

    @Nullable
    private IngredientToken accountForIngredient(int ingredientProviderIndex, IngredientProvider ingredientProvider, class_1856 ingredient, class_1799 lockedInput, boolean useCache) {
        IngredientCacheHint cacheHint;
        IngredientTokenKey ingredientTokenKey = new IngredientTokenKey(ingredientProviderIndex, ingredient.method_8100());
        Collection scopedIngredientTokens = this.tokensByIngredient.get((Object)ingredientTokenKey);
        IngredientToken ingredientToken = this.findIngredient(ingredientProvider, ingredient, lockedInput, scopedIngredientTokens, cacheHint = useCache ? this.context.getCacheHintFor(ingredientTokenKey) : IngredientCacheHint.NONE);
        if (ingredientToken != null) {
            this.tokensByIngredient.put((Object)ingredientTokenKey, (Object)ingredientToken);
            this.context.cache(ingredientTokenKey, ingredientProviderIndex, ingredientProvider.getCacheHint(ingredientToken));
            this.ingredientTokens.add(ingredientToken);
            return ingredientToken;
        }
        return null;
    }

    @Nullable
    private IngredientToken findIngredient(IngredientProvider ingredientProvider, class_1856 ingredient, class_1799 lockedInput, Collection<IngredientToken> ingredientTokens, IngredientCacheHint cacheHint) {
        IngredientToken ingredientToken = lockedInput.method_7960() ? ingredientProvider.findIngredient(ingredient, ingredientTokens, cacheHint) : ingredientProvider.findIngredient(lockedInput, ingredientTokens, cacheHint);
        return ingredientToken;
    }

    public boolean canCraft() {
        return this.missingIngredients.isEmpty();
    }

    public class_2371<class_1799> getLockedInputs() {
        return this.lockedInputs;
    }

    public List<IngredientToken> getIngredientTokens() {
        return this.ingredientTokens;
    }

    public List<class_1856> getMissingIngredients() {
        return this.missingIngredients;
    }

    public int getMissingIngredientsMask() {
        return this.missingIngredientsMask;
    }

    public record IngredientTokenKey(int providerIndex, IntList stackingIds) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IngredientTokenKey that = (IngredientTokenKey)o;
            return this.providerIndex == that.providerIndex && Objects.equals(this.stackingIds, that.stackingIds);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.providerIndex, this.stackingIds);
        }
    }
}

