/*
 * Decompiled with CFR 0.152.
 */
package net.starliteheart.cobbleride.common.debug;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_243;
import net.starliteheart.cobbleride.common.entity.pokemon.RideablePokemonEntity;
import net.starliteheart.cobbleride.common.util.CobbleRideUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\bJ\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\bJ\r\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\f\u001a\u0004\b\r\u0010\u000eR\"\u0010\u0010\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\"\u0010\u0017\u001a\u00020\u00168\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\"\u0010\u001e\u001a\u00020\u001d8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020$8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lnet/starliteheart/cobbleride/common/debug/PokemonDebugHandler;", "", "Lnet/starliteheart/cobbleride/common/entity/pokemon/RideablePokemonEntity;", "pokemon", "<init>", "(Lnet/starliteheart/cobbleride/common/entity/pokemon/RideablePokemonEntity;)V", "", "changeMode", "()V", "plus", "minus", "reset", "Lnet/starliteheart/cobbleride/common/entity/pokemon/RideablePokemonEntity;", "getPokemon", "()Lnet/starliteheart/cobbleride/common/entity/pokemon/RideablePokemonEntity;", "Lnet/starliteheart/cobbleride/common/debug/PokemonDebugHandler$Mode;", "mode", "Lnet/starliteheart/cobbleride/common/debug/PokemonDebugHandler$Mode;", "getMode", "()Lnet/starliteheart/cobbleride/common/debug/PokemonDebugHandler$Mode;", "setMode", "(Lnet/starliteheart/cobbleride/common/debug/PokemonDebugHandler$Mode;)V", "", "indexOffset", "I", "getIndexOffset", "()I", "setIndexOffset", "(I)V", "Lnet/minecraft/class_243;", "vectorOffset", "Lnet/minecraft/class_243;", "getVectorOffset", "()Lnet/minecraft/class_243;", "setVectorOffset", "(Lnet/minecraft/class_243;)V", "", "step", "D", "Mode", "cobbleride-common"})
public final class PokemonDebugHandler {
    @NotNull
    private final RideablePokemonEntity pokemon;
    @NotNull
    private Mode mode;
    private int indexOffset;
    @NotNull
    private class_243 vectorOffset;
    private final double step;

    public PokemonDebugHandler(@NotNull RideablePokemonEntity pokemon) {
        Intrinsics.checkNotNullParameter((Object)((Object)pokemon), (String)"pokemon");
        this.pokemon = pokemon;
        this.mode = Mode.CHANGE_SEAT;
        class_243 class_2432 = class_243.field_1353;
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"ZERO");
        this.vectorOffset = class_2432;
        this.step = 0.05;
    }

    @NotNull
    public final RideablePokemonEntity getPokemon() {
        return this.pokemon;
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"<set-?>");
        this.mode = mode;
    }

    public final int getIndexOffset() {
        return this.indexOffset;
    }

    public final void setIndexOffset(int n) {
        this.indexOffset = n;
    }

    @NotNull
    public final class_243 getVectorOffset() {
        return this.vectorOffset;
    }

    public final void setVectorOffset(@NotNull class_243 class_2432) {
        Intrinsics.checkNotNullParameter((Object)class_2432, (String)"<set-?>");
        this.vectorOffset = class_2432;
    }

    public final void changeMode() {
        this.mode = switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1 -> Mode.ADJUST_X;
            case 2 -> Mode.ADJUST_Y;
            case 3 -> Mode.ADJUST_Z;
            case 4 -> Mode.CHANGE_SEAT;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final void plus() {
        Triple<Double, Double, Double> triple = CobbleRideUtilsKt.destructVec3(this.vectorOffset);
        double x = ((Number)triple.component1()).doubleValue();
        double y = ((Number)triple.component2()).doubleValue();
        double z = ((Number)triple.component3()).doubleValue();
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                this.indexOffset = (this.indexOffset + 1) % this.pokemon.getSeatCount();
                break;
            }
            case 2: {
                this.vectorOffset = CobbleRideUtilsKt.roundVec3(x + this.step, y, z, 2);
                break;
            }
            case 3: {
                this.vectorOffset = CobbleRideUtilsKt.roundVec3(x, y + this.step, z, 2);
                break;
            }
            case 4: {
                this.vectorOffset = CobbleRideUtilsKt.roundVec3(x, y, z + this.step, 2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void minus() {
        Triple<Double, Double, Double> triple = CobbleRideUtilsKt.destructVec3(this.vectorOffset);
        double x = ((Number)triple.component1()).doubleValue();
        double y = ((Number)triple.component2()).doubleValue();
        double z = ((Number)triple.component3()).doubleValue();
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                this.indexOffset = this.indexOffset > 0 ? this.indexOffset - 1 : this.pokemon.getSeatCount() - 1;
                break;
            }
            case 2: {
                this.vectorOffset = CobbleRideUtilsKt.roundVec3(x - this.step, y, z, 2);
                break;
            }
            case 3: {
                this.vectorOffset = CobbleRideUtilsKt.roundVec3(x, y - this.step, z, 2);
                break;
            }
            case 4: {
                this.vectorOffset = CobbleRideUtilsKt.roundVec3(x, y, z - this.step, 2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void reset() {
        this.indexOffset = 0;
        this.vectorOffset = class_243.field_1353;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lnet/starliteheart/cobbleride/common/debug/PokemonDebugHandler$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "CHANGE_SEAT", "ADJUST_X", "ADJUST_Y", "ADJUST_Z", "cobbleride-common"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode CHANGE_SEAT = new Mode();
        public static final /* enum */ Mode ADJUST_X = new Mode();
        public static final /* enum */ Mode ADJUST_Y = new Mode();
        public static final /* enum */ Mode ADJUST_Z = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.CHANGE_SEAT, Mode.ADJUST_X, Mode.ADJUST_Y, Mode.ADJUST_Z};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.CHANGE_SEAT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.ADJUST_X.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.ADJUST_Y.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.ADJUST_Z.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

