/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.boxlink;

import com.emperdog.boxlink.platform.services.BoxLinkConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class FabricBoxLinkConfig
implements BoxLinkConfig {
    private static Path configFilePath;
    private static Gson gson;
    public static boolean boxLinkBindRequiresItem;

    public static void load() {
        if (FabricBoxLinkConfig.getConfigFilePath().toFile().exists()) {
            try {
                BufferedReader reader = Files.newBufferedReader(FabricBoxLinkConfig.getConfigFilePath());
                Data data = (Data)gson.fromJson((Reader)reader, Data.class);
                boxLinkBindRequiresItem = data.boxLinkBindRequiresItem;
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        FabricBoxLinkConfig.save();
    }

    public static void save() {
        try {
            BufferedWriter writer = Files.newBufferedWriter(FabricBoxLinkConfig.getConfigFilePath(), new OpenOption[0]);
            Data data = new Data(boxLinkBindRequiresItem);
            gson.toJson((Object)data, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Path getConfigFilePath() {
        if (configFilePath == null) {
            configFilePath = FabricLoader.getInstance().getConfigDir().resolve("cobblemonboxlink.json");
        }
        return configFilePath;
    }

    @Override
    public boolean boxLinkBindRequiresItem() {
        return boxLinkBindRequiresItem;
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        boxLinkBindRequiresItem = true;
    }

    private static class Data {
        private final boolean boxLinkBindRequiresItem;

        private Data() {
            this.boxLinkBindRequiresItem = true;
        }

        private Data(boolean boxLinkBindRequiresItem) {
            this.boxLinkBindRequiresItem = boxLinkBindRequiresItem;
        }
    }
}

