/*
 * Decompiled with CFR 0.152.
 */
package winterwolfsv.cobblemon_quests.tasks;

import com.cobblemon.mod.common.CobblemonItemComponents;
import com.cobblemon.mod.common.api.pokeball.PokeBalls;
import com.cobblemon.mod.common.api.pokedex.PokedexEntryProgress;
import com.cobblemon.mod.common.api.pokedex.PokedexManager;
import com.cobblemon.mod.common.api.pokedex.SpeciesDexRecord;
import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.item.components.PokemonItemComponent;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.EnumConfig;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import org.joml.Vector4f;
import winterwolfsv.cobblemon_quests.config.CobblemonQuestsConfig;
import winterwolfsv.cobblemon_quests.tasks.PokemonTaskTypes;
import winterwolfsv.cobblemon_quests.tasks.TaskData;

public class CobblemonTask
extends Task {
    public Icon pokeBallIcon = ItemIcon.getItemIcon((class_1792)PokeBalls.INSTANCE.getPOKE_BALL().item());
    public long amount = 1L;
    public boolean shiny = false;
    public long timeMin = 0L;
    public long timeMax = 24000L;
    public int minLevel = 0;
    public int maxLevel = 0;
    public String dexProgress = "seen";
    public ArrayList<String> actions = new ArrayList();
    public ArrayList<String> biomes = new ArrayList();
    public ArrayList<String> dimensions = new ArrayList();
    public ArrayList<String> forms = new ArrayList();
    public ArrayList<String> genders = new ArrayList();
    public ArrayList<String> pokeBallsUsed = new ArrayList();
    public ArrayList<String> pokemons = new ArrayList();
    public ArrayList<String> pokemonTypes = new ArrayList();
    public ArrayList<String> regions = new ArrayList();
    public ArrayList<String> natures = new ArrayList();

    public CobblemonTask(long id, Quest quest) {
        super(id, quest);
    }

    public TaskType getType() {
        return PokemonTaskTypes.COBBLEMON;
    }

    public long getMaxProgress() {
        return this.amount;
    }

    public void writeData(class_2487 nbt, class_7225.class_7874 provider) {
        super.writeData(nbt, provider);
        nbt.method_10544("amount", this.amount);
        nbt.method_10556("shiny", this.shiny);
        nbt.method_10544("time_min", this.timeMin);
        nbt.method_10544("time_max", this.timeMax);
        nbt.method_10582("action", this.writeList(this.actions));
        nbt.method_10582("biome", this.writeList(this.biomes));
        nbt.method_10582("dimension", this.writeList(this.dimensions));
        nbt.method_10582("pokemon", this.writeList(this.pokemons));
        nbt.method_10582("form", this.writeList(this.forms));
        nbt.method_10582("gender", this.writeList(this.genders));
        nbt.method_10582("poke_ball_used", this.writeList(this.pokeBallsUsed));
        nbt.method_10582("pokemon_type", this.writeList(this.pokemonTypes));
        nbt.method_10582("region", this.writeList(this.regions));
        nbt.method_10582("natures", this.writeList(this.natures));
        nbt.method_10569("min_level", this.minLevel);
        nbt.method_10569("max_level", this.maxLevel);
        nbt.method_10582("dex_progress", this.dexProgress);
    }

    public void readData(class_2487 nbt, class_7225.class_7874 provider) {
        super.readData(nbt, provider);
        this.amount = nbt.method_10537("amount");
        this.shiny = nbt.method_10577("shiny");
        this.timeMin = nbt.method_10537("time_min");
        this.timeMax = nbt.method_10537("time_max");
        this.actions = this.readList(nbt.method_10558("action"));
        this.biomes = this.readList(nbt.method_10558("biome"));
        this.dimensions = this.readList(nbt.method_10558("dimension"));
        this.pokemons = this.readList(nbt.method_10558("pokemon"));
        this.forms = this.readList(nbt.method_10558("form"));
        this.genders = this.readList(nbt.method_10558("gender"));
        this.pokeBallsUsed = this.readList(nbt.method_10558("poke_ball_used"));
        this.pokemonTypes = this.readList(nbt.method_10558("pokemon_type"));
        this.regions = this.readList(nbt.method_10558("region"));
        this.natures = this.readList(nbt.method_10558("natures"));
        this.minLevel = nbt.method_10550("min_level");
        this.maxLevel = nbt.method_10550("max_level");
        this.dexProgress = nbt.method_10558("dex_progress");
        if (!this.forms.isEmpty()) {
            Map<String, String> formReplacements = Map.of("alola", "alolan", "galar", "galarian", "paldea", "paldean", "hisui", "hisuian");
            this.forms.replaceAll(form -> formReplacements.getOrDefault(form, (String)form));
        }
        if (this.timeMin == this.timeMax && this.timeMin == 0L) {
            this.timeMax = 24000L;
        }
        if (nbt.method_10545("value")) {
            this.amount = nbt.method_10537("value");
        }
        if (nbt.method_10545("entity")) {
            this.pokemons = this.readList(nbt.method_10558("entity"));
        }
        if (this.amount == 0L) {
            this.amount = 1L;
        }
        if (this.dexProgress.isEmpty()) {
            this.dexProgress = "seen";
        }
        this.pokemons.remove("minecraft:");
    }

    public void writeNetData(class_9129 buffer) {
        super.writeNetData(buffer);
        buffer.method_52974(this.amount);
        buffer.method_52964(this.shiny);
        buffer.method_52974(this.timeMin);
        buffer.method_52974(this.timeMax);
        buffer.method_10788(this.writeList(this.pokemons), Short.MAX_VALUE);
        buffer.method_10788(this.writeList(this.actions), Short.MAX_VALUE);
        buffer.method_10788(this.writeList(this.biomes), Short.MAX_VALUE);
        buffer.method_10788(this.writeList(this.dimensions), Short.MAX_VALUE);
        buffer.method_10788(this.writeList(this.forms), Short.MAX_VALUE);
        buffer.method_10788(this.writeList(this.genders), Short.MAX_VALUE);
        buffer.method_10788(this.writeList(this.pokeBallsUsed), Short.MAX_VALUE);
        buffer.method_10788(this.writeList(this.pokemonTypes), Short.MAX_VALUE);
        buffer.method_10788(this.writeList(this.regions), Short.MAX_VALUE);
        buffer.method_10788(this.writeList(this.natures), Short.MAX_VALUE);
        buffer.method_53002(this.minLevel);
        buffer.method_53002(this.maxLevel);
        buffer.method_10788(this.dexProgress, Short.MAX_VALUE);
    }

    public void readNetData(class_9129 buffer) {
        super.readNetData(buffer);
        this.amount = buffer.readLong();
        this.shiny = buffer.readBoolean();
        this.timeMin = buffer.readLong();
        this.timeMax = buffer.readLong();
        this.pokemons = this.readList(buffer.method_10800(Short.MAX_VALUE));
        this.actions = this.readList(buffer.method_10800(Short.MAX_VALUE));
        this.biomes = this.readList(buffer.method_10800(Short.MAX_VALUE));
        this.dimensions = this.readList(buffer.method_10800(Short.MAX_VALUE));
        this.forms = this.readList(buffer.method_10800(Short.MAX_VALUE));
        this.genders = this.readList(buffer.method_10800(Short.MAX_VALUE));
        this.pokeBallsUsed = this.readList(buffer.method_10800(Short.MAX_VALUE));
        this.pokemonTypes = this.readList(buffer.method_10800(Short.MAX_VALUE));
        this.regions = this.readList(buffer.method_10800(Short.MAX_VALUE));
        this.natures = this.readList(buffer.method_10800(Short.MAX_VALUE));
        this.minLevel = buffer.readInt();
        this.maxLevel = buffer.readInt();
        this.dexProgress = buffer.method_10800(Short.MAX_VALUE);
    }

    public String writeList(ArrayList<String> list) {
        list.removeIf(Objects::isNull);
        return String.join((CharSequence)",", list);
    }

    public ArrayList<String> readList(String s) {
        return Arrays.stream(s.split(",")).map(String::trim).filter(obj -> !obj.isEmpty() && !obj.contains("choice_any")).distinct().collect(Collectors.toCollection(ArrayList::new));
    }

    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        assert (class_310.method_1551().field_1687 != null);
        class_5455 registryManager = class_310.method_1551().field_1687.method_30349();
        this.addConfigList(config, "actions", this.actions, TaskData.actionList, null, null);
        Function<String, String> pokemonNameProcessor = name -> name.replace(":", ".species.") + ".name";
        List pokemonList = PokemonSpecies.INSTANCE.getSpecies().stream().map(species -> species.resourceIdentifier.toString()).sorted().collect(Collectors.toCollection(() -> new ArrayList(PokemonSpecies.INSTANCE.getSpecies().size() + 1)));
        pokemonList.add("cobblemon_quests");
        this.addConfigList(config, "pokemons", this.pokemons, pokemonList, this::getPokemonIcon, pokemonNameProcessor);
        config.addLong("amount", this.amount, v -> {
            this.amount = v;
        }, 1L, 1L, Long.MAX_VALUE).setNameKey("cobblemon_quests.task.amount");
        config.addBool("shiny", this.shiny, v -> {
            this.shiny = v;
        }, false).setNameKey("cobblemon_quests.task.shiny");
        Function<String, String> pokeBallNameProcessor = name -> "item." + name.replace(":", ".");
        List pokeBallList = PokeBalls.INSTANCE.all().stream().map(pokeBall -> pokeBall.getName().toString()).sorted().collect(Collectors.toCollection(() -> new ArrayList(PokeBalls.INSTANCE.all().size() + 1)));
        pokeBallList.add("cobblemon_quests");
        this.addConfigList(config, "pokeballs", this.pokeBallsUsed, pokeBallList, this::getIconFromIdentifier, pokeBallNameProcessor);
        this.addConfigList(config, "forms", this.forms, TaskData.formList, null, null);
        this.addConfigList(config, "genders", this.genders, TaskData.genderList, null, null);
        Function<String, String> pokemonTypeNameProcessor = name -> "cobblemon.type." + name;
        this.addConfigList(config, "pokemon_types", this.pokemonTypes, TaskData.pokemonTypeList, null, pokemonTypeNameProcessor);
        this.addConfigList(config, "regions", this.regions, TaskData.regionList, null, null);
        Function<String, String> biomeAndDimensionNameProcessor = name -> "(" + name.replace("_", " ").replace(":", ") ");
        List<String> biomeList = registryManager.method_30530(class_7924.field_41236).method_29722().stream().map(entry -> ((class_5321)entry.getKey()).method_29177().toString()).toList();
        this.addConfigList(config, "biomes", this.biomes, biomeList, null, biomeAndDimensionNameProcessor);
        ArrayList<String> dimensionList = new ArrayList<String>(registryManager.method_30530(class_7924.field_41241).method_29722().stream().map(entry -> ((class_5321)entry.getKey()).method_29177().toString()).toList());
        dimensionList.remove("minecraft:overworld_caves");
        this.addConfigList(config, "dimensions", this.dimensions, dimensionList, null, biomeAndDimensionNameProcessor);
        config.addLong("time_min", this.timeMin, v -> {
            this.timeMin = v;
        }, 0L, 0L, 24000L).setNameKey("cobblemon_quests.task.time_min");
        config.addLong("time_max", this.timeMax, v -> {
            this.timeMax = v;
        }, 24000L, 0L, 24000L).setNameKey("cobblemon_quests.task.time_max");
        config.addInt("min_level", this.minLevel, v -> {
            this.minLevel = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("cobblemon_quests.task.min_level");
        config.addInt("max_level", this.maxLevel, v -> {
            this.maxLevel = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("cobblemon_quests.task.max_level");
        List<String> dexProgressList = List.of("caught", "seen");
        config.addEnum("dex_progress", (Object)this.dexProgress, v -> {
            this.dexProgress = v;
        }, NameMap.of((Object)this.dexProgress, dexProgressList).nameKey(v -> "cobblemon_quests.dex_progress." + v).create(), (Object)this.dexProgress).setNameKey("cobblemon_quests.task.dex_progress");
        List<String> natureList = Natures.INSTANCE.all().stream().map(Nature::getDisplayName).toList();
        this.addConfigList(config, "natures", this.natures, natureList, null, s -> s);
    }

    private void addConfigList(ConfigGroup config, String listName, List<String> listData, List<String> optionsList, Function<class_2960, Icon> iconProcessor, Function<String, String> nameProcessor) {
        NameMap nameMap = NameMap.of((Object)optionsList.getFirst(), optionsList).id(s -> s).name(s -> class_2561.method_43471((String)(nameProcessor == null ? "cobblemon_quests." + listName + "." + s : (String)nameProcessor.apply((String)s)))).icon(s -> iconProcessor == null ? this.pokeBallIcon : (Icon)iconProcessor.apply(class_2960.method_60654((String)s))).create();
        config.addList(listName, listData, (ConfigValue)new EnumConfig(nameMap), (Object)optionsList.getLast()).setNameKey("cobblemon_quests.task." + listName);
    }

    @Environment(value=EnvType.CLIENT)
    public class_2561 getAltTitle() {
        StringBuilder titleBuilder = new StringBuilder();
        for (String action : this.actions) {
            titleBuilder.append(class_2561.method_43471((String)("cobblemon_quests.actions." + action)).getString()).append(" ");
        }
        if (this.actions.contains("have_registered") || this.actions.contains("register")) {
            titleBuilder.append("(").append(this.dexProgress).append(") ");
        }
        titleBuilder.append(this.amount).append("x ");
        if (this.shiny) {
            titleBuilder.append(class_2561.method_43471((String)"cobblemon_quests.task.shiny").getString()).append(" ");
        }
        for (String gender : this.genders) {
            titleBuilder.append(class_2561.method_43471((String)("cobblemon_quests.genders." + gender)).getString()).append(" ");
        }
        for (String form : this.forms) {
            titleBuilder.append(class_2561.method_43471((String)("cobblemon_quests.forms." + form)).getString()).append(" ");
        }
        for (String region : this.regions) {
            titleBuilder.append(class_2561.method_43471((String)("cobblemon_quests.regions." + region)).getString()).append(" ");
        }
        for (String pokemonType : this.pokemonTypes) {
            titleBuilder.append(class_2561.method_43471((String)("cobblemon.type." + pokemonType)).getString()).append(" ");
        }
        for (String nature : this.natures) {
            titleBuilder.append(class_2561.method_43471((String)nature).getString()).append(" ");
        }
        if (this.pokemons.isEmpty()) {
            titleBuilder.append(class_2561.method_43471((String)"cobblemon_quests.task.pokemons").getString()).append(" ");
        } else {
            for (String pokemon : this.pokemons) {
                titleBuilder.append(class_2561.method_43471((String)("cobblemon.species." + pokemon.split(":")[1] + ".name")).getString()).append(" ");
                if (this.pokemons.indexOf(pokemon) == this.pokemons.size() - 1) continue;
                titleBuilder.append("or ");
            }
        }
        for (String pokeballUsed : this.pokeBallsUsed) {
            if (this.pokeBallsUsed.indexOf(pokeballUsed) == 0) {
                titleBuilder.append("using a ");
            } else {
                titleBuilder.append("or ");
            }
            titleBuilder.append(class_2561.method_43471((String)("item." + pokeballUsed.replace(":", "."))).getString()).append(" ");
        }
        for (String dimension : this.dimensions) {
            titleBuilder.append("in ").append(dimension.split(":")[1].replace("_", " ")).append(" ");
        }
        for (String biome : this.biomes) {
            titleBuilder.append("in a ").append(biome.split(":")[1].replace("_", " ")).append(" biome ");
        }
        if (this.timeMin != 0L || this.timeMax != 24000L) {
            titleBuilder.append("between the time ").append(this.timeMin).append(" and ").append(this.timeMax).append(" ");
        }
        if (this.maxLevel != 0) {
            if (this.minLevel == this.maxLevel) {
                titleBuilder.append("at level ").append(this.minLevel).append(" ");
            } else {
                titleBuilder.append("between level ").append(this.minLevel).append(" and ").append(this.maxLevel).append(" ");
            }
        }
        return class_2561.method_43470((String)titleBuilder.toString().trim());
    }

    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        if (this.pokemons.isEmpty()) {
            return this.pokeBallIcon;
        }
        return this.getPokemonIcon(class_2960.method_60654((String)this.pokemons.getFirst()));
    }

    public Icon getIconFromIdentifier(class_2960 ResourceLocation) {
        class_1799 itemStack = ((class_1792)class_7923.field_41178.method_10223(ResourceLocation)).method_7854();
        if (itemStack.method_7960()) {
            return this.pokeBallIcon;
        }
        return ItemIcon.getItemIcon((class_1799)itemStack);
    }

    public Icon getPokemonIcon(class_2960 pokemon) {
        class_1792 pokemonModelItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60655((String)"cobblemon", (String)"pokemon_model"));
        class_2487 nbt = new class_2487();
        nbt.method_10582("species", pokemon.toString());
        class_1799 stack = new class_1799((class_1935)pokemonModelItem);
        PokemonItemComponent c = new PokemonItemComponent(pokemon, new HashSet(), new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
        stack.method_57379(CobblemonItemComponents.INSTANCE.getPOKEMON_ITEM(), (Object)c);
        return ItemIcon.getItemIcon((class_1799)stack);
    }

    public void increase(TeamData teamData, Pokemon pokemon, String executedAction, long progress, class_3222 player) {
        List<String> obtainingMethods = List.of("catch", "evolve-into", "trade_for", "obtain", "revive_fossil");
        if (this.actions.contains(executedAction) || this.actions.contains("obtain") && obtainingMethods.contains(executedAction)) {
            boolean shouldAddProgress;
            if (CobblemonQuestsConfig.ignoredPokemon.contains(pokemon.getSpecies().toString().toLowerCase())) {
                return;
            }
            class_1937 world = player.method_37908();
            if (!this.regions.isEmpty() && !this.regions.contains(pokemon.getSpecies().getLabels().toArray()[0].toString())) {
                return;
            }
            if (this.timeMin != 0L || this.timeMax != 24000L) {
                long timeOfDay = world.method_8532() % 24000L;
                long actualMin = this.timeMin;
                long actualMax = this.timeMax;
                if (this.timeMin > this.timeMax) {
                    actualMax = this.timeMax + 24000L;
                    if (timeOfDay < this.timeMin) {
                        timeOfDay += 24000L;
                    }
                }
                if (timeOfDay < actualMin || timeOfDay >= actualMax) {
                    return;
                }
            }
            if (this.maxLevel != 0 && (pokemon.getLevel() > this.maxLevel || pokemon.getLevel() < this.minLevel)) {
                return;
            }
            if (!this.pokeBallsUsed.isEmpty() && !this.pokeBallsUsed.contains(pokemon.getCaughtBall().getName().toString())) {
                return;
            }
            if (!this.dimensions.isEmpty() && !this.dimensions.contains(world.method_27983().method_29177().toString())) {
                return;
            }
            if (!this.biomes.isEmpty() && !this.biomes.contains(((class_5321)world.method_23753(player.method_24515()).method_40230().get()).method_29177().toString())) {
                return;
            }
            if (!this.genders.isEmpty() && !this.genders.contains(pokemon.getGender().toString().toLowerCase())) {
                return;
            }
            if (!this.forms.isEmpty()) {
                boolean flag = this.forms.contains(pokemon.getForm().getName().toLowerCase());
                for (String aspect : pokemon.getAspects()) {
                    if (!this.forms.contains(aspect)) continue;
                    flag = true;
                    break;
                }
                if (!flag) {
                    return;
                }
            }
            if (!this.pokemonTypes.isEmpty()) {
                boolean flag = false;
                for (ElementalType type : pokemon.getTypes()) {
                    if (!this.pokemonTypes.contains(type.getName().toLowerCase())) continue;
                    flag = true;
                    break;
                }
                if (!flag) {
                    return;
                }
            }
            if (!this.natures.isEmpty() && !this.natures.contains(pokemon.getNature().getDisplayName())) {
                return;
            }
            if (!pokemon.getShiny() && this.shiny) {
                return;
            }
            boolean bl = shouldAddProgress = this.pokemons.stream().anyMatch(p -> p.split(":").length > 1 && p.split(":")[1].equals(pokemon.getSpecies().toString())) || this.pokemons.isEmpty();
            if (shouldAddProgress) {
                if (executedAction.equals("level_up_to")) {
                    if (teamData.getProgress((Task)this) < progress) {
                        teamData.setProgress((Task)this, progress);
                    }
                    return;
                }
                if (executedAction.equals("register")) {
                    if (this.dexProgress.equals("seen")) {
                        progress = progress == 1L ? 0L : 1L;
                    } else if (this.dexProgress.equals("caught")) {
                        progress = progress != 0L ? 0L : 1L;
                    }
                }
                teamData.addProgress((Task)this, progress);
            }
        }
    }

    public void increaseHaveRegistered(TeamData teamData, PokedexManager pokedexManager) {
        if (!this.actions.contains("have_registered")) {
            return;
        }
        if (teamData.isCompleted((QuestObject)this)) {
            return;
        }
        long progress = 0L;
        Map dexRecords = pokedexManager.getSpeciesRecords();
        for (class_2960 record : dexRecords.keySet()) {
            Species species;
            SpeciesDexRecord dexRecord = (SpeciesDexRecord)dexRecords.get(record);
            if (!this.pokemons.isEmpty() && !this.pokemons.contains(record.toString())) continue;
            Set aspects = dexRecord.getAspects();
            boolean flag = false;
            if (Objects.equals(this.dexProgress, "caught") && !dexRecord.getKnowledge().equals((Object)PokedexEntryProgress.CAUGHT) || this.shiny && !aspects.contains("shiny")) continue;
            if (!this.genders.isEmpty()) {
                for (String gender : this.genders) {
                    if (!aspects.contains(gender)) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                flag = false;
            }
            if (!this.forms.isEmpty()) {
                for (String form : this.forms) {
                    if (!aspects.contains(form)) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                flag = false;
            }
            if ((species = PokemonSpecies.INSTANCE.getByIdentifier(record)) == null || !this.regions.isEmpty() && !this.regions.contains(species.getLabels().toArray()[0].toString())) continue;
            if (!this.pokemonTypes.isEmpty()) {
                for (ElementalType type : species.getTypes()) {
                    if (!this.pokemonTypes.contains(type.getName().toLowerCase())) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
            }
            ++progress;
        }
        teamData.setProgress((Task)this, progress);
    }

    public void increaseWoPokemon(TeamData teamData, String data, String executedAction, long progress) {
        if (this.actions.contains(executedAction) && (this.forms.contains(data) || this.forms.isEmpty())) {
            teamData.addProgress((Task)this, progress);
        }
    }
}

