/*
 * Decompiled with CFR 0.152.
 */
package winterwolfsv.cobblemon_quests.commands.arguments.types;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import winterwolfsv.cobblemon_quests.tasks.TaskData;

public class ActionListArgumentType
implements ArgumentType<List<String>> {
    private final List<String> values = TaskData.actionList;
    private final char delimiter = (char)44;

    public static ActionListArgumentType actionList() {
        return new ActionListArgumentType();
    }

    public static List<String> getActionList(CommandContext<?> context, String name) {
        return (List)context.getArgument(name, List.class);
    }

    public List<String> parse(StringReader reader) throws CommandSyntaxException {
        ArrayList<String> result = new ArrayList<String>();
        reader.expect('{');
        while (reader.canRead() && reader.peek() != '}') {
            reader.skipWhitespace();
            int start = reader.getCursor();
            while (reader.canRead() && reader.peek() != ',' && reader.peek() != '}') {
                reader.skip();
            }
            String value = reader.getString().substring(start, reader.getCursor()).trim();
            if (!value.isEmpty()) {
                result.add(value.toLowerCase());
            }
            if (!reader.canRead() || reader.peek() != ',') continue;
            reader.skip();
        }
        reader.expect('}');
        return result;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (!builder.getRemaining().startsWith("{")) {
            builder.suggest("{");
            return builder.buildFuture();
        }
        for (String value : this.values) {
            String suggestion = this.getSuggestion(value, builder.getRemaining());
            if (suggestion == null) continue;
            builder.suggest(suggestion);
        }
        return builder.buildFuture();
    }

    private String getSuggestion(String value, String current) {
        ArrayList<String> currentList = new ArrayList<String>(Arrays.stream(current.split("[,{]")).map(String::strip).map(String::toLowerCase).toList());
        if (currentList.isEmpty()) {
            currentList.add("");
        }
        if (value.toLowerCase().startsWith((String)currentList.getLast())) {
            return current + value.substring(((String)currentList.getLast()).length());
        }
        return null;
    }
}

