/*
 * Decompiled with CFR 0.152.
 */
package ca.landonjw.mixin.battle.log;

import ca.landonjw.BattleLogRenderer;
import ca.landonjw.GUIHandler;
import ca.landonjw.ResizeableTextQueue;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.battle.ClientBattleMessageQueue;
import com.cobblemon.mod.common.client.gui.battle.widgets.BattleMessagePane;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BattleMessagePane.class})
public abstract class BattleMessagePaneMixin
extends class_350 {
    @Shadow(remap=false)
    @Final
    public static int TEXT_BOX_WIDTH;
    @Shadow(remap=false)
    @Final
    public static int TEXT_BOX_HEIGHT;
    @Shadow(remap=false)
    private float opacity;
    @Shadow(remap=false)
    private boolean scrolling;
    @Unique
    private final List<class_2561> battleMessages = new ArrayList<class_2561>();

    @Shadow(remap=false)
    protected abstract void correctSize();

    @Shadow(remap=false)
    protected abstract int addEntry(@NotNull BattleMessagePane.BattleMessageLine var1);

    @Shadow(remap=false)
    protected abstract void updateScrollingState(double var1, double var3);

    public BattleMessagePaneMixin(class_310 minecraft, int i, int j, int k, int l) {
        super(minecraft, i, j, k, l);
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lcom/cobblemon/mod/common/client/battle/ClientBattleMessageQueue;subscribe(Lkotlin/jvm/functions/Function1;)V"), remap=false)
    private void cobblemon_ui_tweaks$init(ClientBattleMessageQueue instance, Function1<? super class_5481, Unit> $i$f$forEach) {
        this.method_25307(this.method_25331());
        ResizeableTextQueue queueWithBattleMessages = (ResizeableTextQueue)instance;
        queueWithBattleMessages.cobblemon_ui_tweaks$subscribe(text -> {
            this.battleMessages.add((class_2561)text);
            this.cobblemon_ui_tweaks$correctBattleText();
        });
    }

    @Inject(method={"correctSize"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void cobblemon_ui_tweaks$correctSize(CallbackInfo ci) {
        this.method_55444(this.getWidthOverride() + 6, this.getHeightOverride(), (int)this.getBattleLogX(), (int)this.getBattleLogY() + 6);
        ci.cancel();
    }

    @Unique
    private void cobblemon_ui_tweaks$correctBattleText() {
        boolean isFullyScrolled = (double)this.method_25331() - this.method_25341() < 10.0;
        this.method_25339();
        class_327 textRenderer = class_310.method_1551().field_1772;
        for (class_2561 message : this.battleMessages) {
            class_5250 line = message.method_27661().method_10862(message.method_10866().method_10982(Boolean.valueOf(true)).method_27704(CobblemonResources.INSTANCE.getDEFAULT_LARGE()));
            List wrappedLines = textRenderer.method_27527().method_27495((class_5348)line, this.getWidthOverride() - 11, line.method_10866());
            List lines = class_2477.method_10517().method_30933(wrappedLines);
            for (class_5481 finalLine : lines) {
                this.addEntry(new BattleMessagePane.BattleMessageLine((BattleMessagePane)this, finalLine));
            }
        }
        if (isFullyScrolled) {
            this.method_25307(this.method_25331());
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY);
        if (this.scrolling) {
            this.method_25395((class_364)this.method_25308(mouseX, mouseY));
            this.method_25398(true);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Unique
    private int getWidthOverride() {
        return GUIHandler.INSTANCE.getBattleLogWidth();
    }

    @Unique
    private void setWidthOverride(int width) {
        GUIHandler.INSTANCE.setBattleLogWidth(width);
    }

    @Unique
    private int getHeightOverride() {
        return GUIHandler.INSTANCE.getBattleLogHeight();
    }

    @Unique
    private void setHeightOverride(int height) {
        GUIHandler.INSTANCE.setBattleLogHeight(height);
    }

    @Unique
    private int getFrameWidth() {
        return this.getWidthOverride() + 16;
    }

    @Unique
    private int getFrameHeight() {
        return this.getHeightOverride() + 9;
    }

    @Unique
    private double getBattleLogX() {
        return GUIHandler.INSTANCE.getBattleLogX();
    }

    @Unique
    private void setBattleLogX(double value) {
        GUIHandler.INSTANCE.setBattleLogX(value);
    }

    @Unique
    private double getBattleLogY() {
        return GUIHandler.INSTANCE.getBattleLogY();
    }

    @Unique
    private void setBattleLogY(double value) {
        GUIHandler.INSTANCE.setBattleLogY(value);
    }

    @Inject(method={"mouseDragged"}, at={@At(value="TAIL")})
    private void cobblemon_ui_tweaks$mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY, CallbackInfoReturnable<Boolean> cir) {
        if (this.tryMove(mouseX, mouseY, deltaX, deltaY)) {
            return;
        }
        this.tryAdjustWidth(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Unique
    private boolean tryMove(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (mouseY - deltaY < (double)(this.method_46427() - 5) || mouseY - deltaY > (double)(this.method_46427() + 5)) {
            return false;
        }
        if (mouseX - deltaX < (double)(this.method_46426() - 5) || mouseX - deltaX > (double)(this.method_46426() + this.method_25368() + 5)) {
            return false;
        }
        this.setBattleLogX(this.getBattleLogX() + deltaX);
        this.setBattleLogY(this.getBattleLogY() + deltaY);
        return true;
    }

    @Unique
    private boolean tryAdjustWidth(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 1) {
            return false;
        }
        int expandButtonX1 = this.getFrameWidth() - 9;
        int expandButtonX2 = this.getFrameWidth() - 4;
        int expandButtonY1 = this.getFrameHeight() - 9;
        int expandButtonY2 = this.getFrameHeight() - 4;
        if (mouseX - deltaX < (double)(this.method_46426() + expandButtonX1 - 10) || mouseX - deltaX > (double)(this.method_46426() + expandButtonX2 + 10)) {
            return false;
        }
        if (mouseY - deltaY < (double)(this.method_46427() + expandButtonY1 - 10) || mouseY - deltaY > (double)(this.method_46427() + expandButtonY2 + 10)) {
            return false;
        }
        double newHeight = Math.max(mouseY - (double)this.method_46427(), (double)TEXT_BOX_HEIGHT);
        double newWidth = Math.max(mouseX - (double)this.method_46426(), (double)TEXT_BOX_WIDTH);
        this.setHeightOverride((int)newHeight);
        this.setWidthOverride((int)newWidth - 12);
        this.correctSize();
        this.cobblemon_ui_tweaks$correctBattleText();
        return true;
    }

    @Inject(method={"renderWidget"}, at={@At(value="HEAD")}, cancellable=true)
    private void cobblemon_ui_tweaks$render(class_332 context, int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        boolean isFullyScrolled;
        this.correctSize();
        boolean bl = isFullyScrolled = this.opacity != 1.0f || (double)this.method_25331() - this.method_25341() < 2.0;
        if (isFullyScrolled) {
            this.method_25307(this.method_25331());
        }
        BattleLogRenderer.INSTANCE.render(context, (int)Math.round(this.getBattleLogX()), (int)Math.round(this.getBattleLogY()), this.getFrameHeight(), this.getFrameWidth(), this.opacity);
        context.method_44379(this.method_46426() + 5, (int)Math.round(this.getBattleLogY() + 6.0), this.method_46426() + 5 + this.getWidthOverride(), (int)Math.round(this.getBattleLogY() + 6.0 + (double)this.getHeightOverride()));
        super.method_48579(context, mouseX, mouseY, partialTicks);
        context.method_44380();
        ci.cancel();
    }

    public int method_25322() {
        return this.getWidthOverride();
    }

    public int method_25342() {
        return this.method_46426() + 10;
    }

    protected int method_25329() {
        return this.method_46426() + this.getWidthOverride();
    }
}

