/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.counter.api;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.counter.api.ScoreType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\f\u00a2\u0006\u0004\b\r\u0010\u000eR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lus/timinc/mc/cobblemon/counter/api/ScoreTypeRegistry;", "", "<init>", "()V", "Lus/timinc/mc/cobblemon/counter/api/ScoreType;", "scoreType", "registerScoreType", "(Lus/timinc/mc/cobblemon/counter/api/ScoreType;)Lus/timinc/mc/cobblemon/counter/api/ScoreType;", "", "type", "findByType", "(Ljava/lang/String;)Lus/timinc/mc/cobblemon/counter/api/ScoreType;", "", "types", "()Ljava/util/List;", "", "scoreTypes", "Ljava/util/Map;", "cobblemon-counter"})
public final class ScoreTypeRegistry {
    @NotNull
    public static final ScoreTypeRegistry INSTANCE = new ScoreTypeRegistry();
    @NotNull
    private static final Map<String, ScoreType> scoreTypes = new LinkedHashMap();

    private ScoreTypeRegistry() {
    }

    @NotNull
    public final ScoreType registerScoreType(@NotNull ScoreType scoreType) {
        Intrinsics.checkNotNullParameter((Object)scoreType, (String)"scoreType");
        if (scoreTypes.containsKey(scoreType.getType())) {
            throw new Error("Attempted to register Score type " + scoreType.getType() + " twice");
        }
        scoreTypes.put(scoreType.getType(), scoreType);
        return scoreType;
    }

    @NotNull
    public final ScoreType findByType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ScoreType scoreType = scoreTypes.get(type);
        Intrinsics.checkNotNull((Object)scoreType);
        return scoreType;
    }

    @NotNull
    public final List<String> types() {
        return CollectionsKt.toList((Iterable)scoreTypes.keySet());
    }
}

