/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.counter.api;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.reactive.CancelableObservable;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.storage.player.InstancedPlayerData;
import com.cobblemon.mod.common.api.storage.player.client.ClientInstancedPlayerData;
import com.cobblemon.mod.common.net.messages.client.SetClientPlayerDataPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.timinc.mc.cobblemon.counter.CounterMod;
import us.timinc.mc.cobblemon.counter.api.AbstractCounterManager;
import us.timinc.mc.cobblemon.counter.api.ClientCounterManager;
import us.timinc.mc.cobblemon.counter.api.Counter;
import us.timinc.mc.cobblemon.counter.api.CounterType;
import us.timinc.mc.cobblemon.counter.api.CounterTypeRegistry;
import us.timinc.mc.cobblemon.counter.api.Streak;
import us.timinc.mc.cobblemon.counter.config.FormOverride;
import us.timinc.mc.cobblemon.counter.event.BreakStreakEvent;
import us.timinc.mc.cobblemon.counter.event.CounterEvents;
import us.timinc.mc.cobblemon.counter.event.RecordEvent;
import us.timinc.mc.cobblemon.counter.storage.PlayerInstancedDataStores;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B%\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\t\u0010\nJC\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J1\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00062\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0019\u0010\u001aJ-\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ-\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001f\u0010\u001eJ\u000f\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u001d\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0019\u0010#R\u001a\u0010\u0004\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010$\u001a\u0004\b%\u0010&R&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\b\u0010'\u001a\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lus/timinc/mc/cobblemon/counter/api/CounterManager;", "Lus/timinc/mc/cobblemon/counter/api/AbstractCounterManager;", "Lcom/cobblemon/mod/common/api/storage/player/InstancedPlayerData;", "Ljava/util/UUID;", "uuid", "", "Lus/timinc/mc/cobblemon/counter/api/CounterType;", "Lus/timinc/mc/cobblemon/counter/api/Counter;", "counters", "<init>", "(Ljava/util/UUID;Ljava/util/Map;)V", "counterType", "Lnet/minecraft/class_2960;", "speciesId", "", "formName", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "silently", "breakStreak", "(Lus/timinc/mc/cobblemon/counter/api/CounterType;Lnet/minecraft/class_2960;Ljava/lang/String;Lcom/cobblemon/mod/common/pokemon/Pokemon;Z)Z", "initialSpeciesId", "initialFormName", "", "record", "(Lnet/minecraft/class_2960;Ljava/lang/String;Lus/timinc/mc/cobblemon/counter/api/CounterType;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "", "score", "setStreakScore", "(Lus/timinc/mc/cobblemon/counter/api/CounterType;Lnet/minecraft/class_2960;Ljava/lang/String;I)V", "setCountScore", "Lus/timinc/mc/cobblemon/counter/api/ClientCounterManager;", "toClientData", "()Lus/timinc/mc/cobblemon/counter/api/ClientCounterManager;", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lus/timinc/mc/cobblemon/counter/api/CounterType;)V", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "Ljava/util/Map;", "getCounters", "()Ljava/util/Map;", "Companion", "cobblemon-counter"})
@SourceDebugExtension(value={"SMAP\nCounterManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CounterManager.kt\nus/timinc/mc/cobblemon/counter/api/CounterManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable\n+ 4 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 CancelableObservable.java\ncom/cobblemon/mod/common/api/reactive/CancelableObservable$postThen$1\n+ 7 EventObservable.java\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n+ 8 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 9 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,215:1\n1279#2,2:216\n1293#2,4:218\n1557#2:284\n1628#2,3:285\n1279#2,2:288\n1293#2,4:290\n1279#2,2:294\n1293#2,4:296\n39#3,2:222\n41#3,2:227\n44#3,3:230\n47#3:235\n39#3,2:245\n41#3,2:250\n44#3,3:253\n47#3:258\n17#4,2:224\n19#4:234\n14#4,5:236\n19#4:244\n17#4,2:247\n19#4:257\n14#4,5:266\n19#4:274\n13346#5:226\n13347#5:233\n13346#5:241\n13347#5:243\n13346#5:249\n13347#5:256\n13346#5:271\n13347#5:273\n39#6:229\n39#6:252\n14#7:242\n14#7:272\n381#8,7:259\n381#8,7:275\n216#9,2:282\n*S KotlinDebug\n*F\n+ 1 CounterManager.kt\nus/timinc/mc/cobblemon/counter/api/CounterManager\n*L\n23#1:216,2\n23#1:218,4\n29#1:284\n29#1:285,3\n30#1:288,2\n30#1:290,4\n32#1:294,2\n32#1:296,4\n55#1:222,2\n55#1:227,2\n55#1:230,3\n55#1:235\n109#1:245,2\n109#1:250,2\n109#1:253,3\n109#1:258\n55#1:224,2\n55#1:234\n77#1:236,5\n77#1:244\n109#1:247,2\n109#1:257\n149#1:266,5\n149#1:274\n55#1:226\n55#1:233\n77#1:241\n77#1:243\n109#1:249\n109#1:256\n149#1:271\n149#1:273\n55#1:229\n109#1:252\n77#1:242\n149#1:272\n117#1:259,7\n182#1:275,7\n205#1:282,2\n*E\n"})
public final class CounterManager
extends AbstractCounterManager
implements InstancedPlayerData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID uuid;
    @NotNull
    private final Map<CounterType, Counter> counters;
    @NotNull
    private static final Codec<CounterManager> CODEC;

    public CounterManager(@NotNull UUID uuid, @NotNull Map<CounterType, Counter> counters) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter(counters, (String)"counters");
        this.uuid = uuid;
        this.counters = counters;
    }

    public /* synthetic */ CounterManager(UUID uUID, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Iterable $this$associateWith$iv = CounterTypeRegistry.INSTANCE.counterTypes();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                CounterType counterType = (CounterType)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl = false;
                Counter counter = new Counter(null, null, 3, null);
                map2.put(t, counter);
            }
            map = result$iv;
        }
        this(uUID, map);
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    @NotNull
    public Map<CounterType, Counter> getCounters() {
        return this.counters;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean breakStreak(@NotNull CounterType counterType, @Nullable class_2960 speciesId, @Nullable String formName, @Nullable Pokemon pokemon, boolean silently) {
        void events$iv;
        EventObservable<BreakStreakEvent.Post> $this$iv;
        BreakStreakEvent.Post[] event$iv;
        Intrinsics.checkNotNullParameter((Object)counterType, (String)"counterType");
        if (!silently) {
            void this_$iv$iv;
            boolean doBreak = false;
            CancelableObservable<BreakStreakEvent.Pre> cancelableObservable = CounterEvents.BREAK_STREAK_PRE;
            event$iv = (BreakStreakEvent.Post[])new BreakStreakEvent.Pre(this, counterType, new BreakStreakEvent.Cause(speciesId, formName, pokemon));
            boolean $i$f$postThen = false;
            EventObservable<BreakStreakEvent.Post> eventObservable = $this$iv;
            Cancelable[] cancelableArray = new Cancelable[]{event$iv};
            Cancelable[] events$iv$iv = cancelableArray;
            boolean $i$f$post = false;
            this_$iv$iv.emit((Object[])Arrays.copyOf(events$iv$iv, events$iv$iv.length));
            Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                BreakStreakEvent.Pre it;
                Cancelable element$iv$iv$iv;
                Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                if (it$iv.isCanceled()) {
                    Cancelable cancelable = it$iv;
                    boolean bl2 = false;
                    it = cancelable;
                    continue;
                }
                it = (BreakStreakEvent.Pre)it$iv;
                boolean bl3 = false;
                doBreak = true;
            }
            if (!doBreak) {
                return false;
            }
        }
        Counter counter = this.getCounter(counterType);
        if (speciesId != null && formName != null) {
            counter.setStreak(new Streak(speciesId, formName, 1));
        } else {
            counter.setStreak(new Streak(null, null, 0, 7, null));
        }
        $this$iv = CounterEvents.BREAK_STREAK_POST;
        event$iv = new BreakStreakEvent.Post[]{new BreakStreakEvent.Post(this, counterType, new BreakStreakEvent.Cause(speciesId, formName, pokemon))};
        boolean $i$f$post = false;
        $this$iv.emit((Object[])Arrays.copyOf(events$iv, ((void)events$iv).length));
        void $this$forEach$iv$iv = events$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void var15_20 = element$iv$iv = $this$forEach$iv$iv[i];
            boolean bl = false;
            void it = var15_20;
        }
        return true;
    }

    public static /* synthetic */ boolean breakStreak$default(CounterManager counterManager, CounterType counterType, class_2960 class_29602, String string, Pokemon pokemon, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            class_29602 = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            pokemon = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return counterManager.breakStreak(counterType, class_29602, string, pokemon, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void record(@NotNull class_2960 initialSpeciesId, @NotNull String initialFormName, @NotNull CounterType counterType, @Nullable Pokemon pokemon) {
        void events$iv;
        void $this$iv;
        EventObservable<RecordEvent.Post> eventObservable;
        EventObservable<RecordEvent.Post> answer$iv;
        RecordEvent.Pre it;
        void this_$iv$iv;
        void $this$iv2;
        String string;
        class_2960 speciesId;
        FormOverride formOverride;
        Intrinsics.checkNotNullParameter((Object)initialSpeciesId, (String)"initialSpeciesId");
        Intrinsics.checkNotNullParameter((Object)initialFormName, (String)"initialFormName");
        Intrinsics.checkNotNullParameter((Object)counterType, (String)"counterType");
        FormOverride formOverride2 = formOverride = CounterMod.INSTANCE.getConfig().getFormOverride(initialSpeciesId, initialFormName);
        class_2960 class_29602 = speciesId = formOverride2 == null ? initialSpeciesId : class_2960.method_60654((String)formOverride2.getToSpecies());
        if (!CounterMod.INSTANCE.getConfig().breakStreakOnForm(counterType)) {
            string = "untracked";
        } else {
            FormOverride formOverride3 = formOverride;
            string = formOverride3 == null ? initialFormName : formOverride3.getToForm();
        }
        String formName = string;
        boolean doRecord = false;
        CancelableObservable<RecordEvent.Pre> cancelableObservable = CounterEvents.RECORD_PRE;
        Intrinsics.checkNotNull((Object)speciesId);
        Cancelable event$iv = new RecordEvent.Pre(this, counterType, speciesId, formName, pokemon);
        boolean $i$f$postThen = false;
        EventObservable eventObservable2 = (EventObservable)$this$iv2;
        Cancelable[] cancelableArray = new Cancelable[]{event$iv};
        Cancelable[] events$iv$iv = cancelableArray;
        boolean $i$f$post22 = false;
        this_$iv$iv.emit((Object[])Arrays.copyOf(events$iv$iv, events$iv$iv.length));
        Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            Cancelable element$iv$iv$iv;
            Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            if (it$iv.isCanceled()) {
                Cancelable cancelable = it$iv;
                boolean bl2 = false;
                it = cancelable;
                continue;
            }
            it = (RecordEvent.Pre)it$iv;
            boolean bl3 = false;
            doRecord = true;
        }
        if (!doRecord) {
            return;
        }
        Counter counter = this.getCounter(counterType);
        Map<class_2960, Map<String, Integer>> $this$getOrPut$iv = counter.getCount();
        boolean $i$f$getOrPut2 = false;
        EventObservable<RecordEvent.Post> value$iv2 = $this$getOrPut$iv.get(speciesId);
        if (value$iv2 == null) {
            boolean bl = false;
            answer$iv = (EventObservable<RecordEvent.Post>)new LinkedHashMap();
            $this$getOrPut$iv.put(speciesId, (Map<String, Integer>)answer$iv);
            eventObservable = answer$iv;
        } else {
            eventObservable = value$iv2;
        }
        EventObservable<RecordEvent.Post> speciesRecord = eventObservable;
        speciesRecord.put(formName, ((Number)speciesRecord.getOrDefault(formName, 0)).intValue() + 1);
        boolean streakChanged = false;
        if (counter.getStreak().wouldBreak(speciesId, formName)) {
            if (CounterManager.breakStreak$default(this, counterType, speciesId, formName, pokemon, false, 16, null)) {
                streakChanged = true;
            }
        } else {
            Streak $i$f$getOrPut2 = counter.getStreak();
            int value$iv2 = $i$f$getOrPut2.getCount();
            $i$f$getOrPut2.setCount(value$iv2 + 1);
            streakChanged = true;
        }
        class_3222 class_32222 = PlayerExtensionsKt.getPlayer((UUID)this.getUuid());
        if (class_32222 == null) {
            return;
        }
        class_3222 player = class_32222;
        answer$iv = new Pair[1];
        Object[] $i$f$post22 = new Pair[1];
        Pair[] pairArray = new Pair[1];
        Object v = speciesRecord.get(formName);
        Intrinsics.checkNotNull(v);
        pairArray[0] = TuplesKt.to((Object)formName, v);
        $i$f$post22[0] = TuplesKt.to((Object)speciesId, (Object)MapsKt.mutableMapOf((Pair[])pairArray));
        answer$iv[0] = TuplesKt.to((Object)counterType, (Object)new Counter(MapsKt.mutableMapOf((Pair[])$i$f$post22), streakChanged ? counter.getStreak() : new Streak(Streak.Companion.getIGNORED_SPECIES(), null, 0, 6, null)));
        ClientCounterManager patchData = new ClientCounterManager(MapsKt.mutableMapOf((Pair[])answer$iv), CounterMod.INSTANCE.getConfig().getBroadcast());
        CobblemonNetwork.INSTANCE.sendPacket(player, (NetworkPacket)new SetClientPlayerDataPacket(PlayerInstancedDataStores.INSTANCE.getCOUNTER(), (ClientInstancedPlayerData)patchData, true));
        answer$iv = CounterEvents.RECORD_POST;
        $i$f$post22 = new RecordEvent.Post[]{new RecordEvent.Post(this, counterType, speciesId, formName, pokemon)};
        boolean $i$f$post = false;
        $this$iv.emit((Object[])Arrays.copyOf(events$iv, ((void)events$iv).length));
        void $this$forEach$iv$iv = events$iv;
        boolean $i$f$forEach2 = false;
        for (void element$iv$iv : $this$forEach$iv$iv) {
            it = element$iv$iv;
            boolean bl = false;
        }
    }

    public static /* synthetic */ void record$default(CounterManager counterManager, class_2960 class_29602, String string, CounterType counterType, Pokemon pokemon, int n, Object object) {
        if ((n & 8) != 0) {
            pokemon = null;
        }
        counterManager.record(class_29602, string, counterType, pokemon);
    }

    public final void setStreakScore(@NotNull CounterType counterType, @NotNull class_2960 speciesId, @NotNull String formName, int score) {
        Intrinsics.checkNotNullParameter((Object)counterType, (String)"counterType");
        Intrinsics.checkNotNullParameter((Object)speciesId, (String)"speciesId");
        Intrinsics.checkNotNullParameter((Object)formName, (String)"formName");
        class_3222 class_32222 = PlayerExtensionsKt.getPlayer((UUID)this.getUuid());
        if (class_32222 == null) {
            return;
        }
        class_3222 player = class_32222;
        Counter counter = this.getCounter(counterType);
        counter.setStreak(new Streak(speciesId, formName, score));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)counterType, (Object)new Counter(new LinkedHashMap(), counter.getStreak()))};
        ClientCounterManager patchData = new ClientCounterManager(MapsKt.mutableMapOf((Pair[])pairArray), CounterMod.INSTANCE.getConfig().getBroadcast());
        CobblemonNetwork.INSTANCE.sendPacket(player, (NetworkPacket)new SetClientPlayerDataPacket(PlayerInstancedDataStores.INSTANCE.getCOUNTER(), (ClientInstancedPlayerData)patchData, true));
    }

    public final void setCountScore(@NotNull CounterType counterType, @NotNull class_2960 speciesId, @NotNull String formName, int score) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)counterType, (String)"counterType");
        Intrinsics.checkNotNullParameter((Object)speciesId, (String)"speciesId");
        Intrinsics.checkNotNullParameter((Object)formName, (String)"formName");
        class_3222 class_32222 = PlayerExtensionsKt.getPlayer((UUID)this.getUuid());
        if (class_32222 == null) {
            return;
        }
        class_3222 player = class_32222;
        Counter counter = this.getCounter(counterType);
        Map<class_2960, Map<String, Integer>> $this$getOrPut$iv = counter.getCount();
        boolean $i$f$getOrPut = false;
        Map value$iv = $this$getOrPut$iv.get(speciesId);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(speciesId, answer$iv);
            map = answer$iv;
        } else {
            map = value$iv;
        }
        Map speciesRecord = map;
        Pair[] pairArray = Integer.valueOf(score);
        speciesRecord.put((String)formName, (Integer)pairArray);
        pairArray = new Pair[1];
        Pair[] pairArray2 = new Pair[1];
        Pair[] pairArray3 = new Pair[1];
        Object v = speciesRecord.get(formName);
        Intrinsics.checkNotNull(v);
        pairArray3[0] = TuplesKt.to((Object)formName, v);
        pairArray2[0] = TuplesKt.to((Object)speciesId, (Object)MapsKt.mutableMapOf((Pair[])pairArray3));
        pairArray[0] = TuplesKt.to((Object)counterType, (Object)new Counter(MapsKt.mutableMapOf((Pair[])pairArray2), new Streak(Streak.Companion.getIGNORED_SPECIES(), null, 0, 6, null)));
        ClientCounterManager patchData = new ClientCounterManager(MapsKt.mutableMapOf((Pair[])pairArray), CounterMod.INSTANCE.getConfig().getBroadcast());
        CobblemonNetwork.INSTANCE.sendPacket(player, (NetworkPacket)new SetClientPlayerDataPacket(PlayerInstancedDataStores.INSTANCE.getCOUNTER(), (ClientInstancedPlayerData)patchData, true));
    }

    @NotNull
    public ClientCounterManager toClientData() {
        Map cloned = new LinkedHashMap();
        Map<CounterType, Counter> $this$forEach$iv = this.getCounters();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<CounterType, Counter>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<CounterType, Counter> element$iv;
            Map.Entry<CounterType, Counter> entry = element$iv = iterator.next();
            boolean bl = false;
            CounterType type = entry.getKey();
            Counter counter = entry.getValue();
            cloned.put(type, counter.clone());
        }
        return new ClientCounterManager(cloned, SetsKt.emptySet());
    }

    public final void record(@NotNull Pokemon pokemon, @NotNull CounterType counterType) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)counterType, (String)"counterType");
        this.record(pokemon.getSpecies().getResourceIdentifier(), pokemon.getForm().getName(), counterType, pokemon);
    }

    public void initialize() {
        InstancedPlayerData.DefaultImpls.initialize((InstancedPlayerData)this);
    }

    private static final String CODEC$lambda$12$lambda$6(CounterManager it) {
        return it.getUuid().toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final Map CODEC$lambda$12$lambda$9(CounterManager manager) {
        String key;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = manager.getCounters().keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CounterType counterType = (CounterType)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((CounterType)((Object)key)).getType());
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            key = (String)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            Map<CounterType, Counter> map = manager.getCounters();
            Intrinsics.checkNotNull((Object)key);
            Counter counter = map.get(CounterTypeRegistry.INSTANCE.findByType(key));
            Intrinsics.checkNotNull((Object)counter);
            Counter counter2 = counter.clone();
            object.put(t, counter2);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final CounterManager CODEC$lambda$12$lambda$11(String uuid, Map counters) {
        void $this$associateWith$iv;
        UUID uUID = UUID.fromString(uuid);
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        Iterable iterable = CounterTypeRegistry.INSTANCE.counterTypes();
        UUID uUID2 = uUID;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void counterType;
            CounterType counterType2 = (CounterType)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Counter counter = (Counter)counters.get(counterType.getType());
            if (counter == null || (counter = counter.clone()) == null) {
                counter = new Counter(null, null, 3, null);
            }
            Counter counter2 = counter;
            map.put(t, counter2);
        }
        Map map = result$iv;
        UUID uUID3 = uUID2;
        return new CounterManager(uUID3, map);
    }

    private static final App CODEC$lambda$12(RecordCodecBuilder.Instance instance) {
        return instance.group((App)PrimitiveCodec.STRING.fieldOf("uuid").forGetter(CounterManager::CODEC$lambda$12$lambda$6), (App)Codec.unboundedMap((Codec)((Codec)PrimitiveCodec.STRING), Counter.Companion.getCODEC()).fieldOf("counters").forGetter(CounterManager::CODEC$lambda$12$lambda$9)).apply((Applicative)instance, CounterManager::CODEC$lambda$12$lambda$11);
    }

    static {
        Codec codec = RecordCodecBuilder.create(CounterManager::CODEC$lambda$12);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lus/timinc/mc/cobblemon/counter/api/CounterManager$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/Codec;", "Lus/timinc/mc/cobblemon/counter/api/CounterManager;", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "cobblemon-counter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<CounterManager> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

