/*
 * Decompiled with CFR 0.152.
 */
package com.raspix.fabric.cobble_contests.menus.screens;

import com.cobblemon.mod.common.api.berry.Flavor;
import com.cobblemon.mod.common.api.gui.MultiLineLabelK;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.gui.trade.ModelWidget;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.client.storage.ClientParty;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.mojang.blaze3d.systems.RenderSystem;
import com.raspix.fabric.cobble_contests.CobbleContestsMoves;
import com.raspix.fabric.cobble_contests.events.ContestMoves;
import com.raspix.fabric.cobble_contests.menus.PlayerContestInfoMenu;
import com.raspix.fabric.cobble_contests.menus.widgets.FixedImageButton;
import com.raspix.fabric.cobble_contests.menus.widgets.WalletPokemonSlotButton;
import com.raspix.fabric.cobble_contests.network.SBWalletScreenParty;
import com.raspix.fabric.cobble_contests.pokemon.CVs;
import com.raspix.fabric.cobble_contests.pokemon.Ribbons;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_8710;
import net.minecraft.class_9801;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class PlayerConditionCardScreen
extends class_465<PlayerContestInfoMenu> {
    private static final int BASE_WIDTH = 349;
    private static final int BASE_HEIGHT = 205;
    private static final int MAX_STATS = 255;
    private static int PORTRAIT_DIAMETER = 25;
    private int pokemonIndex;
    private int pageIndex;
    private List<CVs> cvList;
    private List<Ribbons> ribbonList;
    private List<class_4185> buttons;
    private ModelWidget modelWidget;
    private class_2960 baseResource = MiscUtilsKt.cobblemonResource((String)"textures/gui/summary/summary_base.png");
    private class_2960 portraitBackgroundResource = MiscUtilsKt.cobblemonResource((String)"textures/gui/summary/portrait_background.png");
    private class_2960 typeSpacerResource = MiscUtilsKt.cobblemonResource((String)"textures/gui/summary/type_spacer.png");
    private class_2960 typeSpacerDoubleResource = MiscUtilsKt.cobblemonResource((String)"textures/gui/summary/type_spacer_double.png");
    private class_2960 sideSpacerResource = MiscUtilsKt.cobblemonResource((String)"textures/gui/summary/summary_side_spacer.png");
    private class_2960 evolveButtonResource = MiscUtilsKt.cobblemonResource((String)"textures/gui/summary/summary_evolve_button.png");
    class_2960 iconShinyResource = MiscUtilsKt.cobblemonResource((String)"textures/gui/summary/icon_shiny.png");
    private class_2960 slotResource = MiscUtilsKt.cobblemonResource((String)"textures/gui/summary/summary_party_slot.png");
    private class_2960 slotFaintedResource = MiscUtilsKt.cobblemonResource((String)"textures/gui/summary/summary_party_slot_fainted.png");
    private class_2960 slotEmptyResource = MiscUtilsKt.cobblemonResource((String)"textures/gui/summary/summary_party_slot_empty.png");
    class_2960 genderIconMale = MiscUtilsKt.cobblemonResource((String)"textures/gui/party/party_gender_male.png");
    class_2960 genderIconFemale = MiscUtilsKt.cobblemonResource((String)"textures/gui/party/party_gender_female.png");
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"cobble_contests", (String)"textures/gui/contest_profile.png");
    private static final class_2960 MOVE_PANELS = class_2960.method_60655((String)"cobble_contests", (String)"textures/gui/move_panels.png");
    private static final class_2960 RANK_RIBBONS = class_2960.method_60655((String)"cobble_contests", (String)"textures/gui/badges.png");
    private class_1661 playerInv;
    private PlayerPartyStore playerPartyStore;
    private ClientParty clientParty;
    private PlayerContestInfoMenu contestInfoMenu;

    public PlayerConditionCardScreen(PlayerContestInfoMenu containerID, class_1661 playerInv, class_2561 title) {
        super((class_1703)containerID, playerInv, title);
        this.field_2776 = 0;
        this.field_2800 = 0;
        this.field_2792 = 291;
        this.field_2779 = 194;
        this.playerInv = playerInv;
        this.contestInfoMenu = containerID;
        ClientPlayNetworking.send((class_8710)new SBWalletScreenParty(playerInv.field_7546.method_5667()));
    }

    protected void method_25426() {
        super.method_25426();
        this.buttons = new ArrayList<class_4185>();
        this.buttons.add((class_4185)this.method_37063((class_364)new FixedImageButton(this.field_2776 + 12, this.field_2800 - 13, 17, 14, 292, 0, 16, TEXTURE, 1000, 750, btn -> this.setPageIndex(0))));
        this.buttons.add((class_4185)this.method_37063((class_364)new FixedImageButton(this.field_2776 + 30, this.field_2800 - 13, 17, 14, 309, 0, 16, TEXTURE, 1000, 750, btn -> this.setPageIndex(1))));
        this.buttons.add((class_4185)this.method_37063((class_364)new FixedImageButton(this.field_2776 + 48, this.field_2800 - 13, 17, 14, 326, 0, 16, TEXTURE, 1000, 750, btn -> this.setPageIndex(2))));
        this.pokemonIndex = 0;
        this.pageIndex = 0;
        this.renderParty();
        this.setSelectedModel();
    }

    private void setSelectedModel() {
        if (this.clientParty != null && this.clientParty.getSlots().size() > 0 && this.clientParty.get(this.pokemonIndex) != null) {
            Pokemon poke = this.clientParty.get(this.pokemonIndex);
            this.modelWidget = new ModelWidget(this.field_2776 + 6 + 15, this.field_2800 + 27 - 5, 66, 66, poke.asRenderablePokemon(), 2.0f, 325.0f, -10.0);
        } else {
            this.modelWidget = null;
        }
    }

    private void renderParty() {
        int startingX = this.field_2776 - 42;
        int xOffset = 0;
        int startingY = this.field_2800 + 10;
        int yOffset = 30;
        this.clientParty = CobblemonClient.INSTANCE.getStorage().getMyParty();
        List partyPoke = this.clientParty.getSlots();
        for (int i = 0; i < 6; ++i) {
            Pokemon poke = (Pokemon)partyPoke.get(i);
            int finalI = i;
            this.buttons.add((class_4185)this.method_37063((class_364)new WalletPokemonSlotButton(startingX + i * xOffset, startingY + i * yOffset, 46, 27, 0, 0, 27, this.getSlotTexture(poke), 46, 54, btn -> this.setPokemonPage(finalI), poke)));
        }
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int xMousePos, int yMousePos) {
        if (this.pageIndex == 1) {
            guiGraphics.method_25290(TEXTURE, this.field_2776, this.field_2800, 0.0f, 194.0f, this.field_2792, this.field_2779, 1000, 750);
        } else if (this.pageIndex == 0) {
            guiGraphics.method_25290(TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 1000, 750);
        } else {
            guiGraphics.method_25290(TEXTURE, this.field_2776, this.field_2800, 0.0f, 388.0f, this.field_2792, this.field_2779, 1000, 750);
        }
    }

    private class_2960 getSlotTexture(Pokemon pokemon) {
        if (pokemon != null) {
            if (pokemon.isFainted()) {
                return this.slotFaintedResource;
            }
            return this.slotResource;
        }
        return this.slotEmptyResource;
    }

    public void method_25394(class_332 guiGraphics, int xMousePos, int yMousePos, float partialTick) {
        super.method_25394(guiGraphics, xMousePos, yMousePos, partialTick);
        this.method_2380(guiGraphics, xMousePos, yMousePos);
        if (this.pageIndex == 0) {
            if (this.clientParty != null && this.clientParty.getSlots().size() > 0 && this.clientParty.get(this.pokemonIndex) != null && this.cvList != null) {
                poke = this.clientParty.get(this.pokemonIndex);
                assert (poke != null);
                this.drawStatHexagon(new Vector3f(0.1764706f, 0.92941177f, 0.3764706f), this.cvList.get(this.pokemonIndex), guiGraphics);
                this.writeFlavors(guiGraphics, poke);
                this.drawFriendshipHeart(guiGraphics, poke);
            }
        } else if (this.pageIndex == 1) {
            if (this.clientParty != null && this.clientParty.getSlots().size() > 0 && this.clientParty.get(this.pokemonIndex) != null) {
                poke = this.clientParty.get(this.pokemonIndex);
                this.drawContestStats(guiGraphics, poke);
            }
        } else if (this.pageIndex == 2 && this.clientParty != null && this.clientParty.getSlots().size() > 0 && this.clientParty.get(this.pokemonIndex) != null) {
            this.drawCoolContestRibbons(guiGraphics);
            this.drawBeautyContestRibbons(guiGraphics);
            this.drawCuteContestRibbons(guiGraphics);
            this.drawSmartContestRibbons(guiGraphics);
            this.drawToughContestRibbons(guiGraphics);
        }
        if (this.modelWidget != null) {
            this.modelWidget.field_22764 = true;
            this.modelWidget.method_25394(guiGraphics, xMousePos, yMousePos, partialTick);
        }
        class_4587 poses = guiGraphics.method_51448();
    }

    private void drawFriendshipHeart(class_332 guiGraphics, Pokemon poke) {
        int friendship = poke.getFriendship();
        int heartPixels = (int)((float)friendship / 255.0f * 33.0f);
        guiGraphics.method_25290(TEXTURE, this.field_2776 + 33, this.field_2800 + 95 + 33 - heartPixels, 293.0f, (float)(67 + (33 - heartPixels)), 37, heartPixels + 1, 1000, 750);
    }

    public void drawCoolContestRibbons(class_332 guiGraphics) {
        int yPos = this.field_2800 + 97;
        int xPos = this.field_2776 + 19;
        if (this.ribbonList != null && this.ribbonList.size() == 6) {
            if (this.ribbonList.get(this.pokemonIndex).getCoolRanked(0)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos, yPos, 0.0f, 0.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getCoolRanked(1)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 11, yPos, 16.0f, 0.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getCoolRanked(2)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 27, yPos, 32.0f, 0.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getCoolRanked(3)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 45, yPos, 48.0f, 0.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getCoolRanked(4)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 63, yPos, 64.0f, 0.0f, 16, 16, 80, 80);
            }
        }
    }

    public void drawBeautyContestRibbons(class_332 guiGraphics) {
        int yPos = this.field_2800 + 97 + 18;
        int xPos = this.field_2776 + 19;
        if (this.ribbonList != null && this.ribbonList.size() == 6) {
            if (this.ribbonList.get(this.pokemonIndex).getBeautyRanked(0)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos, yPos, 0.0f, 16.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getBeautyRanked(1)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 11, yPos, 16.0f, 16.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getBeautyRanked(2)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 27, yPos, 32.0f, 16.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getBeautyRanked(3)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 45, yPos, 48.0f, 16.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getBeautyRanked(4)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 63, yPos, 64.0f, 16.0f, 16, 16, 80, 80);
            }
        }
    }

    public void drawCuteContestRibbons(class_332 guiGraphics) {
        int yPos = this.field_2800 + 97 + 36;
        int xPos = this.field_2776 + 19;
        if (this.ribbonList != null && this.ribbonList.size() == 6) {
            if (this.ribbonList.get(this.pokemonIndex).getCuteRanked(0)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos, yPos, 0.0f, 32.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getCuteRanked(1)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 11, yPos, 16.0f, 32.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getCuteRanked(2)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 27, yPos, 32.0f, 32.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getCuteRanked(3)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 45, yPos, 48.0f, 32.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getCuteRanked(4)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 63, yPos, 64.0f, 32.0f, 16, 16, 80, 80);
            }
        }
    }

    public void drawSmartContestRibbons(class_332 guiGraphics) {
        int yPos = this.field_2800 + 97 + 54;
        int xPos = this.field_2776 + 19;
        if (this.ribbonList != null && this.ribbonList.size() == 6) {
            if (this.ribbonList.get(this.pokemonIndex).getSmartRanked(0)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos, yPos, 0.0f, 48.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getSmartRanked(1)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 11, yPos, 16.0f, 48.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getSmartRanked(2)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 27, yPos, 32.0f, 48.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getSmartRanked(3)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 45, yPos, 48.0f, 48.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getSmartRanked(4)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 63, yPos, 64.0f, 48.0f, 16, 16, 80, 80);
            }
        }
    }

    public void drawToughContestRibbons(class_332 guiGraphics) {
        int yPos = this.field_2800 + 97 + 72;
        int xPos = this.field_2776 + 19;
        if (this.ribbonList != null && this.ribbonList.size() == 6) {
            if (this.ribbonList.get(this.pokemonIndex).getToughRanked(0)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos, yPos, 0.0f, 64.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getToughRanked(1)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 11, yPos, 16.0f, 64.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getToughRanked(2)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 27, yPos, 32.0f, 64.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getToughRanked(3)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 45, yPos, 48.0f, 64.0f, 16, 16, 80, 80);
            }
            if (this.ribbonList.get(this.pokemonIndex).getToughRanked(4)) {
                guiGraphics.method_25290(RANK_RIBBONS, xPos + 63, yPos, 64.0f, 64.0f, 16, 16, 80, 80);
            }
        }
    }

    public void drawContestStats(class_332 guiGraphics, Pokemon pokemon) {
        List moves = pokemon.getMoveSet().getMoves();
        int xPos = this.field_2776 + 95;
        int yPos = this.field_2800 + 20;
        boolean xInc = false;
        int yInc = 40;
        for (int i = 0; i < 4; ++i) {
            if (moves.size() > i && moves.get(i) != null) {
                Move move = (Move)moves.get(i);
                this.drawMovePanel(guiGraphics, move, xPos, yPos + i * yInc);
                continue;
            }
            guiGraphics.method_25290(MOVE_PANELS, xPos, yPos + i * yInc, 0.0f, 0.0f, 186, 32, 291, 400);
        }
    }

    private void drawMovePanel(class_332 guiGraphics, Move move, int xPos, int yPos) {
        String moveName = move.getName();
        int panelOffset = 0;
        int appeal = 1;
        class_4587 poses = guiGraphics.method_51448();
        String description = "placeholder";
        Map<String, ContestMoves.MoveData> contestMoves = CobbleContestsMoves.INSTANCE.allMoves;
        if (contestMoves.containsKey(moveName)) {
            String type;
            ContestMoves.MoveData data = contestMoves.get(moveName);
            switch (type = data.getType()) {
                case "Cool": {
                    panelOffset = 32;
                    break;
                }
                case "Beauty": {
                    panelOffset = 64;
                    break;
                }
                case "Cute": {
                    panelOffset = 96;
                    break;
                }
                case "Smart": {
                    panelOffset = 128;
                    break;
                }
                case "Tough": {
                    panelOffset = 160;
                    break;
                }
            }
            appeal = data.getAppeal();
        }
        guiGraphics.method_25290(MOVE_PANELS, xPos, yPos, 0.0f, (float)panelOffset, 186, 32, 291, 400);
        RenderHelperKt.drawScaledText((class_332)guiGraphics, null, (class_5250)LocalizationUtilsKt.lang((String)("move." + moveName), (Object[])new Object[0]), (Number)(xPos + 37), (Number)(yPos + 5), (float)1.0f, (Number)Float.valueOf(1.0f), (int)Integer.MAX_VALUE, (int)0xFFFFFF, (boolean)true, (boolean)true, null, null);
        guiGraphics.method_25290(MOVE_PANELS, xPos + 75 - (1 + appeal * 8), yPos + 21, 1.0f, 193.0f, 1 + appeal * 8, 9, 291, 400);
        poses.method_22903();
        poses.method_22905(0.5f, 0.5f, 1.0f);
        MultiLineLabelK.Companion.create((class_2561)class_2561.method_43471((String)("cobble_contests.move_info." + description)), (Number)Float.valueOf(200.0f), (Number)5).renderLeftAligned(guiGraphics, (Number)Float.valueOf((float)(xPos + 80) / 0.5f), (Number)Float.valueOf((float)(yPos + 4) / 0.5f), (Number)0, (Number)11, 0xFFFFFF, 1.0f, true);
        poses.method_22909();
    }

    private void drawStatHexagon(Vector3f colour, CVs cvs, class_332 guiGraphics) {
        int maximum = 50;
        boolean minimum = true;
        int sheenStars = cvs.getSheenStars();
        float upperHexX = (float)(Math.sin(Math.toRadians(72.0)) * (double)maximum);
        float upperHexY = (float)(Math.cos(Math.toRadians(72.0)) * (double)maximum);
        float lowerHexX = (float)(Math.sin(Math.toRadians(36.0)) * (double)maximum);
        float lowerHexY = (float)(Math.cos(Math.toRadians(36.0)) * (double)maximum);
        float hexCenterX = (float)this.field_2776 + (float)this.field_2792 / 2.0f + 47.0f;
        float hexCenterY = (float)this.field_2800 + (float)this.field_2779 / 2.0f - 13.0f;
        float coolRatio = Math.max(0.0f, Math.min(1.0f, (float)cvs.getCool() / 255.0f)) + 0.05f;
        float beautyRatio = Math.max(0.0f, Math.min(1.0f, (float)cvs.getBeauty() / 255.0f)) + 0.05f;
        float cuteRatio = Math.max(0.0f, Math.min(1.0f, (float)cvs.getCute() / 255.0f)) + 0.05f;
        float smartRatio = Math.max(0.0f, Math.min(1.0f, (float)cvs.getSmart() / 255.0f)) + 0.05f;
        float toughRatio = Math.max(0.0f, Math.min(1.0f, (float)cvs.getTough() / 255.0f)) + 0.05f;
        Vector2f centerPoint = new Vector2f(hexCenterX, hexCenterY);
        Vector2f coolPoint = new Vector2f(hexCenterX, hexCenterY - (float)maximum * coolRatio);
        Vector2f beautyPoint = new Vector2f(hexCenterX + upperHexX * beautyRatio, hexCenterY - upperHexY * beautyRatio);
        Vector2f cutePoint = new Vector2f(hexCenterX + lowerHexX * cuteRatio, hexCenterY + lowerHexY * cuteRatio);
        Vector2f smartPoint = new Vector2f(hexCenterX - lowerHexX * smartRatio, hexCenterY + lowerHexY * smartRatio);
        Vector2f toughPoint = new Vector2f(hexCenterX - upperHexX * toughRatio, hexCenterY - upperHexY * toughRatio);
        this.drawTriangle(colour, coolPoint, centerPoint, beautyPoint);
        this.drawTriangle(colour, beautyPoint, centerPoint, cutePoint);
        this.drawTriangle(colour, cutePoint, centerPoint, smartPoint);
        this.drawTriangle(colour, smartPoint, centerPoint, toughPoint);
        this.drawTriangle(colour, toughPoint, centerPoint, coolPoint);
        guiGraphics.method_25290(TEXTURE, this.field_2776 + 163, this.field_2800 + 164, 292.0f, 51.0f, 1 + 8 * sheenStars, 14, 1000, 750);
    }

    private void drawTriangle(Vector3f colour, Vector2f v1, Vector2f v2, Vector2f v3) {
        RenderSystem.setShaderTexture((int)0, (class_2960)CobblemonResources.INSTANCE.getWHITE());
        RenderSystem.setShaderColor((float)colour.x, (float)colour.y, (float)colour.z, (float)0.6f);
        RenderSystem.enableBlend();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27379, class_290.field_1592);
        bufferBuilder.method_22912(v1.x, v1.y, 10.0f);
        bufferBuilder.method_22912(v2.x, v2.y, 10.0f);
        bufferBuilder.method_22912(v3.x, v3.y, 10.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void writeFlavors(class_332 guiGraphics, Pokemon pokemon) {
        Flavor fav = pokemon.getNature().getFavoriteFlavor();
        Flavor dis = pokemon.getNature().getDislikedFlavor();
        RenderHelperKt.drawScaledText((class_332)guiGraphics, (class_5481)class_2561.method_43470((String)("Favorite: " + (fav != null ? fav.name() : "none"))).method_30937(), (Number)(this.field_2776 + 15), (Number)(this.field_2800 + 135), (float)1.0f, (float)1.0f, (Number)Float.valueOf(1.0f), (int)0xFFFFFF, (boolean)false, (boolean)false);
        RenderHelperKt.drawScaledText((class_332)guiGraphics, (class_5481)class_2561.method_43470((String)("Disliked: " + (dis != null ? dis.name() : "none"))).method_30937(), (Number)(this.field_2776 + 15), (Number)(this.field_2800 + 145), (float)1.0f, (float)1.0f, (Number)Float.valueOf(1.0f), (int)0xFFFFFF, (boolean)false, (boolean)false);
    }

    protected void method_2388(class_332 arg, int i, int j) {
    }

    private void setPokemonPage(int index) {
        this.pokemonIndex = index;
        this.setSelectedModel();
    }

    private void setPageIndex(int index) {
        this.pageIndex = index;
    }

    public void setParty(PlayerPartyStore pps) {
        this.playerPartyStore = pps;
    }

    public void setCVs(class_2487 tag) {
        this.cvList = new ArrayList<CVs>();
        this.cvList.add(CVs.getFromTag(tag.method_10562("poke0")));
        this.cvList.add(CVs.getFromTag(tag.method_10562("poke1")));
        this.cvList.add(CVs.getFromTag(tag.method_10562("poke2")));
        this.cvList.add(CVs.getFromTag(tag.method_10562("poke3")));
        this.cvList.add(CVs.getFromTag(tag.method_10562("poke4")));
        this.cvList.add(CVs.getFromTag(tag.method_10562("poke5")));
    }

    public void setRibbons(class_2487 tag) {
        this.ribbonList = new ArrayList<Ribbons>();
        this.ribbonList.add(Ribbons.getFromTag(tag.method_10562("poke0ribbons")));
        this.ribbonList.add(Ribbons.getFromTag(tag.method_10562("poke1ribbons")));
        this.ribbonList.add(Ribbons.getFromTag(tag.method_10562("poke2ribbons")));
        this.ribbonList.add(Ribbons.getFromTag(tag.method_10562("poke3ribbons")));
        this.ribbonList.add(Ribbons.getFromTag(tag.method_10562("poke4ribbons")));
        this.ribbonList.add(Ribbons.getFromTag(tag.method_10562("poke5ribbons")));
    }
}

