/*
 * Decompiled with CFR 0.152.
 */
package com.raspix.fabric.cobble_contests.items;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.advancement.criterion.PokemonInteractContext;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.berry.Flavor;
import com.cobblemon.mod.common.api.callback.PartySelectCallbacks;
import com.cobblemon.mod.common.api.item.PokemonSelectingItem;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.CobblemonItem;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.raspix.fabric.cobble_contests.ContestConfig;
import com.raspix.fabric.cobble_contests.items.ItemInit;
import com.raspix.fabric.cobble_contests.pokemon.CVs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PoffinItem
extends CobblemonItem
implements PokemonSelectingItem {
    public static final String cvsKey = "CVs";
    private final String coolKey = "cool";
    private int mainFlavor = -1;
    private int secFlavor = -1;

    public PoffinItem(class_1792.class_1793 properties) {
        super(properties);
        this.mainFlavor = -1;
        this.secFlavor = -1;
    }

    public PoffinItem(class_1792.class_1793 properties, int mainFlavor, int secFlavor) {
        super(properties);
        this.mainFlavor = mainFlavor;
        this.secFlavor = secFlavor;
    }

    private void setBasicFlavors() {
    }

    @Nullable
    public BagItem getBagItem() {
        return new BagItem(this){

            @NotNull
            public class_1792 getReturnItem() {
                return ItemInit.DRY_POFFIN;
            }

            @NotNull
            public String getItemName() {
                return "item.cobblemon.poffin";
            }

            public boolean canUse(@NotNull PokemonBattle pokemonBattle, @NotNull BattlePokemon battlePokemon) {
                return true;
            }

            @NotNull
            public String getShowdownInput(@NotNull BattleActor battleActor, @NotNull BattlePokemon battlePokemon, @Nullable String s) {
                return null;
            }

            public boolean canStillUse(@NotNull class_3222 serverPlayer, @NotNull PokemonBattle pokemonBattle, @NotNull BattleActor battleActor, @NotNull BattlePokemon battlePokemon, @NotNull class_1799 itemStack) {
                return itemStack.method_7947() > 0 && this.canUse(pokemonBattle, battlePokemon) && battleActor.canFitForcedAction();
            }
        };
    }

    public void applyToBattlePokemon(@NotNull class_3222 serverPlayer, @NotNull class_1799 itemStack, @NotNull BattlePokemon battlePokemon) {
    }

    @Nullable
    public class_1271<class_1799> applyToPokemon(@NotNull class_3222 serverPlayer, @NotNull class_1799 itemStack, @NotNull Pokemon pokemon) {
        class_2487 tag = pokemon.getPersistentData();
        CVs cvs = tag.method_10562(cvsKey) == null ? CVs.createNewCVs() : CVs.getFromTag(tag.method_10562(cvsKey));
        if (cvs.getSheen() < 255 || itemStack.method_7909() == ItemInit.FOUL_POFFIN) {
            int[] flavors = new int[]{0, 0, 0, 0, 0, 0};
            if (itemStack.method_57826(class_9334.field_49628) && ((class_9279)itemStack.method_57824(class_9334.field_49628)).method_57450("Flavors")) {
                class_2487 poffinTag = ((class_9279)itemStack.method_57824(class_9334.field_49628)).method_57461().method_10562("Flavors");
                try {
                    flavors[0] = poffinTag.method_10550("spicy");
                    flavors[1] = poffinTag.method_10550("dry");
                    flavors[2] = poffinTag.method_10550("sweet");
                    flavors[3] = poffinTag.method_10550("bitter");
                    flavors[4] = poffinTag.method_10550("sour");
                    flavors[5] = poffinTag.method_10550("sheen");
                }
                catch (ClassCastException classCastException) {}
            } else {
                flavors = this.getBaseFlavors();
            }
            for (class_6862 class_68622 : itemStack.method_40133().toList()) {
            }
            Nature nature = pokemon.getNature();
            int disliked = this.getIndexFromFlavor(nature.getDislikedFlavor());
            int liked = this.getIndexFromFlavor(nature.getFavoriteFlavor());
            float valMultiplier = 1.0f;
            if (this.mainFlavor == liked && this.mainFlavor >= 0 && this.mainFlavor != this.secFlavor) {
                valMultiplier = 1.1f;
                pokemon.incrementFriendship(ContestConfig.LIKED_POFFIN_FRIEND_INCREMENT, true);
            } else if (this.mainFlavor == disliked && this.mainFlavor >= 0 && this.mainFlavor != this.secFlavor) {
                valMultiplier = 0.9f;
                pokemon.decrementFriendship(ContestConfig.DISLIKED_POFFIN_FRIEND_DECREMENT, true);
            } else if (this.mainFlavor == -1 && this.secFlavor == -1) {
                pokemon.decrementFriendship(ContestConfig.FOUL_POFFIN_FRIEND_DECREMENT, true);
            } else {
                pokemon.incrementFriendship(ContestConfig.NEUTRAL_POFFIN_FRIEND_INCREMENT, true);
            }
            for (int i = 0; i < 5; ++i) {
                int valBonus = (int)((float)flavors[i] * valMultiplier);
                cvs.increaseCVFromFlavorIndex(i, valBonus);
            }
            cvs.increaseSheen(flavors[5]);
            HashMap<String, class_2487> myData = new HashMap<String, class_2487>(){};
            myData.put(cvsKey, cvs.saveToNBT());
            this.saveCVs(pokemon, (Map<String, class_2487>)myData);
            if (!serverPlayer.method_7337()) {
                itemStack.method_7934(1);
            }
            return class_1271.method_22427((Object)itemStack);
        }
        serverPlayer.method_7353((class_2561)class_2561.method_43470((String)(pokemon.getDisplayName().getString() + " already has max sheen and can not eat any more")).method_27692(class_124.field_1076), false);
        return class_1271.method_22431((Object)itemStack);
    }

    private void saveMyData(Pokemon pokemon, Map<String, Integer> myData) {
        class_2487 tag = pokemon.getPersistentData();
        myData.forEach((key, value) -> tag.method_10566(key, (class_2520)class_2497.method_23247((int)value)));
        if (pokemon.getChangeObservable() instanceof SimpleObservable) {
            ((SimpleObservable)pokemon.getChangeObservable()).emit((Object[])new Pokemon[]{pokemon});
        } else {
            System.out.println("error, not simple observable (PoffinItem)");
        }
    }

    private void saveCVs(Pokemon pokemon, Map<String, class_2487> myData) {
        class_2487 tag = pokemon.getPersistentData();
        myData.forEach((key, value) -> tag.method_10566(key, (class_2520)value));
        if (pokemon.getChangeObservable() instanceof SimpleObservable) {
            ((SimpleObservable)pokemon.getChangeObservable()).emit((Object[])new Pokemon[]{pokemon});
        } else {
            System.out.println("error, not simple observable (PoffinItem)");
        }
    }

    private void getMyData(Pokemon pokemon, String key) {
    }

    private int getIndexFromFlavor(Flavor flavor) {
        int idx = -1;
        if (flavor != null) {
            switch (flavor) {
                case SPICY: {
                    idx = 0;
                    break;
                }
                case DRY: {
                    idx = 1;
                    break;
                }
                case SWEET: {
                    idx = 2;
                    break;
                }
                case BITTER: {
                    idx = 3;
                    break;
                }
                case SOUR: {
                    idx = 4;
                    break;
                }
                default: {
                    System.out.println("Unknown flavor.");
                }
            }
        }
        return idx;
    }

    public boolean canUseOnBattlePokemon(@NotNull BattlePokemon battlePokemon) {
        return false;
    }

    public boolean canUseOnPokemon(@NotNull Pokemon pokemon) {
        return true;
    }

    @NotNull
    public class_1271<class_1799> interactGeneralBattle(@NotNull class_3222 serverPlayer, @NotNull class_1799 itemStack, @NotNull BattleActor battleActor) {
        return null;
    }

    @NotNull
    public class_1271<class_1799> interactWithSpecificBattle(@NotNull class_3222 serverPlayer, @NotNull class_1799 itemStack, @NotNull BattlePokemon battlePokemon) {
        return null;
    }

    @NotNull
    public class_1271<class_1799> use(@NotNull class_3222 serverPlayer, @NotNull class_1799 itemStack) {
        class_1271<class_1799> result = this.interactGeneral(serverPlayer, itemStack);
        return result;
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_8045().method_8608()) {
            return super.method_7884(context);
        }
        class_3222 player = (class_3222)context.method_8036();
        class_1799 itemStack = context.method_8041();
        return this.interactGeneral(player, itemStack).method_5467();
    }

    public class_1271<class_1799> method_7836(class_1937 arg, class_1657 player, class_1268 hand) {
        if (player instanceof class_3222) {
            this.use((class_3222)player, player.method_5998(hand));
        }
        return class_1271.method_22427((Object)player.method_5998(hand));
    }

    @NotNull
    public class_1271<class_1799> interactGeneral(@NotNull class_3222 serverPlayer, @NotNull class_1799 itemStack) {
        List pokeList1 = Cobblemon.INSTANCE.getStorage().getParty(serverPlayer).toGappyList();
        if (pokeList1.isEmpty()) {
            return class_1271.method_22431((Object)itemStack);
        }
        ArrayList<Pokemon> pokeList = new ArrayList<Pokemon>();
        for (Pokemon poke : pokeList1) {
            if (poke == null) continue;
            pokeList.add(poke);
        }
        PartySelectCallbacks.INSTANCE.createFromPokemon(serverPlayer, pokeList, this::canUseOnPokemon, pk -> {
            this.applyToPokemon(serverPlayer, itemStack, (Pokemon)pk);
            CobblemonCriteria.INSTANCE.getPOKEMON_INTERACT().trigger(serverPlayer, (Object)new PokemonInteractContext(pk.getSpecies().resourceIdentifier, class_7924.field_41197.method_41185()));
            return null;
        });
        return class_1271.method_22427((Object)itemStack);
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> list, class_1836 tooltipFlag) {
        super.method_7851(itemStack, tooltipContext, list, tooltipFlag);
        if (itemStack.method_57826(class_9334.field_49628) && ((class_9279)itemStack.method_57824(class_9334.field_49628)).method_57450("Flavors")) {
            class_2487 poffinTag = ((class_9279)itemStack.method_57824(class_9334.field_49628)).method_57461().method_10562("Flavors");
            try {
                int spicy = poffinTag.method_10550("spicy");
                int dry = poffinTag.method_10550("dry");
                int sweet = poffinTag.method_10550("sweet");
                int bitter = poffinTag.method_10550("bitter");
                int sour = poffinTag.method_10550("sour");
                int smoothness = poffinTag.method_10550("sheen");
                list.add((class_2561)class_2561.method_43469((String)"tooltip.cobble_contests.poffin_item.tooltip.poffin_stats", (Object[])new Object[]{spicy, dry, sweet, bitter, sour, smoothness}).method_27692(class_124.field_1056).method_27692(class_124.field_1076));
            }
            catch (ClassCastException classCastException) {}
        } else {
            int[] baseFlavors = this.getBaseFlavors();
            list.add((class_2561)class_2561.method_43469((String)"tooltip.cobble_contests.poffin_item.tooltip.poffin_stats", (Object[])new Object[]{baseFlavors[0], baseFlavors[1], baseFlavors[2], baseFlavors[3], baseFlavors[4], baseFlavors[5]}).method_27692(class_124.field_1056).method_27692(class_124.field_1076));
        }
    }

    private int[] getBaseFlavors() {
        int[] baseFlavors = new int[]{0, 0, 0, 0, 0, 20};
        if (this.mainFlavor >= 0 && this.mainFlavor < 6 && this.secFlavor == -1) {
            baseFlavors[this.mainFlavor] = 15;
        } else if (this.mainFlavor >= 0 && this.mainFlavor < 6) {
            baseFlavors[this.mainFlavor] = 10;
        }
        if (this.secFlavor >= 0 && this.secFlavor < 6) {
            baseFlavors[this.secFlavor] = 5;
        }
        if (this.mainFlavor == -1 && this.secFlavor == -1) {
            baseFlavors = new int[]{-10, -10, -10, -10, -10, -30};
        }
        return baseFlavors;
    }
}

