/*
 * Decompiled with CFR 0.152.
 */
package com.raspix.fabric.cobble_contests.blocks.entity;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.raspix.fabric.cobble_contests.blocks.entity.BlockEntityInit;
import com.raspix.fabric.cobble_contests.menus.ContestMenu;
import com.raspix.fabric.cobble_contests.network.BlockPosPayload;
import com.raspix.fabric.cobble_contests.pokemon.CVs;
import com.raspix.fabric.cobble_contests.pokemon.Ribbons;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContestBlockEntity
extends class_2586
implements class_3908,
ExtendedScreenHandlerFactory<BlockPosPayload> {
    private static final class_2561 TITLE = class_2561.method_43471((String)"container.cobble_contests.contest_block");
    private boolean isHost;
    private UUID hostId;
    private int contestType;
    private Map<UUID, ContestParticipation> participants;
    private int[] thresholds = new int[]{5, 40, 100, 175, 245};

    public ContestBlockEntity(class_2591<?> arg, class_2338 arg2, class_2680 arg3) {
        super(arg, arg2, arg3);
    }

    public ContestBlockEntity(class_2338 pPos, class_2680 pBlockState) {
        super(BlockEntityInit.CONTEST_BLOCK_ENTITY, pPos, pBlockState);
    }

    public class_2561 method_5476() {
        return TITLE;
    }

    @Nullable
    public class_1703 createMenu(int containerID, @NotNull class_1661 playerInv, class_1657 player) {
        ContestMenu menu = new ContestMenu(containerID, playerInv, this);
        return menu;
    }

    public boolean tryHosting(UUID id) {
        if (!this.isHost) {
            this.hostId = id;
            this.isHost = true;
            return true;
        }
        return false;
    }

    public boolean setContestType(UUID id, int type) {
        if (this.isHost && this.hostId == id) {
            this.contestType = type;
            return true;
        }
        if (!this.isHost) {
            this.tryHosting(id);
            this.contestType = type;
            return true;
        }
        return false;
    }

    private void removeHost() {
        this.hostId = null;
        this.isHost = false;
    }

    public void startContest(int color, UUID player) {
    }

    public void addContestant(UUID player, int pokemonIdx) {
    }

    public String getContestResults() {
        return "cobble_contests.contest_type.cool";
    }

    public void clearContest() {
        this.participants.clear();
        this.hostId = null;
        this.isHost = false;
        this.contestType = 0;
    }

    public void kickContestent(UUID id) {
        if (this.participants.containsKey(id)) {
            this.participants.remove(id);
        }
    }

    public BlockPosPayload getScreenOpeningData(class_3222 player) {
        return new BlockPosPayload(this.field_11867);
    }

    public String getCurrentContestInfo() {
        Object result = "";
        if (this.isHost) {
            result = (String)result + "Host: " + class_310.method_1551().field_1687.method_18470(this.hostId).method_5476().getString();
            result = (String)result + ", Type: " + this.contestType;
        } else {
            result = (String)result + "No current host";
        }
        return result;
    }

    public void runStubContest() {
        assert (class_310.method_1551().field_1687 != null);
        if (!class_310.method_1551().field_1687.field_9236) {
            // empty if block
        }
    }

    public void runStatAssesment(UUID id, int pokeIdx, int contestType, int contestLevel1, class_3222 player) {
        boolean result;
        Pokemon poke = Cobblemon.INSTANCE.getStorage().getParty(player).get(pokeIdx);
        class_2487 ribbonTag = poke.getPersistentData().method_10562("Ribbons");
        String pokeName = poke.getDisplayName().getString();
        int contestLevel = this.getNextContestLevel(ribbonTag, contestType);
        class_5250 componentOutput = contestLevel < 5 ? ((result = this.runContest(poke, contestType, contestLevel)) ? class_2561.method_43469((String)"cobble_contests.contest_result.won_ranked", (Object[])new Object[]{pokeName, this.getContestLevelString(contestLevel), this.getContestTypeString(contestType)}).method_27692(class_124.field_1076) : class_2561.method_43469((String)"cobble_contests.contest_result.lost_ranked", (Object[])new Object[]{pokeName, this.getContestLevelString(contestLevel), this.getContestTypeString(contestType)}).method_27692(class_124.field_1076)) : class_2561.method_43469((String)"cobble_contests.contest_result.maxed_ranked", (Object[])new Object[]{pokeName, this.getContestTypeString(contestType)}).method_27692(class_124.field_1076);
        class_3222 sPlayer = poke.getOwnerPlayer();
        if (!sPlayer.method_37908().method_8608()) {
            sPlayer.method_7353((class_2561)componentOutput, false);
        }
    }

    public String getContestTypeString(int contestType) {
        return switch (contestType) {
            case 0 -> "Cool";
            case 1 -> "Beauty";
            case 2 -> "Cute";
            case 3 -> "Smart";
            case 4 -> "Tough";
            default -> "ERROR";
        };
    }

    public static String getContestTypeString1(int contestType) {
        return switch (contestType) {
            case 0 -> "Cool";
            case 1 -> "Beauty";
            case 2 -> "Cute";
            case 3 -> "Smart";
            case 4 -> "Tough";
            default -> "ERROR";
        };
    }

    public String getContestLevelString(int contestLevel) {
        return switch (contestLevel) {
            case 0 -> "Normal";
            case 1 -> "Super";
            case 2 -> "Hyper";
            case 3 -> "Ultra";
            case 4 -> "Master";
            default -> "ERROR";
        };
    }

    private int getNextContestLevel(class_2487 ribbonTag, int contestType) {
        Ribbons ribbons = Ribbons.getFromTag(ribbonTag);
        return ribbons.getNextContestLevel(contestType);
    }

    private boolean runContest(Pokemon poke, int contestType, int contestLevel) {
        boolean result = false;
        CVs cvs = CVs.getFromTag(poke.getPersistentData().method_10562("CVs"));
        Ribbons ribbons = Ribbons.getFromTag(poke.getPersistentData().method_10562("Ribbons"));
        switch (contestType) {
            case 0: {
                if (!this.runAppContest(poke, contestLevel, cvs.getCool())) break;
                ribbons.setRankedCool(contestLevel, true);
                result = true;
                break;
            }
            case 1: {
                if (!this.runAppContest(poke, contestLevel, cvs.getBeauty())) break;
                ribbons.setRankedBeauty(contestLevel, true);
                result = true;
                break;
            }
            case 2: {
                if (!this.runAppContest(poke, contestLevel, cvs.getCute())) break;
                ribbons.setRankedCute(contestLevel, true);
                result = true;
                break;
            }
            case 3: {
                if (!this.runAppContest(poke, contestLevel, cvs.getSmart())) break;
                ribbons.setRankedSmart(contestLevel, true);
                result = true;
                break;
            }
            case 4: {
                if (!this.runAppContest(poke, contestLevel, cvs.getTough())) break;
                ribbons.setRankedTough(contestLevel, true);
                result = true;
                break;
            }
        }
        HashMap<String, class_2487> myData = new HashMap<String, class_2487>(){};
        myData.put("Ribbons", ribbons.saveToNBT());
        this.saveRibbons(poke, (Map<String, class_2487>)myData);
        return result;
    }

    private void saveRibbons(Pokemon pokemon, Map<String, class_2487> myData) {
        class_2487 tag = pokemon.getPersistentData();
        myData.forEach((key, value) -> tag.method_10566(key, (class_2520)value));
        if (pokemon.getChangeObservable() instanceof SimpleObservable) {
            ((SimpleObservable)pokemon.getChangeObservable()).emit((Object[])new Pokemon[]{pokemon});
        } else {
            System.out.println("error, not simple observable (ContestBlockEntity)");
        }
    }

    private boolean runAppContest(Pokemon poke, int level, int typeVal) {
        boolean result = false;
        if (level < 5 && typeVal >= this.thresholds[level]) {
            result = true;
        }
        return result;
    }

    private boolean runBeautyContest(Pokemon poke, int level) {
        boolean result = false;
        CVs cvs = CVs.getFromTag(poke.getPersistentData().method_10562("CVs"));
        if (cvs.getBeauty() >= this.thresholds[level]) {
            result = true;
            Ribbons ribbons = Ribbons.getFromTag(poke.getPersistentData().method_10562("Ribbons"));
            ribbons.setRankedBeauty(level, true);
            HashMap<String, class_2487> myData = new HashMap<String, class_2487>(){};
            myData.put("Ribbons", ribbons.saveToNBT());
            this.saveRibbons(poke, (Map<String, class_2487>)myData);
        }
        return result;
    }

    public class ContestParticipation {
        private UUID id;
        private int pokemonIdx;

        public ContestParticipation(ContestBlockEntity this$0, UUID id, int pokemonIdx) {
            this.id = id;
            this.pokemonIdx = pokemonIdx;
        }
    }
}

