/*
 * Decompiled with CFR 0.152.
 */
package com.raspix.fabric.cobble_contests;

import com.cobblemon.mod.common.api.data.DataRegistry;
import com.cobblemon.mod.common.api.data.JsonDataRegistry;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.raspix.fabric.cobble_contests.CobbleContestsFabric;
import com.raspix.fabric.cobble_contests.events.ContestMoves;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;

public class CobbleContestsMoves
implements JsonDataRegistry<ContestMoves.MoveData> {
    public static CobbleContestsMoves INSTANCE = new CobbleContestsMoves();
    public Map<String, ContestMoves.MoveData> allMoves = new HashMap<String, ContestMoves.MoveData>();

    @NotNull
    public class_2960 getId() {
        return class_2960.method_60655((String)"cobble_contests", (String)"contest_moves");
    }

    @NotNull
    public SimpleObservable<? extends DataRegistry> getObservable() {
        return new SimpleObservable();
    }

    @NotNull
    public class_3264 getType() {
        return class_3264.field_14190;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T loadMechanic(class_3300 manager, String name, Class<T> clazz) {
        try (InputStream inputStream = manager.getResourceOrThrow(class_2960.method_60655((String)"cobble_contests", (String)("moves/" + name + ".json"))).method_14482();){
            Object object = this.getGson().fromJson((Reader)new InputStreamReader(inputStream), clazz);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T loadLine(String line, Class<T> clazz) {
        System.out.println(line);
        CobbleContestsFabric.LOGGER.info(this.getGson().fromJson(line, clazz).toString());
        return (T)this.getGson().fromJson(line, clazz);
    }

    public void reload(@NotNull class_3300 resourceManager) {
        this.allMoves.clear();
        resourceManager.method_41265("moves", path -> path.method_12832().endsWith(".json")).forEach((identifier, resource) -> {
            try (InputStream stream = ((class_3298)resource.get(0)).method_14482();){
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                class_2960 resolvedIdentifier = class_2960.method_60655((String)identifier.method_12836(), (String)new File(identifier.method_12832()).getName());
                List<String> lines = reader.lines().toList();
                for (int i = 1; i < lines.size() - 2; ++i) {
                    if (lines.get(i).equals("")) continue;
                    Move newMove = this.loadLine(lines.get(i).substring(0, lines.get(i).length() - 1).replaceAll("\\s", ""), Move.class);
                    this.allMoves.put(newMove.name, new ContestMoves.MoveData(newMove.name, newMove.contestStat, newMove.appeal));
                }
                Move lastMove = this.loadLine(lines.get(lines.size() - 2).replaceAll("\\s", ""), Move.class);
                this.allMoves.put(lastMove.name, new ContestMoves.MoveData(lastMove.name, lastMove.contestStat, lastMove.appeal));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        CobbleContestsFabric.LOGGER.info("Loaded {} contest moves", (Object)this.allMoves.size());
        this.getObservable().emit((Object[])new DataRegistry[0]);
    }

    public void sync(@NotNull class_3222 serverPlayer) {
    }

    @NotNull
    public Gson getGson() {
        return new Gson();
    }

    @NotNull
    public String getResourcePath() {
        return "moves";
    }

    @NotNull
    public TypeToken getTypeToken() {
        return TypeToken.get(ContestMoves.MoveData.class);
    }

    public void reload(@NotNull Map<class_2960, ? extends ContestMoves.MoveData> data) {
        this.allMoves.clear();
        for (Map.Entry<class_2960, ? extends ContestMoves.MoveData> entry : data.entrySet()) {
            class_2960 identifier = entry.getKey();
            ContestMoves.MoveData dat = entry.getValue();
            try {
                this.allMoves.put(identifier.method_12836(), dat);
            }
            catch (Exception e) {
                CobbleContestsFabric.LOGGER.error("Error loading the {} move", (Object)identifier, (Object)e);
            }
        }
        CobbleContestsFabric.LOGGER.info("MEOW RIGHT HERE or something");
        CobbleContestsFabric.LOGGER.info("Loaded {} contest moves", (Object)this.allMoves.size());
        this.getObservable().emit((Object[])new DataRegistry[0]);
    }

    public class Move {
        private String name;
        private String contestStat;
        private int appeal;

        public Move(CobbleContestsMoves this$0) {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getContestStat() {
            return this.contestStat;
        }

        public void setContestStat(String contestStat) {
            this.contestStat = contestStat;
        }

        public int getAppeal() {
            return this.appeal;
        }

        public void setAppeal(int appeal) {
            this.appeal = appeal;
        }

        public String toString() {
            return "Name: " + this.name + ", Stat: " + this.getContestStat() + ", Appeal: " + this.appeal;
        }
    }
}

