/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.WorldUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3966;
import org.jspecify.annotations.Nullable;

public final class InventoryUtil {
    private InventoryUtil() {
    }

    public static int getHandSlot(class_1657 player, class_1268 hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case class_1268.field_5808 -> player.method_31548().field_7545;
            case class_1268.field_5810 -> 40;
        };
    }

    public static int getInventorySlotFromCompartment(class_1657 player, int slot, class_1799 stack) {
        if (stack.method_7960()) {
            throw new IllegalArgumentException("Cannot search for empty stack");
        }
        if (player.method_31548().method_5438(slot) == stack) {
            return slot;
        }
        if (player.method_31548().method_5438(40) == stack) {
            return 40;
        }
        return -1;
    }

    public static @Nullable class_1263 getEntityContainer(class_3218 level, class_2338 pos, class_2350 side) {
        class_1263 container;
        class_3966 entityHit;
        class_1297 class_12972;
        class_2350 dir;
        class_243 vecDir;
        class_243 vecStart = new class_243((double)pos.method_10263() + 0.5 + 0.6 * (double)side.method_10148(), (double)pos.method_10264() + 0.5 + 0.6 * (double)side.method_10164(), (double)pos.method_10260() + 0.5 + 0.6 * (double)side.method_10165());
        class_239 hit = WorldUtil.clip((class_1937)level, vecStart, vecDir = new class_243((double)(dir = side.method_10153()).method_10148(), (double)dir.method_10164(), (double)dir.method_10165()), 1.1, null);
        return hit instanceof class_3966 && (class_12972 = (entityHit = (class_3966)hit).method_17782()) instanceof class_1263 ? (container = (class_1263)class_12972) : null;
    }

    public static class_1799 storeItemsIntoSlot(class_1263 container, class_1799 stack, int slot) {
        return InventoryUtil.storeItems(container, stack, slot, 1);
    }

    public static class_1799 storeItemsFromOffset(class_1263 container, class_1799 stack, int offset) {
        return InventoryUtil.storeItems(container, stack, offset, container.method_5439());
    }

    private static class_1799 storeItems(class_1263 container, class_1799 stack, int offset, int slotCount) {
        int originalCount = stack.method_7947();
        class_1799 remainder = InventoryUtil.storeItemsImpl(container, stack, offset, slotCount);
        if (remainder.method_7947() != originalCount) {
            container.method_5431();
        }
        return remainder;
    }

    private static class_1799 storeItemsImpl(class_1263 container, class_1799 stack, int offset, int slotCount) {
        int limit = container.method_5439();
        int maxSize = Math.min(stack.method_7914(), container.method_5444());
        if (maxSize <= 0) {
            return stack;
        }
        for (int i = 0; i < slotCount; ++i) {
            class_1799 currentStack;
            int slot = i + offset;
            if (slot >= limit) {
                slot -= limit;
            }
            if ((currentStack = container.method_5438(slot)).method_7960()) {
                if (!container.method_5437(slot, stack)) continue;
                if (stack.method_7947() <= maxSize) {
                    container.method_5447(slot, stack);
                    return class_1799.field_8037;
                }
                container.method_5447(slot, stack.method_7971(maxSize));
                continue;
            }
            if (currentStack.method_7947() >= Math.min(currentStack.method_7914(), maxSize) || !InventoryUtil.canMergeItems(currentStack, stack)) continue;
            int toMove = Math.min(stack.method_7947(), maxSize - currentStack.method_7947());
            currentStack.method_7933(toMove);
            stack.method_7934(toMove);
            if (!stack.method_7960()) continue;
            return class_1799.field_8037;
        }
        return stack;
    }

    private static boolean canMergeItems(class_1799 stack1, class_1799 stack2) {
        if (stack1.method_7909() != stack2.method_7909()) {
            return false;
        }
        if (stack1.method_7919() != stack2.method_7919()) {
            return false;
        }
        if (stack1.method_7947() > stack1.method_7914()) {
            return false;
        }
        return class_1799.method_31577((class_1799)stack1, (class_1799)stack2);
    }
}

