/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.api.upgrades.UpgradeType;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemPeripheral;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import org.jspecify.annotations.Nullable;

public class TurtleModem
extends AbstractTurtleUpgrade {
    public static final MapCodec<TurtleModem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41178.method_39673().fieldOf("item").forGetter(x -> x.getCraftingItem().method_7909()), (App)Codec.BOOL.fieldOf("advanced").forGetter(TurtleModem::advanced)).apply((Applicative)instance, (item, advanced) -> new TurtleModem(new class_1799((class_1935)item), (boolean)advanced)));
    private final boolean advanced;

    public TurtleModem(class_1799 stack, boolean advanced) {
        super(TurtleUpgradeType.PERIPHERAL, advanced ? "upgrade.computercraft.wireless_modem_advanced.adjective" : "upgrade.computercraft.wireless_modem_normal.adjective", stack);
        this.advanced = advanced;
    }

    public boolean advanced() {
        return this.advanced;
    }

    @Override
    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new Peripheral(turtle, this.advanced);
    }

    @Override
    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, class_2350 dir) {
        return TurtleCommandResult.failure();
    }

    @Override
    public void update(ITurtleAccess turtle, TurtleSide side) {
        Peripheral modem;
        ModemState state;
        IPeripheral peripheral;
        if (!turtle.getLevel().field_9236 && (peripheral = turtle.getPeripheral(side)) instanceof Peripheral && (state = (modem = (Peripheral)peripheral).getModemState()).pollChanged()) {
            turtle.setUpgradeData(side, class_9326.method_57841().method_57854((class_9331)ModRegistry.DataComponents.ON.get(), (Object)state.isOpen()).method_57852());
        }
    }

    @Override
    public class_9326 getPersistedData(class_9326 upgradeData) {
        return class_9326.field_49588;
    }

    public UpgradeType<TurtleModem> getType() {
        return (UpgradeType)ModRegistry.TurtleUpgradeTypes.WIRELESS_MODEM.get();
    }

    private static class Peripheral
    extends WirelessModemPeripheral {
        private final ITurtleAccess turtle;

        Peripheral(ITurtleAccess turtle, boolean advanced) {
            super(new ModemState(), advanced);
            this.turtle = turtle;
        }

        @Override
        public class_1937 getLevel() {
            return this.turtle.getLevel();
        }

        @Override
        public class_243 getPosition() {
            class_2338 turtlePos = this.turtle.getPosition();
            return new class_243((double)turtlePos.method_10263(), (double)turtlePos.method_10264(), (double)turtlePos.method_10260());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable IPeripheral other) {
            if (this == other) return true;
            if (!(other instanceof Peripheral)) return false;
            Peripheral modem = (Peripheral)other;
            if (modem.turtle != this.turtle) return false;
            return true;
        }
    }
}

