/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlock;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.util.BlockCodecs;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import dan200.computercraft.shared.util.WaterloggableHelpers;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1668;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_9062;
import net.minecraft.class_9334;
import org.jspecify.annotations.Nullable;

public class TurtleBlock
extends AbstractComputerBlock<TurtleBlockEntity>
implements class_3737 {
    private static final MapCodec<TurtleBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(BlockCodecs.propertiesCodec(), BlockCodecs.blockEntityCodec(x -> x.type)).apply((Applicative)instance, TurtleBlock::new));
    public static final class_2753 FACING = class_2741.field_12481;
    public static final float IMMUNE_EXPLOSION_RESISTANCE = 2000.0f;
    private static final class_265 DEFAULT_SHAPE = class_259.method_1081((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
    private final class_5558<TurtleBlockEntity> clientTicker = (level, pos, state, computer) -> computer.clientTick();

    public TurtleBlock(class_4970.class_2251 settings, RegistryEntry<class_2591<TurtleBlockEntity>> type) {
        super(settings, type);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WaterloggableHelpers.WATERLOGGED});
    }

    protected MapCodec<? extends TurtleBlock> method_53969() {
        return CODEC;
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_243 class_2432;
        class_2586 tile = world.method_8321(pos);
        if (tile instanceof TurtleBlockEntity) {
            TurtleBlockEntity turtle = (TurtleBlockEntity)tile;
            class_2432 = turtle.getRenderOffset(1.0f);
        } else {
            class_2432 = class_243.field_1353;
        }
        class_243 offset = class_2432;
        return offset.equals((Object)class_243.field_1353) ? DEFAULT_SHAPE : DEFAULT_SHAPE.method_1096(offset.field_1352, offset.field_1351, offset.field_1350);
    }

    public @Nullable class_2680 method_9605(class_1750 placement) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)placement.method_8042())).method_11657((class_2769)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(WaterloggableHelpers.getFluidStateForPlacement(placement)));
    }

    protected class_3610 method_9545(class_2680 state) {
        return WaterloggableHelpers.getFluidState(state);
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_2350 side, class_2680 otherState, class_1936 world, class_2338 pos, class_2338 otherPos) {
        WaterloggableHelpers.updateShape(state, world, pos);
        return state;
    }

    protected final void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        TurtleBlockEntity t;
        class_2586 class_25862;
        if (state.method_27852(newState.method_26204())) {
            return;
        }
        TurtleBlockEntity turtle = !level.field_9236 && (class_25862 = level.method_8321(pos)) instanceof TurtleBlockEntity && !(t = (TurtleBlockEntity)class_25862).hasMoved() ? t : null;
        super.method_9536(state, level, pos, newState, isMoving);
        if (turtle != null) {
            class_1264.method_5451((class_1937)level, (class_2338)pos, (class_1263)turtle);
        }
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 entity, class_1799 stack) {
        class_2586 class_25862;
        super.method_9567(level, pos, state, entity, stack);
        if (!level.field_9236 && (class_25862 = level.method_8321(pos)) instanceof TurtleBlockEntity) {
            TurtleBlockEntity turtle = (TurtleBlockEntity)class_25862;
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                turtle.setOwningPlayer(player.method_7334());
            }
        }
    }

    protected class_9062 method_55765(class_1799 currentItem, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862;
        if (currentItem.method_7909() == class_1802.field_8448 && currentItem.method_57826(class_9334.field_49631) && (class_25862 = level.method_8321(pos)) instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)class_25862;
            if (!level.field_9236) {
                computer.setLabel(currentItem.method_7964().getString());
                currentItem.method_7934(1);
            }
            return class_9062.method_55644((boolean)level.field_9236);
        }
        return super.method_55765(currentItem, state, level, pos, player, hand, hit);
    }

    public float getExplosionResistance(class_2680 state, class_1922 world, class_2338 pos, class_1927 explosion) {
        class_1297 exploder = explosion.method_46406();
        if (exploder instanceof class_1309 || exploder instanceof class_1668) {
            return 2000.0f;
        }
        return this.method_9520();
    }

    @Override
    public <U extends class_2586> @Nullable class_5558<U> method_31645(class_1937 level, class_2680 state, class_2591<U> type) {
        return level.field_9236 ? BlockEntityHelpers.createTickerHelper(type, (class_2591)this.type.get(), this.clientTicker) : super.method_31645(level, state, type);
    }
}

