/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.items;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.core.TerminalSize;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.computer.items.ServerComputerReference;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.pocket.core.PocketBrain;
import dan200.computercraft.shared.pocket.core.PocketHolder;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.NonNegativeId;
import dan200.computercraft.shared.util.StorageCapacity;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_9282;
import net.minecraft.class_9322;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import org.jspecify.annotations.Nullable;

public class PocketComputerItem
extends class_1792 {
    private final ComputerFamily family;

    public PocketComputerItem(class_1792.class_1793 settings, ComputerFamily family) {
        super(settings);
        this.family = family;
    }

    public void tick(class_1799 stack, PocketHolder holder, boolean passive) {
        PocketBrain brain;
        if (passive) {
            PocketServerComputer computer = PocketComputerItem.getServerComputer(holder.level().method_8503(), stack);
            if (computer == null) {
                return;
            }
            brain = computer.getBrain();
        } else {
            brain = this.getOrCreateBrain(holder.level(), holder, stack);
            brain.computer().keepAlive();
        }
        UpgradeData<IPocketUpgrade> upgrade = brain.getUpgrade();
        if (upgrade != null) {
            upgrade.upgrade().update(brain, brain.computer().getPeripheral(ComputerSide.BACK));
        }
        if (this.updateItem(stack, brain)) {
            holder.setChanged();
        }
    }

    private boolean updateItem(class_1799 stack, PocketBrain brain) {
        boolean on;
        boolean changed = brain.updateItem(stack);
        PocketServerComputer computer = brain.computer();
        String label = computer.getLabel();
        if (!Objects.equals(label, this.getLabel(stack))) {
            changed = true;
            DataComponentUtil.setCustomName(stack, label);
        }
        if ((on = computer.isOn()) != PocketComputerItem.isMarkedOn(stack)) {
            changed = true;
            stack.method_57379((class_9331)ModRegistry.DataComponents.ON.get(), (Object)on);
        }
        return changed;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int compartmentSlot, boolean selected) {
        if (world.field_9236 || !(entity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)entity;
        int slot = InventoryUtil.getInventorySlotFromCompartment((class_1657)player, compartmentSlot, stack);
        if (slot < 0) {
            return;
        }
        this.tick(stack, new PocketHolder.PlayerHolder(player, slot), false);
    }

    public boolean onEntityItemUpdate(class_1799 stack, class_1542 entity) {
        class_1937 level = entity.method_37908();
        if (level.field_9236 || level.method_8503() == null) {
            return false;
        }
        this.tick(stack, new PocketHolder.ItemEntityHolder(entity), true);
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!world.field_9236) {
            PocketHolder.PlayerHolder holder = new PocketHolder.PlayerHolder((class_3222)player, InventoryUtil.getHandSlot(player, hand));
            PocketBrain brain = this.getOrCreateBrain((class_3218)world, holder, stack);
            PocketServerComputer computer = brain.computer();
            computer.turnOn();
            boolean stop = false;
            IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
            if (upgrade != null) {
                stop = upgrade.onRightClick(world, brain, computer.getPeripheral(ComputerSide.BACK));
                this.updateItem(stack, brain);
            }
            if (!stop) {
                PocketComputerItem.openImpl(player, stack, holder, hand == class_1268.field_5810, computer);
            }
        }
        return new class_1271(class_1269.method_29236((boolean)world.field_9236), (Object)stack);
    }

    public void open(class_1657 player, class_1799 stack, PocketHolder holder, boolean isTypingOnly) {
        PocketBrain brain = this.getOrCreateBrain(holder.level(), holder, stack);
        PocketServerComputer computer = brain.computer();
        computer.turnOn();
        PocketComputerItem.openImpl(player, stack, holder, isTypingOnly, computer);
    }

    private static void openImpl(class_1657 player, class_1799 stack, PocketHolder holder, boolean isTypingOnly, ServerComputer computer) {
        PlatformHelper.get().openMenu(player, stack.method_7964(), (id, inventory, entity) -> new ComputerMenuWithoutInventory((class_3917<? extends AbstractComputerMenu>)(isTypingOnly ? (class_3917)ModRegistry.Menus.POCKET_COMPUTER_NO_TERM.get() : (class_3917)ModRegistry.Menus.COMPUTER.get()), id, inventory, p -> holder.isValid(computer), computer), new ComputerContainerData(computer, stack));
    }

    public class_2561 method_7864(class_1799 stack) {
        String baseString = this.method_7866(stack);
        IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
        if (upgrade != null) {
            return class_2561.method_43469((String)(baseString + ".upgraded"), (Object[])new Object[]{upgrade.getAdjective()});
        }
        return super.method_7864(stack);
    }

    public @Nullable String getCreatorModId(class_1799 stack) {
        UpgradeData<IPocketUpgrade> upgrade = PocketComputerItem.getUpgradeWithData(stack);
        return upgrade != null ? PocketUpgrades.instance().getOwner(upgrade.holder()) : "computercraft";
    }

    private PocketBrain getOrCreateBrain(class_3218 level, PocketHolder holder, class_1799 stack) {
        ServerComputerRegistry registry = ServerContext.get(level.method_8503()).registry();
        PocketServerComputer computer = PocketComputerItem.getServerComputer(registry, stack);
        if (computer != null) {
            PocketBrain brain = computer.getBrain();
            brain.updateHolder(holder);
            return brain;
        }
        int computerID = NonNegativeId.getOrCreate(level.method_8503(), stack, (class_9331<NonNegativeId>)((class_9331)ModRegistry.DataComponents.COMPUTER_ID.get()), "computer");
        PocketBrain brain = new PocketBrain(holder, PocketComputerItem.getUpgradeWithData(stack), class_9282.method_57470((class_1799)stack, (int)-1), ServerComputer.properties(computerID, this.getFamily()).label(this.getLabel(stack)).storageCapacity(StorageCapacity.getOrDefault((StorageCapacity)stack.method_57824((class_9331)ModRegistry.DataComponents.STORAGE_CAPACITY.get()), -1L)).terminalSize((TerminalSize)stack.method_57825((class_9331)ModRegistry.DataComponents.TERMINAL_SIZE.get(), (Object)new TerminalSize((Integer)ConfigSpec.pocketTermWidth.get(), (Integer)ConfigSpec.pocketTermHeight.get()))));
        PocketServerComputer computer2 = brain.computer();
        stack.method_57379((class_9331)ModRegistry.DataComponents.COMPUTER.get(), (Object)new ServerComputerReference(registry.getSessionID(), computer2.register()));
        if (PocketComputerItem.isMarkedOn(stack)) {
            computer2.turnOn();
        }
        this.updateItem(stack, brain);
        holder.setChanged();
        return brain;
    }

    public static boolean isServerComputer(ServerComputer computer, class_1799 stack) {
        return stack.method_7909() instanceof PocketComputerItem && PocketComputerItem.getServerComputer(computer.getLevel().method_8503(), stack) == computer;
    }

    public static @Nullable PocketServerComputer getServerComputer(ServerComputerRegistry registry, class_1799 stack) {
        return (PocketServerComputer)ServerComputerReference.get((class_9322)stack, registry);
    }

    public static @Nullable PocketServerComputer getServerComputer(MinecraftServer server, class_1799 stack) {
        return PocketComputerItem.getServerComputer(ServerContext.get(server).registry(), stack);
    }

    public void method_7843(class_1799 stack, class_1937 level) {
        MinecraftServer server = level.method_8503();
        if (server == null) {
            return;
        }
        PocketServerComputer computer = PocketComputerItem.getServerComputer(server, stack);
        if (computer == null) {
            return;
        }
        PocketBrain brain = computer.getBrain();
        brain.setUpgrade(PocketComputerItem.getUpgradeWithData(stack));
        brain.setColour(class_9282.method_57470((class_1799)stack, (int)-1));
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    private @Nullable String getLabel(class_1799 stack) {
        return DataComponentUtil.getCustomName((class_9322)stack);
    }

    private static boolean isMarkedOn(class_1799 stack) {
        return (Boolean)stack.method_57825((class_9331)ModRegistry.DataComponents.ON.get(), (Object)false);
    }

    public static @Nullable IPocketUpgrade getUpgrade(class_1799 stack) {
        UpgradeData<IPocketUpgrade> upgrade = PocketComputerItem.getUpgradeWithData(stack);
        return upgrade == null ? null : upgrade.upgrade();
    }

    public static @Nullable UpgradeData<IPocketUpgrade> getUpgradeWithData(class_1799 stack) {
        return (UpgradeData)stack.method_57824((class_9331)ModRegistry.DataComponents.POCKET_UPGRADE.get());
    }

    public static void setUpgrade(class_1799 stack, @Nullable UpgradeData<IPocketUpgrade> upgrade) {
        stack.method_57379((class_9331)ModRegistry.DataComponents.POCKET_UPGRADE.get(), upgrade);
    }
}

