/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.apis;

import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.PocketUpgrades;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_7225;
import org.jspecify.annotations.Nullable;

public class PocketAPI
implements ILuaAPI {
    private final IPocketAccess pocket;

    public PocketAPI(IPocketAccess pocket) {
        this.pocket = pocket;
    }

    @Override
    public String[] getNames() {
        return new String[]{"pocket"};
    }

    @LuaFunction(mainThread=true)
    public final Object[] equipBack() {
        class_1297 entity = this.pocket.getEntity();
        if (!(entity instanceof class_1657)) {
            return new Object[]{false, "Cannot find player"};
        }
        class_1657 player = (class_1657)entity;
        class_1661 inventory = player.method_31548();
        UpgradeData<IPocketUpgrade> previousUpgrade = this.pocket.getUpgrade();
        UpgradeData<IPocketUpgrade> newUpgrade = this.findUpgrade((class_2371<class_1799>)inventory.field_7547, inventory.field_7545, previousUpgrade);
        if (newUpgrade == null) {
            newUpgrade = this.findUpgrade((class_2371<class_1799>)inventory.field_7544, 0, previousUpgrade);
        }
        if (newUpgrade == null) {
            return new Object[]{false, "Cannot find a valid upgrade"};
        }
        if (previousUpgrade != null) {
            PocketAPI.storeItem(player, previousUpgrade.getUpgradeItem());
        }
        this.pocket.setUpgrade(newUpgrade);
        return new Object[]{true};
    }

    @LuaFunction(mainThread=true)
    public final Object[] unequipBack() {
        class_1297 entity = this.pocket.getEntity();
        if (!(entity instanceof class_1657)) {
            return new Object[]{false, "Cannot find player"};
        }
        class_1657 player = (class_1657)entity;
        UpgradeData<IPocketUpgrade> previousUpgrade = this.pocket.getUpgrade();
        if (previousUpgrade == null) {
            return new Object[]{false, "Nothing to unequip"};
        }
        this.pocket.setUpgrade(null);
        PocketAPI.storeItem(player, previousUpgrade.getUpgradeItem());
        return new Object[]{true};
    }

    private static void storeItem(class_1657 player, class_1799 stack) {
        class_1542 drop;
        if (!stack.method_7960() && !player.method_31548().method_7394(stack) && (drop = player.method_7328(stack, false)) != null) {
            drop.method_6975();
        }
    }

    private @Nullable UpgradeData<IPocketUpgrade> findUpgrade(class_2371<class_1799> inv, int start, @Nullable UpgradeData<IPocketUpgrade> previous) {
        for (int i = 0; i < inv.size(); ++i) {
            UpgradeData<IPocketUpgrade> newUpgrade;
            class_1799 invStack = (class_1799)inv.get((i + start) % inv.size());
            if (invStack.method_7960() || (newUpgrade = PocketUpgrades.instance().get((class_7225.class_7874)this.pocket.getLevel().method_30349(), invStack)) == null || Objects.equals(newUpgrade, previous)) continue;
            invStack = invStack.method_7972();
            invStack.method_7934(1);
            inv.set((i + start) % inv.size(), (Object)(invStack.method_7960() ? class_1799.field_8037 : invStack));
            return newUpgrade;
        }
        return null;
    }
}

