/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.Objects;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7225;
import org.jspecify.annotations.Nullable;

public class CableBlockEntity
extends class_2586 {
    private boolean refreshPeripheral;
    private final WiredModemLocalPeripheral peripheral = new WiredModemLocalPeripheral(PlatformHelper.get().createPeripheralAccess(this, x -> this.queueRefreshPeripheral()));
    private boolean refreshConnections = false;
    private final WiredModemElement cable = new CableElement();
    private final WiredNode node = this.cable.getNode();
    private final TickScheduler.Token tickToken = new TickScheduler.Token(this);
    private final WiredModemPeripheral modem = new WiredModemPeripheral(new ModemState(() -> TickScheduler.schedule(this.tickToken)), this.cable, this.peripheral, this){

        @Override
        public class_243 getPosition() {
            class_2350 dir = CableBlockEntity.this.getModemDirection();
            return class_243.method_24953((class_2382)(dir == null ? CableBlockEntity.this.method_11016() : CableBlockEntity.this.method_11016().method_10093(dir)));
        }
    };
    private final ComponentAccess<WiredElement> connectedElements = PlatformHelper.get().createWiredElementAccess(this, x -> this.scheduleConnectionsChanged());

    public CableBlockEntity(class_2591<? extends CableBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void method_11012() {
        super.method_11012();
        this.modem.removed();
        if (this.field_11863 == null || !this.field_11863.field_9236) {
            this.node.remove();
        }
    }

    public void method_10996() {
        super.method_10996();
        this.refreshPeripheral = true;
        this.refreshConnections = true;
        TickScheduler.schedule(this.tickToken);
    }

    @Deprecated
    public void method_31664(class_2680 state) {
        class_2350 direction = this.getModemDirection();
        boolean hasCable = this.hasCable();
        super.method_31664(state);
        if (this.hasCable() != hasCable || this.getModemDirection() != direction) {
            PlatformHelper.get().invalidateComponent(this);
        }
    }

    private @Nullable class_2350 getModemDirection() {
        return ((CableModemVariant)((Object)this.method_11010().method_11654(CableBlock.MODEM))).getFacing();
    }

    void neighborChanged(class_2338 neighbour) {
        class_2350 dir = this.getModemDirection();
        if (!this.method_10997().field_9236 && dir != null && this.method_11016().method_10093(dir).equals((Object)neighbour) && this.isPeripheralOn()) {
            this.queueRefreshPeripheral();
        }
    }

    void queueRefreshPeripheral() {
        this.refreshPeripheral = true;
        TickScheduler.schedule(this.tickToken);
    }

    class_1269 use(class_1657 player) {
        if (!this.canAttachPeripheral()) {
            return class_1269.field_5814;
        }
        if (this.method_10997().field_9236) {
            return class_1269.field_5812;
        }
        String oldName = this.peripheral.getConnectedName();
        if (this.isPeripheralOn()) {
            this.detachPeripheral();
        } else {
            this.attachPeripheral();
        }
        String newName = this.peripheral.getConnectedName();
        if (!Objects.equals(newName, oldName)) {
            if (oldName != null) {
                player.method_7353((class_2561)class_2561.method_43469((String)"chat.computercraft.wired_modem.peripheral_disconnected", (Object[])new Object[]{ChatHelpers.copy(oldName)}), false);
            }
            if (newName != null) {
                player.method_7353((class_2561)class_2561.method_43469((String)"chat.computercraft.wired_modem.peripheral_connected", (Object[])new Object[]{ChatHelpers.copy(newName)}), false);
            }
        }
        return class_1269.field_21466;
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        this.peripheral.read(nbt, "");
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 registries) {
        this.peripheral.write(nbt, "");
        super.method_11007(nbt, registries);
    }

    private void updateBlockState() {
        CableModemVariant newVariant;
        class_2680 state = this.method_11010();
        CableModemVariant oldVariant = (CableModemVariant)((Object)state.method_11654(CableBlock.MODEM));
        if (oldVariant != (newVariant = CableModemVariant.from(oldVariant.getFacing(), this.modem.getModemState().isOpen(), this.peripheral.hasPeripheral()))) {
            this.method_10997().method_8501(this.method_11016(), (class_2680)state.method_11657(CableBlock.MODEM, (Comparable)((Object)newVariant)));
        }
    }

    void blockTick() {
        if (this.method_10997().field_9236) {
            return;
        }
        if (this.refreshPeripheral) {
            this.refreshPeripheral = false;
            if (this.isPeripheralOn()) {
                this.attachPeripheral();
            }
        }
        if (this.modem.getModemState().pollChanged()) {
            this.updateBlockState();
        }
        if (this.refreshConnections) {
            this.connectionsChanged();
        }
    }

    void scheduleConnectionsChanged() {
        this.refreshConnections = true;
        TickScheduler.schedule(this.tickToken);
    }

    void connectionsChanged() {
        if (this.method_10997().field_9236) {
            return;
        }
        this.refreshConnections = false;
        class_2680 state = this.method_11010();
        class_1937 world = this.method_10997();
        class_2338 current = this.method_11016();
        for (class_2350 facing : DirectionUtil.FACINGS) {
            WiredElement element;
            class_2338 offset = current.method_10093(facing);
            if (!world.method_8477(offset) || (element = this.connectedElements.get(facing)) == null) continue;
            WiredNode node = element.getNode();
            if (CableBlock.canConnectIn(state, facing)) {
                this.node.connectTo(node);
                continue;
            }
            this.node.disconnectFrom(node);
        }
        if (!this.canAttachPeripheral()) {
            this.detachPeripheral();
        }
    }

    private void attachPeripheral() {
        class_2350 dir = Objects.requireNonNull(this.getModemDirection(), "Attaching without a modem");
        if (this.peripheral.attach(this.method_10997(), this.method_11016(), dir)) {
            this.updateConnectedPeripherals();
        }
        this.updateBlockState();
    }

    private void detachPeripheral() {
        if (this.peripheral.detach()) {
            this.updateConnectedPeripherals();
        }
        this.updateBlockState();
    }

    private void updateConnectedPeripherals() {
        this.node.updatePeripherals(this.peripheral.toMap());
    }

    public @Nullable WiredElement getWiredElement(@Nullable class_2350 direction) {
        return direction == null || CableBlock.canConnectIn(this.method_11010(), direction) ? this.cable : null;
    }

    public @Nullable IPeripheral getPeripheral(@Nullable class_2350 direction) {
        return direction == null || this.getModemDirection() == direction ? this.modem : null;
    }

    private boolean isPeripheralOn() {
        return ((CableModemVariant)((Object)this.method_11010().method_11654(CableBlock.MODEM))).isPeripheralOn();
    }

    boolean hasCable() {
        return (Boolean)this.method_11010().method_11654((class_2769)CableBlock.CABLE);
    }

    public boolean hasModem() {
        return this.method_11010().method_11654(CableBlock.MODEM) != CableModemVariant.None;
    }

    private boolean canAttachPeripheral() {
        return this.hasCable() && this.hasModem();
    }

    private final class CableElement
    extends WiredModemElement {
        private CableElement() {
        }

        @Override
        public class_1937 getLevel() {
            return CableBlockEntity.this.method_10997();
        }

        @Override
        public class_243 getPosition() {
            return class_243.method_24953((class_2382)CableBlockEntity.this.method_11016());
        }

        @Override
        protected void attachPeripheral(String name, IPeripheral peripheral) {
            CableBlockEntity.this.modem.attachPeripheral(name, peripheral);
        }

        @Override
        protected void detachPeripheral(String name) {
            CableBlockEntity.this.modem.detachPeripheral(name);
        }
    }
}

