/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.platform;

import com.google.auto.service.AutoService;
import dan200.computercraft.client.ClientTableFormatter;
import dan200.computercraft.client.gui.AbstractComputerScreen;
import dan200.computercraft.client.gui.OptionScreen;
import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.sound.SpeakerManager;
import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.peripheral.speaker.EncodedAudio;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_9793;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
@AutoService(value={ClientNetworkContext.class})
public final class ClientNetworkContextImpl
implements ClientNetworkContext {
    @Override
    public void handleChatTable(TableBuilder table) {
        ClientTableFormatter.INSTANCE.display(table);
    }

    @Override
    public void handleComputerTerminal(int containerId, TerminalState terminal) {
        class_1703 class_17032;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.field_7512.field_7763 == containerId && (class_17032 = player.field_7512) instanceof ComputerMenu) {
            ComputerMenu menu = (ComputerMenu)class_17032;
            menu.updateTerminal(terminal);
        }
    }

    @Override
    public void handleMonitorData(class_2338 pos, @Nullable TerminalState terminal) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_2586 te = player.method_37908().method_8321(pos);
        if (!(te instanceof MonitorBlockEntity)) {
            return;
        }
        MonitorBlockEntity monitor = (MonitorBlockEntity)te;
        monitor.read(terminal);
    }

    @Override
    public void handlePlayRecord(class_2338 pos, @Nullable class_6880<class_9793> song) {
        if (song == null) {
            class_310.method_1551().field_1769.method_60889(pos);
        } else {
            class_310.method_1551().field_1769.method_60891(song, pos);
        }
    }

    @Override
    public void handlePocketComputerData(UUID instanceId, ComputerState state, int lightState, @Nullable TerminalState terminal) {
        ClientPocketComputers.setState(instanceId, state, lightState, terminal);
    }

    @Override
    public void handlePocketComputerDeleted(UUID instanceId) {
        ClientPocketComputers.remove(instanceId);
    }

    @Override
    public void handleSpeakerAudio(UUID source, SpeakerPosition.Message position, float volume, EncodedAudio buffer) {
        SpeakerManager.getSound(source).playAudio(ClientNetworkContextImpl.reifyPosition(position), volume, buffer);
    }

    @Override
    public void handleSpeakerMove(UUID source, SpeakerPosition.Message position) {
        SpeakerManager.moveSound(source, ClientNetworkContextImpl.reifyPosition(position));
    }

    @Override
    public void handleSpeakerPlay(UUID source, SpeakerPosition.Message position, class_2960 sound, float volume, float pitch) {
        SpeakerManager.getSound(source).playSound(ClientNetworkContextImpl.reifyPosition(position), sound, volume, pitch);
    }

    @Override
    public void handleSpeakerStop(UUID source) {
        SpeakerManager.stopSound(source);
    }

    @Override
    public void handleUploadResult(int containerId, UploadResult result, @Nullable class_2561 errorMessage) {
        class_310 minecraft = class_310.method_1551();
        class_437 screen = OptionScreen.unwrap(minecraft.field_1755);
        if (screen instanceof AbstractComputerScreen && ((AbstractComputerMenu)((AbstractComputerScreen)screen).method_17577()).field_7763 == containerId) {
            ((AbstractComputerScreen)screen).uploadResult(result, errorMessage);
        }
    }

    private static SpeakerPosition reifyPosition(SpeakerPosition.Message pos) {
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        if (level != null && !level.method_27983().method_29177().equals((Object)pos.level())) {
            level = null;
        }
        return new SpeakerPosition((class_1937)level, pos.position(), level != null && pos.entity().isPresent() ? level.method_8469(pos.entity().getAsInt()) : null);
    }
}

