/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.shared.computer.core.ComputerFamily;
import java.util.Objects;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class GuiSprites {
    public static final ButtonTextures TURNED_OFF = GuiSprites.button("turned_off");
    public static final ButtonTextures TURNED_ON = GuiSprites.button("turned_on");
    public static final ButtonTextures TERMINATE = GuiSprites.button("terminate");
    public static final ComputerTextures COMPUTER_NORMAL = GuiSprites.computer("normal", true, true);
    public static final ComputerTextures COMPUTER_ADVANCED = GuiSprites.computer("advanced", true, true);
    public static final ComputerTextures COMPUTER_COMMAND = GuiSprites.computer("command", false, true);
    public static final ComputerTextures COMPUTER_COLOUR = GuiSprites.computer("colour", true, false);

    private GuiSprites() {
    }

    private static ButtonTextures button(String name) {
        return new ButtonTextures(class_2960.method_60655((String)"computercraft", (String)("buttons/" + name)), class_2960.method_60655((String)"computercraft", (String)("buttons/" + name + "_hover")));
    }

    private static ComputerTextures computer(String name, boolean pocket, boolean sidebar) {
        return new ComputerTextures(class_2960.method_60655((String)"computercraft", (String)("gui/border_" + name)), pocket ? class_2960.method_60655((String)"computercraft", (String)("gui/pocket_bottom_" + name)) : null, sidebar ? class_2960.method_60655((String)"computercraft", (String)("gui/sidebar_" + name)) : null);
    }

    public static ComputerTextures getComputerTextures(ComputerFamily family) {
        return switch (family) {
            default -> throw new MatchException(null, null);
            case ComputerFamily.NORMAL -> COMPUTER_NORMAL;
            case ComputerFamily.ADVANCED -> COMPUTER_ADVANCED;
            case ComputerFamily.COMMAND -> COMPUTER_COMMAND;
        };
    }

    @Environment(value=EnvType.CLIENT)
    public record ButtonTextures(class_2960 normal, class_2960 active) {
        public class_2960 get(boolean isActive) {
            return isActive ? this.active : this.normal;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record ComputerTextures(class_2960 border, @Nullable class_2960 pocketBottom, @Nullable class_2960 sidebar) {
        public Stream<class_2960> textures() {
            return Stream.of(this.border, this.pocketBottom, this.sidebar).filter(Objects::nonNull);
        }
    }
}

