/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import dan200.computercraft.api.client.FabricComputerCraftAPIClient;
import dan200.computercraft.client.ClientHooks;
import dan200.computercraft.client.ClientRegistry;
import dan200.computercraft.client.model.CustomModelLoader;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.impl.Services;
import dan200.computercraft.shared.CommonHooks;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.platform.FabricConfigFile;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.model.loading.v1.PreparableModelLoadingPlugin;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockGatherCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3929;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5272;
import net.minecraft.class_638;
import net.minecraft.class_8710;
import net.minecraft.class_9129;

@Environment(value=EnvType.CLIENT)
public class ComputerCraftClient {
    public static void init() {
        ClientNetworkContext clientNetwork = Services.load(ClientNetworkContext.class);
        for (class_8710.class_9155<class_9129, ? extends NetworkMessage<ClientNetworkContext>> type : NetworkMessages.getClientbound()) {
            ClientPlayNetworking.registerGlobalReceiver((class_8710.class_9154)type.comp_2243(), (packet, responseSender) -> packet.handle(clientNetwork));
        }
        ClientRegistry.register();
        ClientRegistry.registerTurtleModellers(FabricComputerCraftAPIClient::registerTurtleUpgradeModeller);
        ClientRegistry.registerItemColours((x$0, xva$1) -> ColorProviderRegistry.ITEM.register(x$0, (Object[])new class_1935[]{xva$1}));
        ClientRegistry.registerMenuScreens(class_3929::method_17542);
        ClientRegistry.registerMainThread(class_5272::method_27879);
        PreparableModelLoadingPlugin.register(CustomModelLoader::prepare, (state, context) -> {
            ClientRegistry.registerExtraModels(xva$0 -> context.addModels(new class_2960[]{xva$0}), state.getExtraModels());
            context.resolveModel().register(ctx -> state.loadModel(ctx.id()));
            context.modifyModelAfterBake().register((model, ctx) -> model == null ? null : state.wrapModel(ctx, model));
        });
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModRegistry.Blocks.COMPUTER_NORMAL.get(), class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModRegistry.Blocks.COMPUTER_COMMAND.get(), class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModRegistry.Blocks.COMPUTER_ADVANCED.get(), class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModRegistry.Blocks.MONITOR_NORMAL.get(), class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModRegistry.Blocks.MONITOR_ADVANCED.get(), class_1921.method_23581());
        ClientTickEvents.START_CLIENT_TICK.register(client -> ClientHooks.onTick());
        WorldRenderEvents.START.register(context -> ClientHooks.onRenderTick());
        WorldRenderEvents.BLOCK_OUTLINE.register((context, hitResult) -> {
            class_3965 blockHit;
            class_239 hit = class_310.method_1551().field_1765;
            if (hit instanceof class_3965 && (blockHit = (class_3965)hit).method_17777().equals((Object)hitResult.blockPos())) {
                return !ClientHooks.drawHighlight(Nullability.assertNonNull(context.matrixStack()), Nullability.assertNonNull(context.consumers()), context.camera(), blockHit);
            }
            return true;
        });
        ClientPickBlockGatherCallback.EVENT.register((player, hit) -> {
            if (hit.method_17783() != class_239.class_240.field_1332) {
                return class_1799.field_8037;
            }
            class_2338 pos = ((class_3965)hit).method_17777();
            class_638 level = Objects.requireNonNull(class_310.method_1551().field_1687);
            class_2680 state = level.method_8320(pos);
            class_2248 patt0$temp = state.method_26204();
            if (!(patt0$temp instanceof CableBlock)) {
                return class_1799.field_8037;
            }
            CableBlock cable = (CableBlock)patt0$temp;
            return cable.getCloneItemStack(state, hit, (class_4538)level, pos, player);
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> ClientRegistry.registerClientCommands(dispatcher, FabricClientCommandSource::sendError));
        ItemTooltipCallback.EVENT.register(CommonHooks::onItemTooltip);
        ((FabricConfigFile)ConfigSpec.clientSpec).load(FabricLoader.getInstance().getConfigDir().resolve("computercraft-client.toml"));
    }
}

