/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import dan200.computercraft.api.client.turtle.RegisterTurtleUpgradeModeller;
import dan200.computercraft.api.client.turtle.TurtleUpgradeModeller;
import dan200.computercraft.api.upgrades.UpgradeType;
import dan200.computercraft.client.gui.ComputerScreen;
import dan200.computercraft.client.gui.DiskDriveScreen;
import dan200.computercraft.client.gui.NoTermComputerScreen;
import dan200.computercraft.client.gui.PrinterScreen;
import dan200.computercraft.client.gui.PrintoutScreen;
import dan200.computercraft.client.gui.TurtleScreen;
import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.pocket.PocketComputerData;
import dan200.computercraft.client.render.CustomLecternRenderer;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.TurtleBlockEntityRenderer;
import dan200.computercraft.client.render.monitor.MonitorBlockEntityRenderer;
import dan200.computercraft.client.turtle.TurtleModemModeller;
import dan200.computercraft.client.turtle.TurtleUpgradeModellers;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1132;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_326;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_437;
import net.minecraft.class_5253;
import net.minecraft.class_5616;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_6395;
import net.minecraft.class_9282;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.function.IOSupplier;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public final class ClientRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ClientRegistry.class);
    private static final class_2960[] EXTRA_MODELS = new class_2960[]{TurtleOverlay.ELF_MODEL, TurtleBlockEntityRenderer.COLOUR_TURTLE_MODEL};

    private ClientRegistry() {
    }

    public static void register() {
        class_5616.method_32144((class_2591)((class_2591)ModRegistry.BlockEntities.MONITOR_NORMAL.get()), MonitorBlockEntityRenderer::new);
        class_5616.method_32144((class_2591)((class_2591)ModRegistry.BlockEntities.MONITOR_ADVANCED.get()), MonitorBlockEntityRenderer::new);
        class_5616.method_32144((class_2591)((class_2591)ModRegistry.BlockEntities.TURTLE_NORMAL.get()), TurtleBlockEntityRenderer::new);
        class_5616.method_32144((class_2591)((class_2591)ModRegistry.BlockEntities.TURTLE_ADVANCED.get()), TurtleBlockEntityRenderer::new);
        class_5616.method_32144((class_2591)((class_2591)ModRegistry.BlockEntities.LECTERN.get()), CustomLecternRenderer::new);
    }

    public static void registerMainThread(RegisterItemProperty itemProperties) {
        ClientRegistry.registerItemProperty(itemProperties, "state", new UnclampedPropertyFunction((stack, world, player, random) -> {
            PocketComputerData computer = ClientPocketComputers.get(stack);
            return (computer == null ? ComputerState.OFF : computer.getState()).ordinal();
        }), ModRegistry.Items.POCKET_COMPUTER_NORMAL, ModRegistry.Items.POCKET_COMPUTER_ADVANCED);
        ClientRegistry.registerItemProperty(itemProperties, "coloured", (stack, world, player, random) -> class_9282.method_57470((class_1799)stack, (int)-1) != -1 ? 1.0f : 0.0f, ModRegistry.Items.POCKET_COMPUTER_NORMAL, ModRegistry.Items.POCKET_COMPUTER_ADVANCED);
    }

    public static void registerMenuScreens(RegisterMenuScreen register) {
        register.register((class_3917)ModRegistry.Menus.COMPUTER.get(), ComputerScreen::new);
        register.register((class_3917)ModRegistry.Menus.POCKET_COMPUTER_NO_TERM.get(), NoTermComputerScreen::new);
        register.register((class_3917)ModRegistry.Menus.TURTLE.get(), TurtleScreen::new);
        register.register((class_3917)ModRegistry.Menus.PRINTER.get(), PrinterScreen::new);
        register.register((class_3917)ModRegistry.Menus.DISK_DRIVE.get(), DiskDriveScreen::new);
        register.register((class_3917)ModRegistry.Menus.PRINTOUT.get(), PrintoutScreen::new);
    }

    public static void registerTurtleModellers(RegisterTurtleUpgradeModeller register) {
        register.register((UpgradeType)ModRegistry.TurtleUpgradeTypes.SPEAKER.get(), TurtleUpgradeModeller.sided(class_2960.method_60655((String)"computercraft", (String)"block/turtle_speaker_left"), class_2960.method_60655((String)"computercraft", (String)"block/turtle_speaker_right")));
        register.register((UpgradeType)ModRegistry.TurtleUpgradeTypes.WORKBENCH.get(), TurtleUpgradeModeller.sided(class_2960.method_60655((String)"computercraft", (String)"block/turtle_crafting_table_left"), class_2960.method_60655((String)"computercraft", (String)"block/turtle_crafting_table_right")));
        register.register((UpgradeType)ModRegistry.TurtleUpgradeTypes.WIRELESS_MODEM.get(), new TurtleModemModeller());
        register.register((UpgradeType)ModRegistry.TurtleUpgradeTypes.TOOL.get(), TurtleUpgradeModeller.flatItem());
    }

    @SafeVarargs
    private static void registerItemProperty(RegisterItemProperty itemProperties, String name, class_6395 getter, Supplier<? extends class_1792> ... items) {
        class_2960 id = class_2960.method_60655((String)"computercraft", (String)name);
        for (Supplier<? extends class_1792> item : items) {
            itemProperties.register(item.get(), id, getter);
        }
    }

    public static void registerExtraModels(Consumer<class_2960> register, Collection<class_2960> extraModels) {
        for (class_2960 model : EXTRA_MODELS) {
            register.accept(model);
        }
        extraModels.forEach(register);
        TurtleUpgradeModellers.getDependencies().forEach(register);
    }

    public static void registerItemColours(BiConsumer<class_326, class_1935> register) {
        register.accept((stack, layer) -> layer == 1 ? class_9282.method_57470((class_1799)stack, (int)Colour.WHITE.getARGB()) : -1, (class_1935)ModRegistry.Items.DISK.get());
        register.accept((stack, layer) -> layer == 1 ? class_9282.method_57470((class_1799)stack, (int)Colour.BLUE.getARGB()) : -1, (class_1935)ModRegistry.Items.TREASURE_DISK.get());
        register.accept(ClientRegistry::getPocketColour, (class_1935)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get());
        register.accept(ClientRegistry::getPocketColour, (class_1935)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get());
        register.accept(ClientRegistry::getTurtleColour, (class_1935)ModRegistry.Blocks.TURTLE_NORMAL.get());
        register.accept(ClientRegistry::getTurtleColour, (class_1935)ModRegistry.Blocks.TURTLE_ADVANCED.get());
    }

    private static int getPocketColour(class_1799 stack, int layer) {
        return switch (layer) {
            default -> -1;
            case 1 -> class_9282.method_57470((class_1799)stack, (int)-1);
            case 2 -> {
                PocketComputerData computer = ClientPocketComputers.get(stack);
                if (computer == null || computer.getLightState() == -1) {
                    yield Colour.BLACK.getARGB();
                }
                yield class_5253.class_5254.method_57174((int)computer.getLightState());
            }
        };
    }

    private static int getTurtleColour(class_1799 stack, int layer) {
        return layer == 0 ? class_9282.method_57470((class_1799)stack, (int)-1) : -1;
    }

    public static void registerShaders(class_5912 resources, BiConsumer<class_5944, Consumer<class_5944>> load) throws IOException {
        RenderTypes.registerShaders(resources, (String name, IOSupplier<class_5944> create, Consumer<class_5944> onLoaded) -> {
            class_5944 shader;
            try {
                shader = (class_5944)create.get();
            }
            catch (Exception e) {
                LOG.error("Failed to load {}", (Object)name, (Object)e);
                onLoaded.accept(null);
                return;
            }
            load.accept(shader, onLoaded);
        });
    }

    public static <T> void registerClientCommands(CommandDispatcher<T> dispatcher, BiConsumer<T, class_2561> sendError) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"computercraft-computer-folder").requires(x -> class_310.method_1551().method_1576() != null)).then(RequiredArgumentBuilder.argument((String)"computer_id", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> ClientRegistry.handleOpenComputerCommand(c.getSource(), sendError, (Integer)c.getArgument("computer_id", Integer.class)))));
    }

    private static <T> int handleOpenComputerCommand(T context, BiConsumer<T, class_2561> sendError, int id) {
        class_1132 server = class_310.method_1551().method_1576();
        if (server == null) {
            sendError.accept(context, (class_2561)class_2561.method_43470((String)"Not on a single-player server"));
            return 0;
        }
        File file = new File(ServerContext.get((MinecraftServer)server).storageDir().toFile(), "computer/" + id);
        if (!file.isDirectory()) {
            sendError.accept(context, (class_2561)class_2561.method_43470((String)"Computer's folder does not exist"));
            return 0;
        }
        class_156.method_668().method_672(file);
        return 1;
    }

    @Environment(value=EnvType.CLIENT)
    private record UnclampedPropertyFunction(class_6395 function) implements class_6395
    {
        public float unclampedCall(class_1799 stack, @Nullable class_638 level, @Nullable class_1309 entity, int layer) {
            return this.function.unclampedCall(stack, level, entity, layer);
        }

        @Deprecated
        public float call(class_1799 stack, @Nullable class_638 level, @Nullable class_1309 entity, int layer) {
            return this.function.unclampedCall(stack, level, entity, layer);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface RegisterItemProperty {
        public void register(class_1792 var1, class_2960 var2, class_6395 var3);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface RegisterMenuScreen {
        public <M extends class_1703, U extends class_437> void register(class_3917<? extends M> var1, class_3929.class_3930<M, U> var2);
    }
}

