/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.menu;

import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.library.blockentity.SkinLibraryBlockEntity;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class SkinLibraryMenu
extends AbstractBlockEntityMenu<SkinLibraryBlockEntity> {
    protected final class_1263 inventory = ((SkinLibraryBlockEntity)this.blockEntity).getInventory();
    protected final class_1661 playerInventory;
    public int inventoryWidth = 162;
    public int inventoryHeight = 76;
    private int libraryVersion = 0;

    public SkinLibraryMenu(class_3917<?> menuType, class_2248 block, int containerId, class_1661 playerInventory, IGlobalPos access) {
        super((class_3917)menuType, block, containerId, access);
        this.playerInventory = playerInventory;
        this.reload(0, 0, 240, 240);
    }

    public void reload(int x, int y, int width, int height) {
        int inventoryX = 6;
        int inventoryY = height - this.inventoryHeight - 4;
        this.field_7761.clear();
        this.addPlayerSlots((class_1263)this.playerInventory, inventoryX, inventoryY);
        this.addInputSlot(this.inventory, 0, inventoryX, inventoryY - 27);
        this.addOutputSlot(this.inventory, 1, inventoryX + this.inventoryWidth - 22, inventoryY - 27);
    }

    public void method_7623() {
        SkinLibraryManager.Server server;
        super.method_7623();
        if (this.playerInventory.field_7546 instanceof class_3222 && this.libraryVersion != (server = SkinLibraryManager.getServer()).version()) {
            server.sendTo((class_3222)this.playerInventory.field_7546);
            this.libraryVersion = server.version();
        }
    }

    @Override
    public class_1799 method_7601(class_1657 player, int index) {
        return this.quickMoveStack(player, index, this.field_7761.size() - 1);
    }

    protected void addInputSlot(class_1263 inventory, int slot, int x, int y) {
        this.method_7621(new class_1735(this, inventory, slot, x, y){

            public boolean method_7680(class_1799 itemStack) {
                return itemStack.method_31574((class_1792)ModItems.SKIN_TEMPLATE.get()) || !SkinDescriptor.of(itemStack).isEmpty();
            }
        });
    }

    protected void addOutputSlot(class_1263 inventory, int slot, int x, int y) {
        this.method_7621(new class_1735(this, inventory, slot, x, y){

            public boolean method_7680(class_1799 itemStack) {
                return false;
            }
        });
    }

    public class_1799 inputStack() {
        return this.inventory.method_5438(0);
    }

    public class_1799 outputStack() {
        return this.inventory.method_5438(1);
    }

    public class_1657 player() {
        return this.playerInventory.field_7546;
    }

    public boolean shouldSaveStack() {
        return this.outputStack().method_7960();
    }

    public boolean shouldLoadStack() {
        return this.outputStack().method_7960() && !this.inputStack().method_7960() && this.inputStack().method_31574((class_1792)ModItems.SKIN_TEMPLATE.get());
    }

    public void crafting(SkinDescriptor descriptor) {
        boolean consume = true;
        class_1799 itemStack = this.inputStack();
        class_1799 newItemStack = itemStack.method_7972();
        if (descriptor != null) {
            newItemStack = this.create(newItemStack, descriptor);
            consume = itemStack.method_31574((class_1792)ModItems.SKIN_TEMPLATE.get());
        }
        this.inventory.method_5447(1, newItemStack);
        if (consume) {
            itemStack.method_7934(1);
        }
    }

    private class_1799 create(class_1799 targetStack, SkinDescriptor descriptor) {
        if (targetStack.method_7960()) {
            return descriptor.asItemStack();
        }
        if (targetStack.method_31574((class_1792)ModItems.SKIN_TEMPLATE.get())) {
            return descriptor.asItemStack();
        }
        if (descriptor.isEmpty()) {
            ComponentAPI.remove(targetStack, (IDataComponentType)ModDataComponents.SKIN.get());
        } else {
            ComponentAPI.set(targetStack, (IDataComponentType)ModDataComponents.SKIN.get(), descriptor);
        }
        return targetStack;
    }
}

