/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.data.impl;

import com.google.gson.JsonParseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.core.IResultHandler;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IODataObject;
import moe.plushie.armourers_workshop.core.utils.Executors;
import moe.plushie.armourers_workshop.core.utils.JsonSerializer;
import moe.plushie.armourers_workshop.core.utils.StreamUtils;
import moe.plushie.armourers_workshop.library.data.impl.ServerPermission;
import moe.plushie.armourers_workshop.library.data.impl.ServerRequest;
import moe.plushie.armourers_workshop.library.data.impl.ServerResponse;
import org.jetbrains.annotations.Nullable;

public abstract class ServerSession {
    private static final ExecutorService workThread = Executors.newFixedThreadPool(1, "AW-SKIN-NT");
    private static final ArrayList<String> DEFAULT_URLs = new ArrayList();
    private static final Map<String, ServerRequest> REQUESTS = new HashMap<String, ServerRequest>();
    protected Executor notifier = Runnable::run;

    protected <T> void request(String path, @Nullable Map<String, ?> parameters, Function<IODataObject, T> deserializer, IResultHandler<T> handlerIn) {
        this.submit(handlerIn, handlerOut -> {
            try {
                Object value = this.request(path, parameters, deserializer);
                handlerOut.accept(value);
            }
            catch (Exception exception1) {
                handlerOut.abort(exception1);
            }
        });
    }

    protected <T> T request(String path, @Nullable Map<String, ?> parameters, Function<IODataObject, T> deserializer) throws Exception {
        try {
            Callable<InputStream> task = this.buildTask(path, parameters);
            byte[] bytes = StreamUtils.readStreamToByteArray(task.call());
            IODataObject responseData = this.parse(bytes);
            ServerResponse response = new ServerResponse(responseData);
            if (!response.isValid()) {
                throw new RuntimeException("a invalid response of the " + path);
            }
            if (deserializer == null) {
                return null;
            }
            return deserializer.apply(responseData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    protected Callable<InputStream> buildTask(String path, @Nullable Map<String, ?> parameters) throws Exception {
        ServerRequest request = this.loadAPI(path);
        this.checkRequest(request, parameters);
        return request.build(this.buildRequestURL(request), this.m2m(parameters));
    }

    protected String buildRequestURL(ServerRequest request) {
        if (request.isSSLRequired()) {
            for (String baseURL : this.baseURLs()) {
                if (!baseURL.startsWith("https://")) continue;
                return baseURL;
            }
        }
        return this.defaultBaseURL();
    }

    protected void checkRequest(ServerRequest request, @Nullable Map<String, ?> parameters) throws Exception {
    }

    protected String defaultBaseURL() {
        ArrayList<String> baseURLs = this.baseURLs();
        if (!baseURLs.isEmpty()) {
            return baseURLs.get(0);
        }
        return "";
    }

    protected ArrayList<String> baseURLs() {
        if (DEFAULT_URLs.isEmpty()) {
            try {
                this.loadAPIs();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return DEFAULT_URLs;
    }

    protected HashMap<String, Object> defaultParameters() {
        return new HashMap<String, Object>();
    }

    protected <T> void submit(IResultHandler<T> handler, Consumer<IResultHandler<T>> task) {
        workThread.submit(() -> task.accept((result, exception) -> this.notify(() -> handler.apply(result, exception))));
    }

    private void notify(Runnable handler) {
        this.notifier.execute(handler);
    }

    private ServerRequest loadAPI(String path) throws Exception {
        ServerRequest request = this.loadAPIs().get(path);
        if (request != null) {
            return request;
        }
        throw new RuntimeException("missing request from " + path);
    }

    private Map<String, ServerRequest> loadAPIs() throws IOException {
        if (!REQUESTS.isEmpty()) {
            return REQUESTS;
        }
        InputStream inputStream = this.getClass().getResourceAsStream("/data/armourers_workshop/skin/library/gsl.json");
        IODataObject root = JsonSerializer.readFromStream(inputStream);
        IODataObject server = root.get("server");
        server.entrySet().forEach(it -> {
            if (((String)it.getKey()).equals("/host")) {
                ((IODataObject)it.getValue()).allValues().forEach(url -> DEFAULT_URLs.add(url.stringValue()));
                return;
            }
            ServerRequest req = ServerRequest.fromJSON((IODataObject)it.getValue());
            if (req != null) {
                req.setPermission(ServerPermission.byId((String)it.getKey()));
                REQUESTS.put((String)it.getKey(), req);
            }
        });
        return REQUESTS;
    }

    private IODataObject parse(byte[] bytes) throws IOException {
        try {
            return JsonSerializer.readFromStream(new ByteArrayInputStream(bytes));
        }
        catch (JsonParseException exception) {
            throw new IOException(new String(bytes, StandardCharsets.UTF_8));
        }
    }

    private Map<String, Object> m2m(Map<String, ?> m) {
        HashMap<String, Object> map = this.defaultParameters();
        if (m != null) {
            map.putAll(m);
        }
        return map;
    }
}

