/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.data.impl;

public enum ServerPermission {
    GET_RECENTLY_UPLOADED,
    GET_MOST_LIKED,
    GET_MOST_DOWNLOADED,
    BETA_JOIN("/user/join", true),
    BETA_CHECK("/connect"),
    SKIN_SEARCH("/skin/search"),
    SKIN_LIST_USER("/skin/user"),
    SKIN_DOWNLOAD("/skin/download"),
    USER_INFO("/user/info"),
    SERVER_VIEW_STATS("/stats"),
    GET_SKIN_INFO("/skin/info"),
    SKIN_UPLOAD("/skin/upload", true),
    SKIN_RATE("/skin/rate", true),
    SKIN_GET_RATED("/skin/rating", true),
    SKIN_REPORT("/skin/report", true),
    SKIN_OWNER_DELETE("/skin/delete", true),
    SKIN_OWNER_EDIT("/skin/edit", true),
    SKIN_COMMENT_CREATE,
    SKIN_COMMENT_OWNER_DELETE,
    SKIN_COMMENT_OWNER_EDIT,
    GET_REPORT_LIST("/skin/reports", true),
    SKIN_MOD_DELETE,
    SKIN_MOD_EDIT,
    SKIN_COMMENT_MOD_DELETE,
    SKIN_COMMENT_MOD_EDIT,
    FLAG_GET_LIST,
    FLAG_DELETE,
    USER_BAN_TEMP,
    USER_BAN_PERM,
    USER_GROUP_CHANGE;

    private final String id;
    private final boolean isSSLRequired;

    private ServerPermission(String id, boolean isSSLRequired) {
        this.id = id;
        this.isSSLRequired = isSSLRequired;
    }

    private ServerPermission(String id) {
        this(id, false);
    }

    private ServerPermission() {
        this(null, false);
    }

    public static ServerPermission byId(String id) {
        for (ServerPermission permission : ServerPermission.values()) {
            if (permission.id == null || !permission.id.equals(id)) continue;
            return permission;
        }
        return null;
    }

    public boolean isSSLRequired() {
        return this.isSSLRequired;
    }
}

