/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.panels;

import com.apple.library.foundation.NSString;
import moe.plushie.armourers_workshop.api.core.IResultHandler;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.GlobalSkinLibraryWindow;
import moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.panels.SearchResultsLibraryPanel;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.data.impl.SearchResult;
import moe.plushie.armourers_workshop.library.data.impl.ServerSkin;
import moe.plushie.armourers_workshop.library.data.impl.ServerUser;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UserSkinsLibraryPanel
extends SearchResultsLibraryPanel {
    private ServerUser user;

    public UserSkinsLibraryPanel() {
        super("skin-library-global.searchResults", GlobalSkinLibraryWindow.Page.LIST_USER_SKINS::equals);
    }

    public void reloadData(ServerUser user) {
        this.clearResults();
        this.user = user;
        this.fetchPage(0);
    }

    @Override
    protected void showSkinInfo(ServerSkin sender) {
        this.router.showSkinDetail(sender, GlobalSkinLibraryWindow.Page.LIST_USER_SKINS);
    }

    @Override
    protected void doSearch(int pageIndex, int pageSize, SkinType searchType, IResultHandler<SearchResult> handler) {
        GlobalSkinLibrary.getInstance().getUserSkinList(this.user.id(), pageIndex, pageSize, searchType, handler);
    }

    @Override
    protected NSString resultsTitle() {
        if (this.totalPages < 0) {
            return this.getDisplayText("label.searching", new Object[0]);
        }
        if (this.totalPages == 0) {
            return this.getDisplayText("label.no_results", new Object[0]);
        }
        String username = "unknown";
        if (this.user != null && !this.user.name().isEmpty()) {
            username = this.user.name();
        }
        return this.getDisplayText("user_results", username, this.currentPage + 1, this.totalPages, this.totalResults);
    }
}

