/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import java.util.ArrayList;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.core.data.slot.ItemMatcher;
import net.minecraft.class_1799;

public class ModItemMatchers {
    public static final ItemMatcher SWORDS = MatcherBuilder.of().match("sword").match("machete").match("gladius").match("falchion").match("saber").match("dagger").match("cullass").match("rapier").match("claymore").match("flamberge").match("zweihander").match("dao").match("jian").match("odachi").match("tachi").match("wakizashi").match("katana").match("chokuto").match("ninjato").match("scimitar").match("shamshir").build();
    public static final ItemMatcher TRIDENTS = MatcherBuilder.of().match("trident").match("lance").match("halbred").match("spear").build();
    public static final ItemMatcher SHIELDS = MatcherBuilder.of().match("shield").build();
    public static final ItemMatcher BOWS = MatcherBuilder.of().match("bow").nonMatch("bowl").build();
    public static final ItemMatcher PICKAXES = MatcherBuilder.of().match("pickaxe").build();
    public static final ItemMatcher AXES = MatcherBuilder.of().match("axe").nonMatch("pickaxe").nonMatch("waxed").build();
    public static final ItemMatcher SHOVELS = MatcherBuilder.of().match("shovel").build();
    public static final ItemMatcher HOES = MatcherBuilder.of().match("hoe").build();

    private static class MatcherBuilder {
        private final StringBuffer mathBuffer = new StringBuffer();
        private final StringBuffer nonMathBuffer = new StringBuffer();
        private final ArrayList<String> whitelist = new ArrayList();
        private final ArrayList<String> blacklist = new ArrayList();
        private Predicate<class_1799> requirements;

        private MatcherBuilder() {
        }

        private static MatcherBuilder of() {
            return new MatcherBuilder();
        }

        private MatcherBuilder match(String tag) {
            if (this.mathBuffer.length() != 0) {
                this.mathBuffer.append("|");
            }
            this.mathBuffer.append(tag);
            return this;
        }

        private MatcherBuilder nonMatch(String tag) {
            if (this.nonMathBuffer.length() != 0) {
                this.nonMathBuffer.append("|");
            }
            this.nonMathBuffer.append(tag);
            return this;
        }

        private MatcherBuilder add(String tag) {
            this.whitelist.add(tag);
            return this;
        }

        private MatcherBuilder remove(String tag) {
            this.blacklist.add(tag);
            return this;
        }

        private ItemMatcher build() {
            return new ItemMatcher(this.mathBuffer.toString(), this.nonMathBuffer.toString(), this.whitelist, this.blacklist, this.requirements);
        }
    }
}

