/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.texture;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import moe.plushie.armourers_workshop.core.math.OpenRectangle2f;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenVector2i;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import org.jetbrains.annotations.Nullable;

public class EntityTextureModel {
    public static final int TEXTURE_WIDTH = 64;
    public static final int TEXTURE_HEIGHT = 64;
    public static final int TEXTURE_SIZE = 4096;
    public static final int TEXTURE_OLD_WIDTH = 64;
    public static final int TEXTURE_OLD_HEIGHT = 32;
    public static final int TEXTURE_OLD_SIZE = 2048;
    public static final EntityTextureModel STAVE_V1 = new EntityTextureModel((Map<SkinPartType, Box>)Collections.immutableMap(it -> {
        it.put((Object)SkinPartTypes.BIPPED_HAT, (Object)new Box(-4, -8, -4, 8, 8, 8, 32, 0));
        it.put((Object)SkinPartTypes.BIPPED_HEAD, (Object)new Box(-4, -8, -4, 8, 8, 8, 0, 0));
        it.put((Object)SkinPartTypes.BIPPED_CHEST, (Object)new Box(-4, 0, -2, 8, 12, 4, 16, 16));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_THIGH, (Object)new Box(-2, 0, -2, 4, 12, 4, 0, 16));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_THIGH, (Object)new Box(-2, 0, -2, 4, 12, 4, 0, 16, true));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_ARM, (Object)new Box(-3, -2, -2, 4, 12, 4, 40, 16));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_ARM, (Object)new Box(-1, -2, -2, 4, 12, 4, 40, 16, true));
    }));
    public static final EntityTextureModel STAVE_V2 = new EntityTextureModel((Map<SkinPartType, Box>)Collections.immutableMap(it -> {
        it.put((Object)SkinPartTypes.BIPPED_HAT, (Object)new Box(-4, -8, -4, 8, 8, 8, 32, 0));
        it.put((Object)SkinPartTypes.BIPPED_HEAD, (Object)new Box(-4, -8, -4, 8, 8, 8, 0, 0));
        it.put((Object)SkinPartTypes.BIPPED_CHEST, (Object)new Box(-4, 0, -2, 8, 12, 4, 16, 16));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_THIGH, (Object)new Box(-2, 0, -2, 4, 12, 4, 0, 16));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_THIGH, (Object)new Box(-2, 0, -2, 4, 12, 4, 16, 48));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_ARM, (Object)new Box(-3, -2, -2, 4, 12, 4, 40, 16));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_ARM, (Object)new Box(-1, -2, -2, 4, 12, 4, 32, 48));
    }));
    public static final EntityTextureModel ALEX_V1 = new EntityTextureModel((Map<SkinPartType, Box>)Collections.immutableMap(it -> {
        it.put((Object)SkinPartTypes.BIPPED_HAT, (Object)new Box(-4, -8, -4, 8, 8, 8, 32, 0));
        it.put((Object)SkinPartTypes.BIPPED_HEAD, (Object)new Box(-4, -8, -4, 8, 8, 8, 0, 0));
        it.put((Object)SkinPartTypes.BIPPED_CHEST, (Object)new Box(-4, 0, -2, 8, 12, 4, 16, 16));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_THIGH, (Object)new Box(-2, 0, -2, 4, 12, 4, 0, 16));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_THIGH, (Object)new Box(-2, 0, -2, 4, 12, 4, 0, 16, true));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_ARM, (Object)new Box(-2, -2, -2, 3, 12, 4, 40, 16));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_ARM, (Object)new Box(-1, -2, -2, 3, 12, 4, 40, 16, true));
    }));
    public static final EntityTextureModel ALEX_V2 = new EntityTextureModel((Map<SkinPartType, Box>)Collections.immutableMap(it -> {
        it.put((Object)SkinPartTypes.BIPPED_HAT, (Object)new Box(-4, -8, -4, 8, 8, 8, 32, 0));
        it.put((Object)SkinPartTypes.BIPPED_HEAD, (Object)new Box(-4, -8, -4, 8, 8, 8, 0, 0));
        it.put((Object)SkinPartTypes.BIPPED_CHEST, (Object)new Box(-4, 0, -2, 8, 12, 4, 16, 16));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_THIGH, (Object)new Box(-2, 0, -2, 4, 12, 4, 0, 16));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_THIGH, (Object)new Box(-2, 0, -2, 4, 12, 4, 16, 48));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_ARM, (Object)new Box(-2, -2, -2, 3, 12, 4, 40, 16));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_ARM, (Object)new Box(-1, -2, -2, 3, 12, 4, 32, 48));
    }));
    protected final Map<SkinPartType, Box> skyBoxes;

    public EntityTextureModel(Map<SkinPartType, Box> skyBoxes) {
        this.skyBoxes = skyBoxes;
    }

    public static EntityTextureModel of(int width, int height, boolean slim) {
        if (slim) {
            if (height <= 32) {
                return ALEX_V1;
            }
            return ALEX_V2;
        }
        if (height <= 32) {
            return STAVE_V1;
        }
        return STAVE_V2;
    }

    public Box get(SkinPartType partType) {
        if (partType == SkinPartTypes.BIPPED_LEFT_FOOT) {
            return this.get(SkinPartTypes.BIPPED_LEFT_THIGH);
        }
        if (partType == SkinPartTypes.BIPPED_RIGHT_FOOT) {
            return this.get(SkinPartTypes.BIPPED_RIGHT_THIGH);
        }
        return this.skyBoxes.get(partType);
    }

    public OpenVector2i get(SkinPartType partType, int x, int y, int z, OpenDirection dir) {
        Box box = this.get(partType);
        if (box != null) {
            return box.get(x, y, z, dir);
        }
        return null;
    }

    public void forEach(BiConsumer<SkinPartType, Box> consumer) {
        this.skyBoxes.forEach(consumer);
    }

    public Set<Map.Entry<SkinPartType, Box>> entrySet() {
        return this.skyBoxes.entrySet();
    }

    public static class Box {
        protected final EnumMap<OpenDirection, ToIntFunction<OpenVector3i>> validator = new EnumMap(OpenDirection.class);
        protected final EnumMap<OpenDirection, Function<OpenVector3i, OpenVector2i>> evaluator = new EnumMap(OpenDirection.class);
        protected final OpenRectangle3i rect;
        protected final OpenRectangle2f textureRect;
        protected final boolean mirror;

        public Box(int x, int y, int z, int width, int height, int depth, int u, int v) {
            this(x, y, z, width, height, depth, u, v, false);
        }

        public Box(int x, int y, int z, int width, int height, int depth, int u, int v, boolean mirror) {
            this.mirror = mirror;
            this.rect = new OpenRectangle3i(x, y, z, width, height, depth);
            this.textureRect = new OpenRectangle2f(u, v, depth + width + depth + width, depth + height);
            this.put(OpenDirection.UP, this.positiveX(u + depth), this.negativeZ(v + depth - 1));
            this.put(OpenDirection.DOWN, this.positiveX(u + depth + width), this.negativeZ(v + depth - 1));
            this.put(OpenDirection.NORTH, this.positiveX(u + depth), this.positiveY(v + depth));
            this.put(OpenDirection.SOUTH, this.negativeX(u + depth + width + depth + width - 1), this.positiveY(v + depth));
            this.put(OpenDirection.WEST, this.positiveZ(u + depth + width), this.positiveY(v + depth));
            this.put(OpenDirection.EAST, this.negativeZ(u + depth - 1), this.positiveY(v + depth));
            this.valid(OpenDirection.UP, this.negativeY(0));
            this.valid(OpenDirection.DOWN, this.negativeY(height - 1));
            this.valid(OpenDirection.NORTH, this.negativeZ(0));
            this.valid(OpenDirection.SOUTH, this.negativeZ(depth - 1));
            this.valid(OpenDirection.WEST, this.negativeX(width - 1));
            this.valid(OpenDirection.EAST, this.negativeX(0));
        }

        protected void valid(OpenDirection dir, ToIntFunction<OpenVector3i> diff) {
            this.validator.put(this.getMirroredDirection(dir), diff);
        }

        protected void put(OpenDirection dir, ToIntFunction<OpenVector3i> uf, ToIntFunction<OpenVector3i> vf) {
            this.evaluator.put(this.getMirroredDirection(dir), pos -> new OpenVector2i(uf.applyAsInt((OpenVector3i)pos), vf.applyAsInt((OpenVector3i)pos)));
        }

        public void forEach(IPixelConsumer consumer) {
            for (OpenDirection dir : OpenDirection.values()) {
                for (int ix = this.rect.minX(); ix < this.rect.maxX(); ++ix) {
                    for (int iy = this.rect.minY(); iy < this.rect.maxY(); ++iy) {
                        for (int iz = this.rect.minZ(); iz < this.rect.maxZ(); ++iz) {
                            OpenVector2i texture = this.get(ix, iy, iz, dir);
                            if (texture == null) continue;
                            consumer.accept(texture, ix, iy, iz, dir);
                        }
                    }
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Box)) {
                return false;
            }
            Box that = (Box)o;
            return this.mirror == that.mirror && this.rect.equals(that.rect) && this.textureRect.equals(that.textureRect);
        }

        public int hashCode() {
            return Objects.hash(this.rect, this.textureRect, this.mirror);
        }

        @Nullable
        public OpenVector2i get(int x, int y, int z, OpenDirection dir) {
            if (this.isInside(x -= this.rect.x(), y -= this.rect.y(), z -= this.rect.z())) {
                ToIntFunction<OpenVector3i> predicate = this.validator.get(dir);
                Function<OpenVector3i, OpenVector2i> eval = this.evaluator.get(dir);
                OpenVector3i pos = new OpenVector3i(x, y, z);
                if (eval != null && predicate.applyAsInt(pos) == 0) {
                    return eval.apply(pos);
                }
            }
            return null;
        }

        public OpenRectangle3i bounds() {
            return this.rect;
        }

        public boolean mirror() {
            return this.mirror;
        }

        private boolean isInside(int x, int y, int z) {
            return x >= 0 && x < this.rect.width() && y >= 0 && y < this.rect.height() && z >= 0 && z < this.rect.depth();
        }

        private OpenDirection getMirroredDirection(OpenDirection direction) {
            if (this.mirror && direction.axis() == OpenDirection.Axis.X) {
                return direction.opposite();
            }
            return direction;
        }

        private ToIntFunction<OpenVector3i> positiveX(int t) {
            if (this.mirror) {
                return pos -> t + (this.rect.width() - pos.x() - 1);
            }
            return pos -> t + pos.x();
        }

        private ToIntFunction<OpenVector3i> positiveY(int t) {
            return pos -> t + pos.y();
        }

        private ToIntFunction<OpenVector3i> positiveZ(int t) {
            return pos -> t + pos.z();
        }

        private ToIntFunction<OpenVector3i> negativeX(int t) {
            if (this.mirror) {
                return pos -> t - (this.rect.width() - pos.x() - 1);
            }
            return pos -> t - pos.x();
        }

        private ToIntFunction<OpenVector3i> negativeY(int t) {
            return pos -> t - pos.y();
        }

        private ToIntFunction<OpenVector3i> negativeZ(int t) {
            return pos -> t - pos.z();
        }

        public static interface IPixelConsumer {
            public void accept(OpenVector2i var1, int var2, int var3, int var4, OpenDirection var5);
        }
    }
}

