/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimation;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationFunction;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationKeyframe;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationLoop;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationPoint;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFile;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkParticleData;
import moe.plushie.armourers_workshop.core.skin.sound.SkinSoundData;
import moe.plushie.armourers_workshop.core.skin.sound.SkinSoundProperties;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;

public class ChunkAnimationData {
    private final List<SkinAnimation> animations;

    public ChunkAnimationData(List<SkinAnimation> animations) {
        this.animations = animations;
    }

    public List<SkinAnimation> animations() {
        return this.animations;
    }

    public void readFromStream(ChunkInputStream stream) throws IOException {
        if (stream.fileVersion() < 22) {
            this.animations.addAll(LegacyHelperV20.readFromStream(stream));
            return;
        }
        int animationCount = stream.readVarInt();
        for (int i = 0; i < animationCount; ++i) {
            String name = stream.readString();
            float duration = stream.readFloat();
            SkinAnimationLoop loop = stream.readEnum(SkinAnimationLoop.class);
            Map<String, List<SkinAnimationKeyframe>> keyframes = this.readKeyframesFromStream(stream);
            this.animations.add(new SkinAnimation(name, duration, loop, keyframes));
        }
    }

    public void writeToStream(ChunkOutputStream stream) throws IOException {
        stream.writeVarInt(this.animations.size());
        for (SkinAnimation animation : this.animations) {
            stream.writeString(animation.name());
            stream.writeFloat(animation.duration());
            stream.writeEnum(animation.loop());
            this.writeKeyframesToStream(animation.keyframes(), stream);
        }
    }

    private Map<String, List<SkinAnimationKeyframe>> readKeyframesFromStream(ChunkInputStream stream) throws IOException {
        String channel;
        LinkedHashMap<String, List<SkinAnimationKeyframe>> keyframes = new LinkedHashMap<String, List<SkinAnimationKeyframe>>();
        while (!(channel = stream.readString()).isEmpty()) {
            String bone;
            while (!(bone = stream.readString()).isEmpty()) {
                SkinAnimationKeyframe keyframe;
                while ((keyframe = this.readKeyframeFromStream(channel, stream)) != null) {
                    keyframes.computeIfAbsent(bone, it -> new ArrayList()).add(keyframe);
                }
            }
        }
        return keyframes;
    }

    private void writeKeyframesToStream(Map<String, List<SkinAnimationKeyframe>> keyframes, ChunkOutputStream stream) throws IOException {
        LinkedHashMap<String, Map> sortedKeyframes = new LinkedHashMap<String, Map>();
        for (Map.Entry<String, List<SkinAnimationKeyframe>> entry : keyframes.entrySet()) {
            String bone = entry.getKey();
            for (SkinAnimationKeyframe skinAnimationKeyframe : entry.getValue()) {
                String channel = skinAnimationKeyframe.key();
                sortedKeyframes.computeIfAbsent(channel, it -> new LinkedHashMap()).computeIfAbsent(bone, it -> new ArrayList()).add(skinAnimationKeyframe);
            }
        }
        for (Map.Entry<String, List<SkinAnimationKeyframe>> entry : sortedKeyframes.entrySet()) {
            String channel = entry.getKey();
            stream.writeString(channel);
            for (Map.Entry entry2 : ((Map)((Object)entry.getValue())).entrySet()) {
                String bone = (String)entry2.getKey();
                stream.writeString(bone);
                for (SkinAnimationKeyframe keyframe : (List)entry2.getValue()) {
                    this.writeKeyframeToStream(keyframe, channel, stream);
                }
                this.writeKeyframeToStream(null, null, stream);
            }
            stream.writeString("");
        }
        stream.writeString("");
    }

    private SkinAnimationKeyframe readKeyframeFromStream(String channel, ChunkInputStream stream) throws IOException {
        int pointCount = stream.readVarInt();
        if (pointCount == 0) {
            return null;
        }
        float time = stream.readFloat();
        SkinAnimationFunction function = SkinAnimationFunction.readFromStream(stream);
        ArrayList<SkinAnimationPoint> points = new ArrayList<SkinAnimationPoint>();
        for (int i = 1; i < pointCount; ++i) {
            int type = stream.readVarInt();
            PointSerializer<?> serializer = PointSerializer.byType(type);
            if (serializer == null) {
                throw new IOException("can't read animation point of type: " + type);
            }
            points.add((SkinAnimationPoint)serializer.readFromStream(stream));
        }
        return new SkinAnimationKeyframe(time, channel, function, points);
    }

    private void writeKeyframeToStream(SkinAnimationKeyframe keyframe, String channel, ChunkOutputStream stream) throws IOException {
        if (keyframe == null || channel == null) {
            stream.writeVarInt(0);
            return;
        }
        stream.writeVarInt(keyframe.points().size() + 1);
        stream.writeFloat(keyframe.time());
        keyframe.function().writeToStream(stream);
        for (SkinAnimationPoint point : keyframe.points()) {
            PointSerializer<?> serializer = PointSerializer.byValue(point);
            if (serializer == null) {
                throw new IOException("can't write animation point: " + String.valueOf(point));
            }
            stream.writeVarInt(serializer.type);
            serializer.writeToStream((SkinAnimationPoint)Objects.unsafeCast(point), stream);
        }
    }

    private static class LegacyHelperV20 {
        private LegacyHelperV20() {
        }

        private static List<SkinAnimation> readFromStream(ChunkInputStream stream) throws IOException {
            ArrayList<SkinAnimation> results = new ArrayList<SkinAnimation>();
            int count = stream.readVarInt();
            for (int i = 0; i < count; ++i) {
                SkinAnimation animation = LegacyHelperV20.readAnimationFromStream(stream);
                results.add(animation);
            }
            return results;
        }

        private static SkinAnimation readAnimationFromStream(ChunkInputStream stream) throws IOException {
            int count;
            String id = stream.readString();
            float duration = stream.readFloat();
            SkinAnimationLoop loop = stream.readEnum(SkinAnimationLoop.class);
            LinkedHashMap<String, List<SkinAnimationKeyframe>> keyframes = new LinkedHashMap<String, List<SkinAnimationKeyframe>>();
            while ((count = stream.readVarInt()) != 0) {
                String bone = stream.readString();
                String channel = stream.readString();
                for (int i = 0; i < count; ++i) {
                    SkinAnimationKeyframe keyframe = LegacyHelperV20.readKeyframeFromStream(channel, stream);
                    keyframes.computeIfAbsent(bone, k -> new ArrayList()).add(keyframe);
                }
            }
            return new SkinAnimation(id, duration, loop, keyframes);
        }

        private static SkinAnimationKeyframe readKeyframeFromStream(String key, ChunkInputStream stream) throws IOException {
            float time = stream.readFloat();
            SkinAnimationFunction function = SkinAnimationFunction.readFromStream(stream);
            ArrayList<SkinAnimationPoint> points = new ArrayList<SkinAnimationPoint>();
            int type = stream.readVarInt();
            if (type == 3 || type == 6) {
                points.addAll(LegacyHelperV20.readKeyframePointsFromStream(type, stream));
                type = 0;
            }
            while (type != 0) {
                PointSerializer<?> serializer = PointSerializer.byType(type);
                if (serializer == null) {
                    throw new IOException("can't read animation point of type: " + type);
                }
                points.add((SkinAnimationPoint)serializer.readFromStream(stream));
                type = stream.readVarInt();
            }
            return new SkinAnimationKeyframe(time, key, function, points);
        }

        private static List<SkinAnimationPoint> readKeyframePointsFromStream(int length, ChunkInputStream stream) throws IOException {
            int i;
            ArrayList<SkinAnimationPoint> points = new ArrayList<SkinAnimationPoint>();
            ArrayList<OpenPrimitive> objects = new ArrayList<OpenPrimitive>();
            for (i = 0; i < length; ++i) {
                int flags = stream.readVarInt();
                if ((flags & 0x40) != 0) {
                    objects.add(OpenPrimitive.of(stream.readString()));
                    continue;
                }
                objects.add(OpenPrimitive.of(stream.readFloat()));
            }
            for (i = 0; i < objects.size(); i += 3) {
                OpenPrimitive x = (OpenPrimitive)objects.get(i);
                OpenPrimitive y = (OpenPrimitive)objects.get(i + 1);
                OpenPrimitive z = (OpenPrimitive)objects.get(i + 2);
                points.add(new SkinAnimationPoint.Bone(x, y, z));
            }
            return points;
        }
    }

    private static abstract class PointSerializer<T extends SkinAnimationPoint> {
        private static final List<PointSerializer<?>> SERIALIZERS = new ArrayList();
        private static final PointSerializer<?> BONE = new PointSerializer<SkinAnimationPoint.Bone>(8, SkinAnimationPoint.Bone.class){

            @Override
            public SkinAnimationPoint.Bone readFromStream(ChunkInputStream stream) throws IOException {
                OpenPrimitive x = 1.readField(stream);
                OpenPrimitive y = 1.readField(stream);
                OpenPrimitive z = 1.readField(stream);
                return new SkinAnimationPoint.Bone(x, y, z);
            }

            @Override
            public void writeToStream(SkinAnimationPoint.Bone value, ChunkOutputStream stream) throws IOException {
                1.writeField(value.x(), stream);
                1.writeField(value.y(), stream);
                1.writeField(value.z(), stream);
            }

            private static OpenPrimitive readField(ChunkInputStream stream) throws IOException {
                int len = stream.readVarInt();
                if (len == 0) {
                    return OpenPrimitive.of(stream.readFloat());
                }
                return OpenPrimitive.of(stream.readString(len));
            }

            private static void writeField(OpenPrimitive value, ChunkOutputStream stream) throws IOException {
                if (value.isString()) {
                    String script = value.stringValue();
                    stream.writeVarInt(script.length());
                    stream.writeString(script, script.length());
                } else if (value.isNumber()) {
                    stream.writeVarInt(0);
                    stream.writeFloat(value.floatValue());
                } else {
                    throw new IOException("can't write point value: " + String.valueOf(value));
                }
            }
        };
        private static final PointSerializer<?> INSTRUCT = new PointSerializer<SkinAnimationPoint.Instruct>(9, SkinAnimationPoint.Instruct.class){

            @Override
            public SkinAnimationPoint.Instruct readFromStream(ChunkInputStream stream) throws IOException {
                String script = stream.readString();
                return new SkinAnimationPoint.Instruct(script);
            }

            @Override
            public void writeToStream(SkinAnimationPoint.Instruct value, ChunkOutputStream stream) throws IOException {
                stream.writeString(value.script());
            }
        };
        private static final PointSerializer<?> SOUND = new PointSerializer<SkinAnimationPoint.Sound>(10, SkinAnimationPoint.Sound.class){

            @Override
            public SkinAnimationPoint.Sound readFromStream(ChunkInputStream stream) throws IOException {
                if (stream.fileVersion() < 23) {
                    String effect = stream.readString();
                    ChunkFile file = stream.readFile();
                    SkinSoundData sound = new SkinSoundData(file.name(), file.bytes(), SkinSoundProperties.EMPTY);
                    return new SkinAnimationPoint.Sound(effect, sound);
                }
                String effect = stream.readString();
                SkinSoundProperties properties = new SkinSoundProperties();
                properties.readFromStream(stream);
                ChunkFile file = stream.readFile();
                SkinSoundData sound = new SkinSoundData(file.name(), file.bytes(), properties);
                return new SkinAnimationPoint.Sound(effect, sound);
            }

            @Override
            public void writeToStream(SkinAnimationPoint.Sound value, ChunkOutputStream stream) throws IOException {
                SkinSoundData sound = value.provider();
                SkinSoundProperties properties = sound.properties();
                stream.writeString(value.effect());
                properties.writeToStream(stream);
                stream.writeFile(ChunkFile.audio(sound.name(), sound.buffer()));
            }
        };
        private static final PointSerializer<?> PARTICLE = new PointSerializer<SkinAnimationPoint.Particle>(11, SkinAnimationPoint.Particle.class){

            @Override
            public SkinAnimationPoint.Particle readFromStream(ChunkInputStream stream) throws IOException {
                String effect = stream.readString();
                Optional<String> locator = stream.readOptionalString();
                Optional<String> script = stream.readOptionalString();
                ChunkParticleData particleData = new ChunkParticleData();
                particleData.readFromStream(stream);
                return new SkinAnimationPoint.Particle(effect, locator.orElse(null), script.orElse(null), particleData.particle());
            }

            @Override
            public void writeToStream(SkinAnimationPoint.Particle value, ChunkOutputStream stream) throws IOException {
                SkinParticleData particle = value.provider();
                stream.writeString(value.effect());
                stream.writeOptionalString(value.locator());
                stream.writeOptionalString(value.script());
                ChunkParticleData particleData = new ChunkParticleData(particle);
                particleData.writeToStream(stream);
            }
        };
        private final int type;
        private final Class<?> valueClass;

        public PointSerializer(int type, Class<T> valueClass) {
            this.type = type;
            this.valueClass = valueClass;
            SERIALIZERS.add(this);
        }

        public static PointSerializer<?> byType(int type) {
            for (PointSerializer<?> serializer : SERIALIZERS) {
                if (serializer.type != type) continue;
                return serializer;
            }
            return null;
        }

        public static PointSerializer<?> byValue(SkinAnimationPoint value) {
            for (PointSerializer<?> serializer : SERIALIZERS) {
                if (!serializer.valueClass.isInstance(value)) continue;
                return serializer;
            }
            return null;
        }

        public abstract T readFromStream(ChunkInputStream var1) throws IOException;

        public abstract void writeToStream(T var1, ChunkOutputStream var2) throws IOException;
    }
}

