/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javax.imageio.ImageIO;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import moe.plushie.armourers_workshop.core.math.OpenRectangle2f;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenSize2f;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector2f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.math.OpenVector4f;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimation;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationFunction;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationKeyframe;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationLoop;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationPoint;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryOptions;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometrySet;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryType;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryTypes;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryVertex;
import moe.plushie.armourers_workshop.core.skin.geometry.collection.SkinGeometrySetV2;
import moe.plushie.armourers_workshop.core.skin.geometry.mesh.SkinMeshFace;
import moe.plushie.armourers_workshop.core.skin.molang.MolangVirtualMachine;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.OptimizeContext;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleData;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinSettings;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockExporter;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockParticle;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockParticleReader;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchAnimation;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchAnimator;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchCube;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchDisplay;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchElement;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchKeyframe;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchLocator;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchMesh;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchMeshFace;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchObject;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchOutliner;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchPack;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchTexture;
import moe.plushie.armourers_workshop.core.skin.sound.SkinSoundData;
import moe.plushie.armourers_workshop.core.skin.sound.SkinSoundProperties;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureAnimation;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureBox;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureData;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureOptions;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTexturePos;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureProperties;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.FileUtils;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import moe.plushie.armourers_workshop.core.utils.OpenItemTransforms;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;
import moe.plushie.armourers_workshop.core.utils.StreamUtils;
import moe.plushie.armourers_workshop.init.ModLog;
import org.jetbrains.annotations.Nullable;

public class BlockBenchExporter {
    protected SkinSettings settings = new SkinSettings();
    protected SkinProperties properties = new SkinProperties();
    protected OpenVector3f offset = OpenVector3f.ZERO;
    protected OpenVector3f displayOffset = OpenVector3f.ZERO;
    protected boolean isCulling = false;
    protected final BlockBenchPack pack;
    protected final MolangVirtualMachine virtualMachine;

    public BlockBenchExporter(BlockBenchPack pack) {
        this(pack, new MolangVirtualMachine());
    }

    public BlockBenchExporter(BlockBenchPack pack, MolangVirtualMachine virtualMachine) {
        this.pack = pack;
        this.virtualMachine = virtualMachine;
    }

    public Skin export() throws IOException {
        Bone rootBone = new Bone(this.pack, this.pack.rootOutliner(), null);
        OpenPoseStack poseStack = new OpenPoseStack();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-this.offset.x(), -this.offset.y(), -this.offset.z());
        Collections.eachTree(Collections.singleton(rootBone), it -> it.children, it -> it.transform(poseStack));
        rootBone.children.forEach(it -> it.convertToLocal(OpenVector3f.ZERO));
        HashSet<Integer> usedTextureIds = new HashSet<Integer>();
        Collections.eachTree(Collections.singleton(rootBone), it -> it.children, it -> {
            it.cubes.forEach(cube -> {
                usedTextureIds.add(cube.uv.getDefaultTextureId());
                cube.uv.forEachTextures((dir, textureId) -> usedTextureIds.add((Integer)textureId));
            });
            it.meshes.forEach(mesh -> mesh.faces.forEach(face -> usedTextureIds.add(face.textureId)));
        });
        TextureSet textureSet = new TextureSet(this.pack.resolution(), this.pack.textures(), usedTextureIds);
        SkinPart rootPart = this.exportRootPart(rootBone, textureSet);
        if (this.pack.itemTransforms() != null) {
            OpenItemTransforms itemTransforms = this.exportItemTransforms(this.pack.itemTransforms());
            this.settings.setItemTransforms(itemTransforms);
        }
        List<SkinAnimation> animations = this.exportAnimations(this.pack.animations());
        Skin.Builder builder = new Skin.Builder(SkinTypes.ADVANCED);
        builder.parts((List<SkinPart>)rootPart.children());
        builder.settings(this.settings);
        builder.properties(this.properties);
        builder.animations(animations);
        builder.version(25);
        return builder.build();
    }

    protected SkinPart exportRootPart(Bone bone, TextureSet textureSet) {
        SkinPart rootPart = this.exportPart(bone, textureSet);
        if (!rootPart.geometries().isEmpty()) {
            SkinPart.Builder builder = new SkinPart.Builder(SkinPartTypes.ADVANCED);
            builder.geometries((SkinGeometrySet<?>)rootPart.geometries());
            rootPart.addPart(builder.build());
        }
        return rootPart;
    }

    protected SkinPart exportPart(Bone bone, TextureSet textureSet) {
        SkinGeometrySetV2 geometries = new SkinGeometrySetV2();
        ArrayList<SkinPart> children = new ArrayList<SkinPart>();
        bone.children.forEach(it -> children.add(this.exportPart((Bone)it, textureSet)));
        bone.cubes.forEach(it -> geometries.addBox(this.exportCube((Cube)it, textureSet)));
        bone.meshes.forEach(it -> geometries.addMesh(this.exportMesh((Mesh)it, textureSet)));
        bone.locators.forEach(it -> children.add(this.exportLocator((Locator)it)));
        SkinPart.Builder builder = new SkinPart.Builder(SkinPartTypes.ADVANCED);
        builder.name(bone.name);
        builder.transform(OpenTransform3f.create(bone.origin, bone.rotation, OpenVector3f.ONE, bone.pivot, OpenVector3f.ZERO));
        builder.children(children);
        builder.geometries(geometries);
        return builder.build();
    }

    protected SkinPart exportLocator(Locator locator) {
        SkinPart.Builder builder = new SkinPart.Builder(SkinPartTypes.ADVANCED_LOCATOR);
        builder.name(locator.name);
        builder.transform(OpenTransform3f.create(locator.origin, locator.rotation, OpenVector3f.ONE));
        return builder.build();
    }

    protected SkinGeometrySetV2.Box exportCube(Cube cube, TextureSet texture) {
        float x = cube.origin.x();
        float y = cube.origin.y();
        float z = cube.origin.z();
        float w = cube.size.x();
        float h = cube.size.y();
        float d = cube.size.z();
        float inflate = cube.inflate;
        SkinTextureBox skyBox = texture.read(cube);
        if (inflate != 0.0f) {
            skyBox = skyBox.separated();
        }
        OpenRectangle3f rect = new OpenRectangle3f(x, y, z, w, h, d).inflate(inflate);
        SkinGeometryType type = cube.getType(this.isCulling());
        SkinGeometryOptions options = new SkinGeometryOptions();
        OpenTransform3f transform = OpenTransform3f.create(OpenVector3f.ZERO, cube.rotation, OpenVector3f.ONE, cube.pivot, OpenVector3f.ZERO);
        options.setRenderOrder(this.exportRenderOrder(cube.renderOrder));
        return new SkinGeometrySetV2.Box(rect, type, options, transform, skyBox);
    }

    protected SkinGeometrySetV2.Mesh exportMesh(Mesh mesh, TextureSet texture) {
        SkinGeometryType type = mesh.getType(this.isCulling());
        SkinGeometryOptions options = new SkinGeometryOptions();
        ArrayList<SkinMeshFace> faces = new ArrayList<SkinMeshFace>();
        OpenTransform3f transform = OpenTransform3f.create(mesh.origin, mesh.rotation, OpenVector3f.ONE, OpenVector3f.ZERO, OpenVector3f.ZERO);
        SkinTexturePos[] defaultTexturePos = new SkinTexturePos[1];
        AtomicInteger sequence = new AtomicInteger();
        mesh.faces.stream().sorted(Comparator.comparingInt(it -> it.vertices.size())).forEachOrdered(it -> {
            SkinTexturePos texturePos = texture.read((MeshFace)it);
            if (texturePos == null) {
                return;
            }
            int faceId = faces.size();
            ArrayList<SkinGeometryVertex> vertices = new ArrayList<SkinGeometryVertex>();
            it.vertices.forEach(it2 -> {
                int vertexId = sequence.getAndIncrement();
                OpenVector3f position = it2.position;
                OpenVector3f normal = it2.normal;
                OpenVector2f textureCoords = it2.textureCoords;
                vertices.add(new SkinGeometryVertex(vertexId, position, normal, textureCoords));
                TextureResolution.applyBoundary(texturePos.provider(), textureCoords.x(), textureCoords.y());
            });
            faces.add(new SkinMeshFace(faceId, type, options, transform, texturePos, vertices));
            defaultTexturePos[0] = texturePos;
        });
        options.setRenderOrder(this.exportRenderOrder(mesh.renderOrder));
        return new SkinGeometrySetV2.Mesh(type, options, transform, defaultTexturePos[0], faces);
    }

    protected OpenItemTransforms exportItemTransforms(Map<String, BlockBenchDisplay> transforms) {
        LinkedHashMap<String, BlockBenchDisplay> fullItemTransforms = new LinkedHashMap<String, BlockBenchDisplay>(transforms);
        OpenItemTransforms itemTransforms = new OpenItemTransforms();
        for (OpenItemDisplayContext value : OpenItemDisplayContext.values()) {
            if (fullItemTransforms.containsKey(value.serializedName())) continue;
            fullItemTransforms.put(value.serializedName(), new BlockBenchDisplay(OpenVector3f.ZERO, OpenVector3f.ZERO, OpenVector3f.ONE));
        }
        fullItemTransforms.forEach((name, transform) -> {
            OpenVector3f scale;
            OpenVector3f rotation;
            OpenVector3f translation = transform.translation().scaling(-1.0f, -1.0f, 1.0f);
            OpenTransform3f transform1 = OpenTransform3f.create(translation, rotation = transform.rotation().scaling(-1.0f, -1.0f, 1.0f), scale = transform.scale());
            if (!transform1.isIdentity()) {
                itemTransforms.put(name, transform1);
            }
        });
        if (!this.displayOffset.equals(OpenVector3f.ZERO) && !itemTransforms.isEmpty()) {
            OpenVector3f translation = this.displayOffset.scaling(-1.0f, -1.0f, 1.0f);
            OpenVector3f rotation = OpenVector3f.ZERO;
            OpenVector3f scale = OpenVector3f.ONE;
            itemTransforms.setOffset(OpenTransform3f.create(translation, rotation, scale));
        }
        return itemTransforms;
    }

    protected List<SkinAnimation> exportAnimations(List<BlockBenchAnimation> allAnimations) {
        ArrayList<SkinAnimation> results = new ArrayList<SkinAnimation>();
        Animator animator = new Animator(this.virtualMachine());
        allAnimations.forEach(animation -> {
            String name = animation.name();
            float duration = animation.duration();
            SkinAnimationLoop loop = animator.convertToAnimationLoop(animation.loop());
            Map<String, List<SkinAnimationKeyframe>> values = animator.exportAnimationKeyframes(animation.animators());
            if (values.isEmpty()) {
                return;
            }
            results.add(new SkinAnimation(name, duration, loop, values));
        });
        return results;
    }

    protected int exportRenderOrder(String name) {
        return switch (name) {
            case "behind" -> 1;
            case "in_front" -> 2;
            default -> 0;
        };
    }

    public void setOffset(OpenVector3f offset) {
        this.offset = offset;
    }

    public OpenVector3f offset() {
        return this.offset;
    }

    public void setDisplayOffset(OpenVector3f displayOffset) {
        this.displayOffset = displayOffset;
    }

    public OpenVector3f displayOffset() {
        return this.displayOffset;
    }

    public void setCulling(boolean culling) {
        this.isCulling = culling;
    }

    public boolean isCulling() {
        return this.isCulling;
    }

    public SkinSettings settings() {
        return this.settings;
    }

    public SkinProperties properties() {
        return this.properties;
    }

    public MolangVirtualMachine virtualMachine() {
        return this.virtualMachine;
    }

    protected static class Bone {
        public String id;
        public String name;
        public OpenVector3f origin;
        public OpenVector3f pivot;
        public OpenVector3f rotation;
        public Bone parent;
        public ArrayList<Bone> children = new ArrayList();
        public ArrayList<Cube> cubes = new ArrayList();
        public ArrayList<Mesh> meshes = new ArrayList();
        public ArrayList<Locator> locators = new ArrayList();
        public boolean mirror;

        public Bone(BlockBenchPack pack, BlockBenchOutliner outliner, @Nullable Bone parent) {
            this.id = outliner.uuid();
            this.name = outliner.name();
            this.mirror = false;
            this.origin = outliner.origin();
            this.pivot = outliner.origin();
            this.rotation = outliner.rotation();
            this.parent = parent;
            for (Object child : outliner.children()) {
                BlockBenchElement element;
                String ref;
                BlockBenchObject blockBenchObject;
                BlockBenchOutliner childOutliner;
                if (child instanceof BlockBenchOutliner && (childOutliner = (BlockBenchOutliner)child).allowExport()) {
                    this.children.add(new Bone(pack, childOutliner, this));
                }
                if (!(child instanceof String) || !((blockBenchObject = pack.getObject(ref = (String)child)) instanceof BlockBenchElement) || !(element = (BlockBenchElement)blockBenchObject).allowExport()) continue;
                if (element instanceof BlockBenchCube) {
                    BlockBenchCube cube = (BlockBenchCube)element;
                    this.cubes.add(new Cube(cube));
                }
                if (element instanceof BlockBenchMesh) {
                    BlockBenchMesh mesh = (BlockBenchMesh)element;
                    this.meshes.add(new Mesh(mesh));
                }
                if (!(element instanceof BlockBenchLocator)) continue;
                BlockBenchLocator locator = (BlockBenchLocator)element;
                this.locators.add(new Locator(locator));
            }
        }

        public void transform(OpenPoseStack poseStack) {
            this.origin = this.origin.transforming(poseStack.last().pose());
            this.pivot = this.pivot.transforming(poseStack.last().pose());
            this.rotation = this.rotation.transforming(poseStack.last().normal());
            this.cubes.forEach(it -> it.transform(poseStack));
            this.meshes.forEach(it -> it.transform(poseStack));
            this.locators.forEach(it -> it.transform(poseStack));
        }

        public void convertToLocal(OpenVector3f globalOffset) {
            OpenVector3f newOrigin = this.origin;
            OpenPoseStack poseStack = new OpenPoseStack();
            poseStack.translate(-newOrigin.x(), -newOrigin.y(), -newOrigin.z());
            this.transform(poseStack);
            this.origin = newOrigin.subtracting(globalOffset);
            this.pivot = OpenVector3f.ZERO;
            this.children.forEach(it -> it.convertToLocal(newOrigin));
        }
    }

    protected static class TextureSet {
        private static final String PATTERN = "^(.+)_([nes]+)(\\.\\w+)?$";
        private final OpenSize2f resolution;
        private final List<BlockBenchTexture> inputs;
        private final HashMap<Integer, SkinTextureData> allTexture = new HashMap();
        private final HashMap<String, SkinTextureData> loadedTextures = new HashMap();
        protected SkinTextureData textureData;
        protected SkinTextureData defaultTextureData;

        public TextureSet(OpenSize2f resolution, List<BlockBenchTexture> textureInputs, HashSet<Integer> usedTextureIds) throws IOException {
            this.resolution = resolution;
            this.inputs = textureInputs;
            this.load(usedTextureIds);
        }

        public void load(HashSet<Integer> usedTextureIds) throws IOException {
            for (Integer textureId : usedTextureIds) {
                if (textureId.compareTo(0) < 0 || textureId.compareTo(this.inputs.size()) >= 0) continue;
                BlockBenchTexture texture = this.inputs.get(textureId);
                SkinTextureData data = this.loadTextureData(texture);
                this.allTexture.put(textureId, data);
                if (this.defaultTextureData != null) continue;
                this.defaultTextureData = data;
            }
            this.textureData = this.defaultTextureData;
            if (this.textureData == null) {
                throw new IOException("error.bb.loadModel.noTexture");
            }
        }

        public SkinTextureData loadTextureData(BlockBenchTexture texture) throws IOException {
            SkinTextureData data = this.resolveTextureData(texture);
            ArrayList<SkinTextureData> variants = new ArrayList<SkinTextureData>();
            String parentName = texture.name().replaceAll(PATTERN, "$1$3");
            Collection<String> parentAttributes = this.getTextureAttributes(texture.name());
            for (BlockBenchTexture childTexture : this.inputs) {
                Collection<String> childAttributes;
                String childName = childTexture.name().replaceAll(PATTERN, "$1$3");
                if (!childName.equals(parentName) || childTexture == texture || !(childAttributes = this.getTextureAttributes(childTexture.name())).containsAll(parentAttributes)) continue;
                SkinTextureData childData = this.resolveTextureData(childTexture);
                if (data.properties().isEmissive()) {
                    childData.properties().setEmissive(true);
                }
                variants.add(childData);
            }
            data.setVariants(variants);
            TextureResolution.apply(data);
            return data;
        }

        public SkinTextureBox read(Cube cube) {
            TextureUV uv = cube.uv;
            OpenVector3f size = cube.size;
            SkinTextureData textureData = this.getTextureData(uv);
            SkinTextureBox skyBox = new SkinTextureBox(size.x(), size.y(), size.z(), cube.mirror, uv.getBase(), textureData);
            uv.forEach((dir, rect) -> {
                skyBox.putTextureRect((OpenDirection)dir, (OpenRectangle2f)rect);
                skyBox.putTextureProvider((OpenDirection)dir, this.getTextureData(uv, (OpenDirection)dir));
            });
            uv.forEachRotations((dir, rot) -> {
                SkinTextureOptions options = new SkinTextureOptions();
                options.setRotation((int)rot);
                skyBox.putTextureOptions((OpenDirection)dir, options);
            });
            for (OpenDirection dir2 : OpenDirection.values()) {
                SkinTexturePos pos = skyBox.getTexture(dir2);
                if (pos == null) continue;
                TextureResolution.applyBoundary(pos.provider(), pos.u(), pos.v());
            }
            return skyBox;
        }

        public SkinTexturePos read(MeshFace meshFace) {
            SkinTextureData textureData = this.allTexture.get(meshFace.textureId);
            if (textureData != null) {
                return new SkinTexturePos(0.0f, 0.0f, 0.0f, 0.0f, textureData);
            }
            return null;
        }

        protected SkinTextureData getTextureData(TextureUV uv) {
            return this.allTexture.get(uv.getDefaultTextureId());
        }

        protected SkinTextureData getTextureData(TextureUV uv, OpenDirection dir) {
            return this.allTexture.get(uv.getTextureId(dir));
        }

        private SkinTextureData resolveTextureData(BlockBenchTexture texture) throws IOException {
            SkinTextureData textureData = this.loadedTextures.get(texture.uuid());
            if (textureData != null) {
                return textureData;
            }
            String str = texture.source();
            String[] parts = str.split(";base64,");
            if (parts.length != 2) {
                throw new IOException("error.bb.loadModel.textureNotSupported");
            }
            byte[] imageBytes = Base64.getDecoder().decode(parts[1]);
            int imageFrame = this.resolveTextureFrame(texture, imageBytes);
            OpenSize2f size = this.resolveTextureSize(texture, imageFrame);
            SkinTextureAnimation animation = this.resolveTextureAnimation(texture, imageFrame);
            SkinTextureProperties properties = this.resolveTextureProperties(texture);
            properties.setTranslucent(this.hasTranslucentChannel(imageBytes));
            textureData = new SkinTextureData(texture.name(), size.width(), size.height(), animation, properties);
            textureData.load(Unpooled.wrappedBuffer((byte[])imageBytes));
            this.loadedTextures.put(texture.uuid(), textureData);
            return textureData;
        }

        private int resolveTextureFrame(BlockBenchTexture texture, byte[] imageBytes) throws IOException {
            OpenSize2f imageSize = texture.imageSize();
            if (imageSize == null) {
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageBytes));
                imageSize = new OpenSize2f(image.getWidth(), image.getHeight());
            }
            OpenSize2f textureSize = this.resolveTextureSize(texture, 1);
            if (textureSize.width == 0.0f || textureSize.height == 0.0f) {
                return 0;
            }
            int scaleHeight = OpenMath.floori(imageSize.width * (textureSize.height / textureSize.width));
            int height = OpenMath.floori(imageSize.height);
            int frame = OpenMath.floori(imageSize.height / (float)scaleHeight);
            if (frame * scaleHeight == height) {
                return frame;
            }
            return 0;
        }

        private OpenSize2f resolveTextureSize(BlockBenchTexture texture, int frameCount) {
            float width = this.resolution.width();
            float height = this.resolution.height();
            if (texture.textureSize() != null) {
                width = texture.textureSize().width();
                height = texture.textureSize().height();
            }
            if (frameCount > 1) {
                height *= (float)frameCount;
            }
            return new OpenSize2f(width, height);
        }

        private SkinTextureAnimation resolveTextureAnimation(BlockBenchTexture texture, int frameCount) {
            if (frameCount > 1) {
                int time = texture.frameTime() * 50;
                boolean interpolate = texture.frameInterpolate();
                SkinTextureAnimation.Mode mode = texture.frameMode();
                return new SkinTextureAnimation(time, frameCount, mode, interpolate);
            }
            return SkinTextureAnimation.EMPTY;
        }

        private SkinTextureProperties resolveTextureProperties(BlockBenchTexture texture) {
            SkinTextureProperties properties = texture.properties();
            Iterator<String> iterator = this.getTextureAttributes(texture.name()).iterator();
            while (iterator.hasNext()) {
                String attrib;
                switch (attrib = iterator.next()) {
                    case "n": {
                        properties.setNormal(true);
                        break;
                    }
                    case "e": {
                        properties.setEmissive(true);
                        break;
                    }
                    case "s": {
                        properties.setSpecular(true);
                    }
                }
            }
            return properties;
        }

        private Collection<String> getTextureAttributes(String name) {
            String attrib = name.replaceAll(PATTERN, "$2");
            if (attrib.equals(name)) {
                return Collections.emptyList();
            }
            HashSet<String> results = new HashSet<String>();
            for (byte ch : attrib.getBytes(StandardCharsets.UTF_8)) {
                results.add(String.valueOf((char)ch));
            }
            return results;
        }

        private boolean hasTranslucentChannel(byte[] imageBytes) throws IOException {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageBytes));
            if (!image.getColorModel().hasAlpha()) {
                return false;
            }
            int width = image.getWidth();
            int height = image.getHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int argb = image.getRGB(x, y);
                    int alpha = argb >> 24 & 0xFF;
                    if (alpha <= 0 || alpha >= 255) continue;
                    return true;
                }
            }
            return false;
        }
    }

    protected static class Locator {
        public String name;
        public OpenVector3f origin;
        public OpenVector3f rotation;

        public Locator(BlockBenchLocator locator) {
            this.name = locator.name();
            this.origin = locator.position();
            this.rotation = locator.rotation();
        }

        public void transform(OpenPoseStack poseStack) {
            this.origin = this.origin.transforming(poseStack.last().pose());
            this.rotation = this.rotation.transforming(poseStack.last().normal());
        }
    }

    protected static class Cube {
        public OpenVector3f origin;
        public OpenVector3f size;
        public OpenVector3f pivot;
        public OpenVector3f rotation;
        public TextureUV uv;
        public float inflate;
        public String renderOrder;
        public boolean mirror = false;

        public Cube(BlockBenchCube cube) {
            this.origin = cube.from();
            this.size = cube.to().subtracting(cube.from());
            this.inflate = cube.inflate();
            this.pivot = cube.origin();
            this.rotation = cube.rotation();
            this.uv = TextureUV.createUV(cube);
            this.renderOrder = cube.renderOrder();
        }

        public void transform(OpenPoseStack poseStack) {
            OpenVector4f center = new OpenVector4f(this.origin.x() + this.size.x() / 2.0f, this.origin.y() + this.size.y() / 2.0f, this.origin.z() + this.size.z() / 2.0f, 1.0f);
            center.transform(poseStack.last().pose());
            this.origin = new OpenVector3f(center.x() - this.size.x() / 2.0f, center.y() - this.size.y() / 2.0f, center.z() - this.size.z() / 2.0f);
            this.pivot = this.pivot.transforming(poseStack.last().pose());
            this.rotation = this.rotation.transforming(poseStack.last().normal());
        }

        public SkinGeometryType getType(boolean isCulling) {
            if (isCulling) {
                return SkinGeometryTypes.CUBE_CULL;
            }
            return SkinGeometryTypes.CUBE;
        }
    }

    protected static class Mesh {
        public String renderOrder;
        public OpenVector3f origin;
        public OpenVector3f pivot;
        public OpenVector3f rotation;
        public final List<MeshFace> faces = new ArrayList<MeshFace>();

        public Mesh(BlockBenchMesh mesh) {
            this.origin = mesh.origin();
            this.pivot = mesh.origin();
            this.rotation = mesh.rotation();
            this.renderOrder = mesh.renderOrder();
            for (Map.Entry<String, BlockBenchMeshFace> entry : mesh.faces().entrySet()) {
                try {
                    this.faces.add(new MeshFace(entry.getKey(), entry.getValue(), mesh));
                }
                catch (Exception exception) {}
            }
        }

        public void transform(OpenPoseStack poseStack) {
            this.origin = this.origin.transforming(poseStack.last().pose());
            this.pivot = this.pivot.transforming(poseStack.last().pose());
            this.rotation = this.rotation.transforming(poseStack.last().normal());
            OpenPoseStack fixedPoseStack = poseStack.copy();
            fixedPoseStack.last().pose().setTranslation(0.0f, 0.0f, 0.0f);
            this.faces.forEach(it -> it.transform(fixedPoseStack));
        }

        public SkinGeometryType getType(boolean isCulling) {
            return SkinGeometryTypes.MESH;
        }
    }

    protected static class Animator {
        private final MolangVirtualMachine virtualMachine;

        public Animator(MolangVirtualMachine virtualMachine) {
            this.virtualMachine = virtualMachine;
        }

        public Map<String, List<SkinAnimationKeyframe>> exportAnimationKeyframes(List<BlockBenchAnimator> animators) {
            LinkedHashMap<String, List<SkinAnimationKeyframe>> results = new LinkedHashMap<String, List<SkinAnimationKeyframe>>();
            for (BlockBenchAnimator animator : animators) {
                List keyframes = results.computeIfAbsent(animator.name(), k -> new ArrayList());
                for (BlockBenchKeyframe keyframe : animator.keyframes()) {
                    float time = keyframe.time();
                    String channel = keyframe.name();
                    SkinAnimationFunction function = Animator.convertToAnimationFunction(keyframe);
                    List<SkinAnimationPoint> points = this.exportAnimationPoints(keyframe, animator);
                    if (points.isEmpty()) continue;
                    keyframes.add(new SkinAnimationKeyframe(time, channel, function, points));
                }
            }
            return results;
        }

        public List<SkinAnimationPoint> exportAnimationPoints(BlockBenchKeyframe keyframe, BlockBenchAnimator animator) {
            String type = animator.type();
            String channel = keyframe.name();
            return Collections.compactMap(keyframe.points(), it -> this.exportAnimationPoint(type, channel, (Map<String, OpenPrimitive>)it));
        }

        protected SkinAnimationPoint exportAnimationPoint(String type, String channel, Map<String, OpenPrimitive> point) {
            return switch (type) {
                case "bone" -> this.exportAnimationBone(channel, point);
                case "effect" -> {
                    switch (channel) {
                        case "timeline": {
                            yield this.exportAnimationInstruct(point);
                        }
                        case "sound": {
                            yield this.exportAnimationSound(point);
                        }
                        case "particle": {
                            yield this.exportAnimationParticle(point);
                        }
                    }
                    throw new RuntimeException("a unknown effect channel of '" + channel + "'");
                }
                default -> throw new RuntimeException("a unknown type of '" + type + "'");
            };
        }

        protected SkinAnimationPoint.Instruct exportAnimationInstruct(Map<String, OpenPrimitive> point) {
            try {
                Expression expr;
                OpenPrimitive value = point.getOrDefault("script", OpenPrimitive.EMPTY_STRING);
                if (value.isString() && (expr = this.virtualMachine.compile(value.stringValue())).isMutable()) {
                    return new SkinAnimationPoint.Instruct(value.stringValue());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }

        protected SkinAnimationPoint.Bone exportAnimationBone(String channel, Map<String, OpenPrimitive> point) {
            OpenPrimitive x = this.convertToAnimationPoint(point.getOrDefault("x", OpenPrimitive.FLOAT_ZERO));
            OpenPrimitive y = this.convertToAnimationPoint(point.getOrDefault("y", OpenPrimitive.FLOAT_ZERO));
            OpenPrimitive z = this.convertToAnimationPoint(point.getOrDefault("z", OpenPrimitive.FLOAT_ZERO));
            if (channel.equals("position")) {
                y = this.convertToNegativeAnimationPoint(y);
            }
            return new SkinAnimationPoint.Bone(x, y, z);
        }

        protected SkinAnimationPoint.Sound exportAnimationSound(Map<String, OpenPrimitive> point) {
            String effect = point.getOrDefault("effect", OpenPrimitive.EMPTY_STRING).stringValue();
            String filePath = point.getOrDefault("file", OpenPrimitive.EMPTY_STRING).stringValue();
            if (effect.isEmpty() && filePath.isEmpty()) {
                return null;
            }
            SoundBuilder soundBuilder = new SoundBuilder(this.virtualMachine);
            return soundBuilder.build(effect, filePath);
        }

        protected SkinAnimationPoint.Particle exportAnimationParticle(Map<String, OpenPrimitive> point) {
            String effect = point.getOrDefault("effect", OpenPrimitive.EMPTY_STRING).stringValue();
            String locator = point.getOrDefault("locator", OpenPrimitive.EMPTY_STRING).stringValue();
            String script = point.getOrDefault("script", OpenPrimitive.EMPTY_STRING).stringValue();
            String filePath = point.getOrDefault("file", OpenPrimitive.EMPTY_STRING).stringValue();
            if (effect.isEmpty() && filePath.isEmpty()) {
                return null;
            }
            ParticleBuilder particleBuilder = new ParticleBuilder(this.virtualMachine);
            return particleBuilder.build(effect, locator, filePath, script);
        }

        public OpenPrimitive convertToAnimationPoint(OpenPrimitive value) {
            if (value.isNumber()) {
                return value;
            }
            if (value.isString()) {
                try {
                    String script = value.toString();
                    if (script.isEmpty()) {
                        return OpenPrimitive.FLOAT_ZERO;
                    }
                    Expression expr = this.virtualMachine.compile(script);
                    if (expr.isMutable()) {
                        return OpenPrimitive.of(script);
                    }
                    return OpenPrimitive.of((float)expr.compute(OptimizeContext.DEFAULT));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return OpenPrimitive.FLOAT_ZERO;
        }

        public OpenPrimitive convertToNegativeAnimationPoint(OpenPrimitive point) {
            if (point.isNumber()) {
                return OpenPrimitive.of(-point.floatValue());
            }
            if (point.isString()) {
                String script = "-(" + point.stringValue() + ")";
                return OpenPrimitive.of(script);
            }
            return point;
        }

        public SkinAnimationLoop convertToAnimationLoop(String value) {
            return switch (value) {
                case "once" -> SkinAnimationLoop.NONE;
                case "hold" -> SkinAnimationLoop.LAST_FRAME;
                case "loop" -> SkinAnimationLoop.LOOP;
                default -> SkinAnimationLoop.LOOP;
            };
        }

        public static SkinAnimationFunction convertToAnimationFunction(BlockBenchKeyframe keyframe) {
            return switch (keyframe.interpolation()) {
                case "bezier" -> SkinAnimationFunction.bezier(keyframe.parameters());
                case "linear" -> SkinAnimationFunction.linear();
                case "step" -> SkinAnimationFunction.step();
                case "smooth" -> SkinAnimationFunction.smooth();
                default -> SkinAnimationFunction.linear();
            };
        }

        protected static class SoundBuilder {
            private final MolangVirtualMachine virtualMachine;

            public SoundBuilder(MolangVirtualMachine virtualMachine) {
                this.virtualMachine = virtualMachine;
            }

            public SkinAnimationPoint.Sound build(String effect, String filePath) {
                if (effect != null && effect.contains(":")) {
                    SkinSoundProperties properties = this.resolveSoundProperties(effect);
                    SkinSoundData soundProvider = new SkinSoundData(null, Unpooled.EMPTY_BUFFER, properties);
                    return new SkinAnimationPoint.Sound(effect, soundProvider);
                }
                ByteBuf soundBytes = this.resolveSoundData(filePath);
                if (soundBytes == null) {
                    ModLog.warn("can't load data of: '{}', file: '{}'", effect, filePath);
                    return null;
                }
                String fileName = FileUtils.getBaseName(filePath);
                SkinSoundProperties properties = this.resolveSoundProperties(effect);
                SkinSoundData soundProvider = new SkinSoundData(null, soundBytes, properties);
                if (effect == null || effect.isEmpty()) {
                    effect = fileName;
                }
                return new SkinAnimationPoint.Sound(effect, soundProvider);
            }

            private SkinSoundProperties resolveSoundProperties(String name) {
                if (name == null || !name.contains("|")) {
                    return SkinSoundProperties.EMPTY;
                }
                String[] parts = name.split("\\|");
                SkinSoundProperties properties = new SkinSoundProperties();
                try {
                    if (parts.length > 1) {
                        properties.setVolume(Float.parseFloat(parts[1]));
                    }
                    if (parts.length > 2) {
                        properties.setPitch(Float.parseFloat(parts[2]));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return properties;
            }

            private ByteBuf resolveSoundData(String path) {
                try {
                    if (path == null || path.isEmpty()) {
                        return null;
                    }
                    byte[] bytes = StreamUtils.readFileToByteArray(new File(path));
                    return Unpooled.wrappedBuffer((byte[])bytes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }

        protected static class ParticleBuilder {
            private final MolangVirtualMachine virtualMachine;

            public ParticleBuilder(MolangVirtualMachine virtualMachine) {
                this.virtualMachine = virtualMachine;
            }

            public SkinAnimationPoint.Particle build(String effect, String locator, String filePath, String script) {
                if (effect != null && effect.contains(":")) {
                    ModLog.warn("can't support builtin particle '{}' now", effect);
                    return null;
                }
                BedrockParticle resolvedParticle = this.resolveParticleFile(filePath);
                if (resolvedParticle == null) {
                    ModLog.warn("can't load data of: '{}', file: '{}'", effect, filePath);
                    return null;
                }
                String fileName = FileUtils.getBaseName(filePath);
                SkinParticleData particleProvider = this.exportParticle(resolvedParticle);
                if (effect == null || effect.isEmpty()) {
                    effect = fileName;
                }
                return new SkinAnimationPoint.Particle(effect, locator, this.resolveScript(script), particleProvider);
            }

            protected SkinParticleData exportParticle(BedrockParticle particle) {
                BedrockExporter exporter = new BedrockExporter(null, this.virtualMachine);
                return exporter.exportParticle(particle);
            }

            private BedrockParticle resolveParticleFile(String path) {
                try {
                    if (path == null || path.isEmpty()) {
                        return null;
                    }
                    BedrockParticleReader reader = new BedrockParticleReader(new File(path));
                    return reader.readPack();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }

            private String resolveScript(String script) {
                try {
                    if (script == null) {
                        return null;
                    }
                    Expression expr = this.virtualMachine.compile(script);
                    if (!expr.isMutable()) {
                        return null;
                    }
                    return script;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
    }

    protected static class MeshFace {
        public String id;
        public int textureId;
        public ArrayList<MeshVertex> vertices = new ArrayList();

        public MeshFace(String id, BlockBenchMeshFace face, BlockBenchMesh mesh) {
            this.id = id;
            this.textureId = face.textureId();
            for (String vertexId : face.vertices()) {
                OpenVector3f position = mesh.vertices().get(vertexId);
                OpenVector2f textureCoords = face.uv().get(vertexId);
                this.vertices.add(new MeshVertex(id + "/" + vertexId, position, OpenVector3f.ZERO, textureCoords));
            }
            if (this.vertices.size() < 3) {
                throw new RuntimeException("error.bb.loadModel.wrongVertexCount");
            }
            this.sortVertices();
            this.rebuildNormals();
        }

        public void transform(OpenPoseStack poseStack) {
            this.vertices.forEach(it -> it.transform(poseStack));
        }

        private void rebuildNormals() {
            OpenVector3f a = this.vertices.get((int)1).position.subtracting(this.vertices.get((int)0).position);
            OpenVector3f b = this.vertices.get((int)2).position.subtracting(this.vertices.get((int)0).position);
            OpenVector3f n = a.crossing(b).normalizing();
            this.vertices.forEach(it -> {
                it.normal = n;
            });
        }

        private void sortVertices() {
            if (this.vertices.size() < 4) {
                return;
            }
            ArrayList<MeshVertex> sortedVertices = new ArrayList<MeshVertex>();
            if (this._test(this.vertices.get(1), this.vertices.get(2), this.vertices.get(0), this.vertices.get(3))) {
                sortedVertices.add(this.vertices.get(2));
                sortedVertices.add(this.vertices.get(0));
                sortedVertices.add(this.vertices.get(1));
                sortedVertices.add(this.vertices.get(3));
            } else if (this._test(this.vertices.get(0), this.vertices.get(1), this.vertices.get(2), this.vertices.get(3))) {
                sortedVertices.add(this.vertices.get(0));
                sortedVertices.add(this.vertices.get(2));
                sortedVertices.add(this.vertices.get(1));
                sortedVertices.add(this.vertices.get(3));
            } else {
                sortedVertices.addAll(this.vertices);
            }
            this.vertices = sortedVertices;
        }

        private boolean _test(MeshVertex base1, MeshVertex base2, MeshVertex top, MeshVertex check) {
            OpenVector3f normal = this._line_closestPointToPoint(base1.position, base2.position, top.position);
            float distance = this._plane_distanceToPoint(normal = normal.subtracting(top.position), base2.position, check.position);
            return distance > 0.0f;
        }

        private OpenVector3f _line_closestPointToPoint(OpenVector3f start, OpenVector3f end, OpenVector3f point) {
            OpenVector3f delta = end.subtracting(start);
            float startEnd2 = delta.dot(delta);
            float startEnd_startP = delta.dot(point.subtracting(start));
            float t = startEnd_startP / startEnd2;
            return delta.scaling(t).adding(start);
        }

        private float _plane_distanceToPoint(OpenVector3f normal, OpenVector3f point, OpenVector3f check) {
            float constant = -point.dot(normal);
            return normal.dot(check) + constant;
        }
    }

    protected static class MeshVertex {
        public String id;
        public OpenVector3f position;
        public OpenVector3f normal;
        public OpenVector2f textureCoords;

        public MeshVertex(String id, OpenVector3f position, OpenVector3f normal, OpenVector2f textureCoords) {
            this.id = id;
            this.position = position;
            this.normal = normal;
            this.textureCoords = textureCoords;
        }

        public void transform(OpenPoseStack poseStack) {
            this.position = this.position.transforming(poseStack.last().pose());
            this.normal = this.normal.transforming(poseStack.last().normal());
        }

        public MeshVertex copy() {
            return new MeshVertex(this.id, this.position, this.normal, this.textureCoords);
        }
    }

    protected static class TextureResolution {
        protected TextureResolution() {
        }

        public static void apply(SkinTextureData data) {
            int base = TextureResolution.by(data);
            Collection variants = data.variants();
            if (variants.isEmpty()) {
                data.setVariants(Collections.emptyList());
                return;
            }
            LinkedHashMap<Integer, SkinTextureData> secondaryTextures = new LinkedHashMap<Integer, SkinTextureData>();
            LinkedHashMap<Integer, List> additionalTextures = new LinkedHashMap<Integer, List>();
            secondaryTextures.put(base & 0xF0, data);
            for (SkinTextureData variant : variants) {
                int key2 = TextureResolution.by(variant);
                if ((key2 & 0xF) == 0) {
                    secondaryTextures.putIfAbsent(key2 & 0xF0, variant);
                    continue;
                }
                additionalTextures.computeIfAbsent(key2 & 0xF0, k -> new ArrayList()).add(variant);
            }
            secondaryTextures.forEach((key, provider) -> {
                int used = TextureResolution.by(provider) & 0xF;
                List values = additionalTextures.getOrDefault(key, new ArrayList());
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    int ck = TextureResolution.by((SkinTextureData)iterator.next()) & 0xF;
                    if ((used & ck) == ck) {
                        iterator.remove();
                    }
                    used |= ck;
                }
                provider.setVariants(values);
            });
            ArrayList<SkinTextureData> newVariants = new ArrayList<SkinTextureData>(secondaryTextures.values());
            newVariants.remove(data);
            newVariants.addAll(data.variants());
            data.setVariants(newVariants);
        }

        public static int by(SkinTextureData data) {
            int key = 0;
            SkinTextureProperties properties = data.properties();
            if (properties.isEmissive()) {
                key |= 0x10;
            }
            if (properties.isNormal()) {
                key |= 1;
            }
            if (properties.isSpecular()) {
                key |= 2;
            }
            return key;
        }

        public static void applyBoundary(SkinTextureData textureProvider, float u, float v) {
            if (u < 0.0f || v < 0.0f || u > textureProvider.width() || v > textureProvider.height()) {
                SkinTextureProperties properties = textureProvider.properties();
                properties.setClampToEdge(true);
            }
        }
    }

    protected static class TextureUV {
        public static final TextureUV EMPTY = new TextureUV();
        private final OpenVector2f base;
        private EnumMap<OpenDirection, Integer> rotations;
        private final EnumMap<OpenDirection, OpenRectangle2f> rects = new EnumMap(OpenDirection.class);
        private int defaultTextureId = -1;
        private EnumMap<OpenDirection, Integer> textureIds;

        public TextureUV() {
            this.base = null;
        }

        public TextureUV(OpenVector2f uv) {
            this.base = uv;
        }

        public static TextureUV createUV(BlockBenchCube element) {
            if (element.isBoxUV() && !element.isMirrorUV() && TextureUV.isAlignedSize(element)) {
                TextureUV uv = new TextureUV(element.uvOffset());
                element.faces().forEach((? super K dir, ? super V face) -> {
                    uv.setDefaultTextureId(face.textureId());
                    uv.setRotation((OpenDirection)dir, face.rotation());
                });
                return uv;
            }
            TextureUV uv = new TextureUV(null);
            uv.setDefaultTextureId(-1);
            element.faces().forEach((? super K dir, ? super V face) -> {
                OpenRectangle2f fixedRect;
                if (face.textureId() < 0) {
                    return;
                }
                OpenRectangle2f rect = face.rect();
                if (dir == OpenDirection.UP) {
                    fixedRect = rect.copy();
                    fixedRect.setX(rect.maxX());
                    fixedRect.setY(rect.maxY());
                    fixedRect.setWidth(-rect.width());
                    fixedRect.setHeight(-rect.height());
                    rect = fixedRect;
                }
                if (dir == OpenDirection.DOWN) {
                    fixedRect = rect.copy();
                    fixedRect.setX(rect.maxX());
                    fixedRect.setWidth(-rect.width());
                    rect = fixedRect;
                }
                uv.put((OpenDirection)dir, rect);
                uv.setRotation((OpenDirection)dir, face.rotation());
                uv.setTextureId((OpenDirection)dir, face.textureId());
            });
            return uv;
        }

        public static boolean isAlignedSize(BlockBenchCube element) {
            OpenVector3f size = element.from().subtracting(element.to());
            return size.x() % 1.0f == 0.0f && size.y() % 1.0f == 0.0f && size.z() % 1.0f == 0.0f;
        }

        public void forEach(BiConsumer<OpenDirection, OpenRectangle2f> consumer) {
            if (this.base == null) {
                this.rects.forEach(consumer);
            }
        }

        public void forEachRotations(BiConsumer<OpenDirection, Integer> consumer) {
            if (this.rotations != null) {
                this.rotations.forEach(consumer);
            }
        }

        public void forEachTextures(BiConsumer<OpenDirection, Integer> consumer) {
            if (this.textureIds != null) {
                this.textureIds.forEach(consumer);
            }
        }

        public void put(OpenDirection dir, OpenRectangle2f rect) {
            this.rects.put(dir, rect);
        }

        public void setRotation(OpenDirection dir, int rotation) {
            if (rotation == 0) {
                return;
            }
            if (this.rotations == null) {
                this.rotations = new EnumMap(OpenDirection.class);
            }
            this.rotations.put(dir, rotation);
        }

        public int getRotation(OpenDirection dir) {
            if (this.rotations != null) {
                return this.rotations.getOrDefault(dir, 0);
            }
            return 0;
        }

        public OpenVector2f getBase() {
            return this.base;
        }

        @Nullable
        public OpenRectangle2f getRect(OpenDirection dir) {
            return this.rects.get(dir);
        }

        public void setTextureId(OpenDirection dir, int textureId) {
            if (this.textureIds == null) {
                this.textureIds = new EnumMap(OpenDirection.class);
            }
            this.textureIds.put(dir, textureId);
        }

        public int getTextureId(OpenDirection dir) {
            if (this.textureIds != null) {
                return this.textureIds.getOrDefault(dir, this.defaultTextureId);
            }
            return this.defaultTextureId;
        }

        public void setDefaultTextureId(int defaultTextureId) {
            this.defaultTextureId = defaultTextureId;
        }

        public int getDefaultTextureId() {
            return this.defaultTextureId;
        }
    }
}

