/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.core.math.OpenAxisAlignedBoundingBox;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenTransformedBoundingBox;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentNode;

public class SkinDocumentCollider {
    public static HashMap<OpenVector3i, OpenRectangle3i> generateCollisionBox(SkinDocumentNode node) {
        ArrayList<OpenTransformedBoundingBox> boxes = SkinDocumentCollider.generateCollisionBox(node, new OpenPoseStack());
        LinkedHashMap<OpenVector3i, OpenRectangle3i> results = new LinkedHashMap<OpenVector3i, OpenRectangle3i>();
        for (OpenTransformedBoundingBox it : boxes) {
            OpenAxisAlignedBoundingBox box = it.transformedBoundingBox();
            int minX = OpenMath.floori(box.minX() + 8.0f);
            int minY = OpenMath.floori(box.minY() + 8.0f);
            int minZ = OpenMath.floori(box.minZ() + 8.0f);
            int maxX = OpenMath.ceili(box.maxX() + 8.0f);
            int maxY = OpenMath.ceili(box.maxY() + 8.0f);
            int maxZ = OpenMath.ceili(box.maxZ() + 8.0f);
            OpenRectangle3i tt = new OpenRectangle3i(minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ);
            int blockMinX = OpenMath.floori((float)minX / 16.0f);
            int blockMinY = OpenMath.floori((float)minY / 16.0f);
            int blockMinZ = OpenMath.floori((float)minZ / 16.0f);
            int blockMaxX = OpenMath.ceili((float)maxX / 16.0f);
            int blockMaxY = OpenMath.ceili((float)maxY / 16.0f);
            int blockMaxZ = OpenMath.ceili((float)maxZ / 16.0f);
            for (int z = blockMinZ; z <= blockMaxZ; ++z) {
                for (int y = blockMinY; y <= blockMaxY; ++y) {
                    for (int x = blockMinX; x <= blockMaxX; ++x) {
                        OpenRectangle3i rr = new OpenRectangle3i(x * 16, y * 16, z * 16, 16, 16, 16);
                        rr.intersection(tt);
                        if (rr.width() <= 0 || rr.height() <= 0 || rr.depth() <= 0) continue;
                        results.computeIfAbsent(new OpenVector3i(x, y, z), pos -> rr).union(rr);
                    }
                }
            }
        }
        return results;
    }

    private static ArrayList<OpenTransformedBoundingBox> generateCollisionBox(SkinDocumentNode node, OpenPoseStack poseStack) {
        ArrayList<OpenTransformedBoundingBox> result = new ArrayList<OpenTransformedBoundingBox>();
        if (node.id().equals("float")) {
            return result;
        }
        poseStack.pushPose();
        node.transform().apply(poseStack);
        Skin skin = SkinLoader.getInstance().loadSkin(node.skin().identifier());
        if (skin != null) {
            for (SkinPart part : skin.parts()) {
                result.addAll(SkinDocumentCollider.generateCollisionBox(part, poseStack));
            }
        }
        node.children().forEach(child -> result.addAll(SkinDocumentCollider.generateCollisionBox(child, poseStack)));
        poseStack.popPose();
        return result;
    }

    private static ArrayList<OpenTransformedBoundingBox> generateCollisionBox(SkinPart part, OpenPoseStack poseStack) {
        ArrayList<OpenTransformedBoundingBox> result = new ArrayList<OpenTransformedBoundingBox>();
        poseStack.pushPose();
        part.transform().apply(poseStack);
        part.geometries().forEach(geometry -> {
            poseStack.pushPose();
            geometry.transform().apply(poseStack);
            OpenAxisAlignedBoundingBox aabb = geometry.shape().aabb();
            OpenTransformedBoundingBox tbb = new OpenTransformedBoundingBox(poseStack.last().pose().copy(), aabb);
            result.add(tbb);
            poseStack.popPose();
        });
        part.children().forEach(child -> result.addAll(SkinDocumentCollider.generateCollisionBox(child, poseStack)));
        poseStack.popPose();
        return result;
    }
}

