/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.core.ast;

import moe.plushie.armourers_workshop.core.skin.molang.core.ExecutionContext;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.Optimizable;
import moe.plushie.armourers_workshop.core.skin.molang.core.Result;
import moe.plushie.armourers_workshop.core.skin.molang.core.Visitor;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.PrettyPrinter;

public final class Unary
implements Expression,
Optimizable {
    private final Operator op;
    private final Expression value;

    public Unary(Operator op, Expression value) {
        this.op = op;
        this.value = value;
    }

    @Override
    public Result evaluate(ExecutionContext context) {
        return this.op.evaluator.eval(context, this.value);
    }

    @Override
    public Expression visit(Visitor visitor) {
        return visitor.visitUnary(this);
    }

    @Override
    public boolean isMutable() {
        return this.value.isMutable();
    }

    public String toString() {
        return PrettyPrinter.toString(this);
    }

    public Operator op() {
        return this.op;
    }

    public Expression value() {
        return this.value;
    }

    public static enum Operator {
        LOGICAL_NEGATION("!", 2800, (context, expr) -> Result.valueOf(!expr.test(context))),
        ARITHMETICAL_NEGATION("-", 2800, (context, expr) -> Result.valueOf(-expr.compute(context))),
        ARITHMETICAL_PLUS("+", 2800, null);

        private final String symbol;
        private final Evaluator evaluator;
        private final int precedence;

        private Operator(String symbol, int precedence, Evaluator evaluator) {
            this.symbol = symbol;
            this.evaluator = evaluator;
            this.precedence = precedence;
        }

        public String symbol() {
            return this.symbol;
        }

        public int precedence() {
            return this.precedence;
        }
    }

    private static interface Evaluator {
        public Result eval(ExecutionContext var1, Expression var2);
    }
}

