/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.core.math.ITransform;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometrySet;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTransform;
import org.apache.commons.lang3.tuple.Pair;

public class SkinPreviewData {
    private final Collection<Pair<ITransform, SkinGeometrySet<?>>> allGeometries;

    public SkinPreviewData(Collection<Pair<ITransform, SkinGeometrySet<?>>> allGeometries) {
        this.allGeometries = allGeometries;
    }

    public static SkinPreviewData of(Skin skin) {
        if (skin.previewData() != null) {
            return skin.previewData();
        }
        ArrayList allCubes = new ArrayList();
        SkinPreviewData.eachPart(skin.parts(), part -> {
            OpenVector3i pos = part.type().renderOffset();
            OpenTransform3f offset = OpenTransform3f.createTranslateTransform(pos.x(), pos.y(), pos.z());
            SkinPartTransform transform = new SkinPartTransform((SkinPart)part, offset);
            allCubes.add(Pair.of((Object)transform, (Object)part.geometries()));
        });
        return new SkinPreviewData(allCubes);
    }

    private static void eachPart(Collection<SkinPart> parts, Consumer<SkinPart> consumer) {
        for (SkinPart part : parts) {
            consumer.accept(part);
            SkinPreviewData.eachPart(part.children(), consumer);
        }
    }

    public void forEach(BiConsumer<ITransform, SkinGeometrySet<?>> consumer) {
        this.allGeometries.forEach((? super T pair) -> consumer.accept((ITransform)pair.getKey(), (SkinGeometrySet)pair.getValue()));
    }
}

